/*
 * Decompiled with CFR 0.152.
 */
package com.music.minigolf.block;

import com.mojang.serialization.MapCodec;
import com.music.minigolf.block.entity.GolfTeeBlockEntity;
import com.music.minigolf.init.ModDataComponents;
import com.music.minigolf.init.ModItems;
import com.music.minigolf.item.GolfBallItem;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GolfTeeBlock
extends BaseEntityBlock {
    public static final MapCodec<GolfTeeBlock> CODEC = GolfTeeBlock.simpleCodec(GolfTeeBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty HAS_BALL = BooleanProperty.create((String)"has_ball");
    private static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);

    public GolfTeeBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HAS_BALL, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HAS_BALL});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)HAS_BALL, (Comparable)Boolean.valueOf(false));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GolfTeeBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.getItem() instanceof GolfBallItem && !((Boolean)state.getValue((Property)HAS_BALL)).booleanValue()) {
            if (!level.isClientSide()) {
                BlockEntity be = level.getBlockEntity(pos);
                if (be instanceof GolfTeeBlockEntity) {
                    GolfTeeBlockEntity tee = (GolfTeeBlockEntity)be;
                    String ownerName = (String)stack.get((DataComponentType)ModDataComponents.OWNER_NAME.get());
                    String ownerUUID = (String)stack.get((DataComponentType)ModDataComponents.OWNER_UUID.get());
                    if (ownerName == null || ownerName.isEmpty()) {
                        ownerName = player.getName().getString();
                        ownerUUID = player.getUUID().toString();
                    }
                    tee.setBallOwner(ownerName, ownerUUID);
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)HAS_BALL, (Comparable)Boolean.valueOf(true)), 3);
                stack.shrink(1);
                level.playSound(null, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.2f);
                player.displayClientMessage((Component)Component.translatable((String)"message.minigolf.ball_placed").withStyle(ChatFormatting.GREEN), true);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        if (((Boolean)state.getValue((Property)HAS_BALL)).booleanValue() && stack.isEmpty()) {
            if (!level.isClientSide()) {
                ItemStack ball = new ItemStack((ItemLike)ModItems.GOLF_BALL.get());
                BlockEntity be = level.getBlockEntity(pos);
                if (be instanceof GolfTeeBlockEntity) {
                    GolfTeeBlockEntity tee = (GolfTeeBlockEntity)be;
                    String ownerName = tee.getBallOwnerName();
                    String ownerUUID = tee.getBallOwnerUUID();
                    if (ownerName != null && !ownerName.isEmpty()) {
                        ball.set((DataComponentType)ModDataComponents.OWNER_NAME.get(), (Object)ownerName);
                    }
                    if (ownerUUID != null && !ownerUUID.isEmpty()) {
                        ball.set((DataComponentType)ModDataComponents.OWNER_UUID.get(), (Object)ownerUUID);
                    }
                    tee.clearBall();
                }
                if (!player.getInventory().add(ball)) {
                    player.drop(ball, false);
                }
                level.setBlock(pos, (BlockState)state.setValue((Property)HAS_BALL, (Comparable)Boolean.valueOf(false)), 3);
                level.playSound(null, pos, SoundEvents.ITEM_PICKUP, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide());
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        BlockEntity be;
        if (!state.is(newState.getBlock()) && ((Boolean)state.getValue((Property)HAS_BALL)).booleanValue() && (be = level.getBlockEntity(pos)) instanceof GolfTeeBlockEntity) {
            GolfTeeBlockEntity tee = (GolfTeeBlockEntity)be;
            ItemStack ball = new ItemStack((ItemLike)ModItems.GOLF_BALL.get());
            String ownerName = tee.getBallOwnerName();
            String ownerUUID = tee.getBallOwnerUUID();
            if (ownerName != null && !ownerName.isEmpty()) {
                ball.set((DataComponentType)ModDataComponents.OWNER_NAME.get(), (Object)ownerName);
            }
            if (ownerUUID != null && !ownerUUID.isEmpty()) {
                ball.set((DataComponentType)ModDataComponents.OWNER_UUID.get(), (Object)ownerUUID);
            }
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)ball);
        }
        super.onRemove(state, level, pos, newState, movedByPiston);
    }
}

