/*
 * Decompiled with CFR 0.152.
 */
package com.music.minigolf.block;

import com.mojang.serialization.MapCodec;
import com.music.minigolf.block.entity.WindFlagBlockEntity;
import com.music.minigolf.entity.GolfBallEntity;
import com.music.minigolf.init.ModBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WindFlagBlock
extends BaseEntityBlock {
    public static final MapCodec<WindFlagBlock> CODEC = WindFlagBlock.simpleCodec(WindFlagBlock::new);
    public static final IntegerProperty WIND_DIRECTION = IntegerProperty.create((String)"wind_direction", (int)0, (int)7);
    private static final VoxelShape SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public WindFlagBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WIND_DIRECTION, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WIND_DIRECTION});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)WIND_DIRECTION, (Comparable)Integer.valueOf(0));
    }

    protected VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new WindFlagBlockEntity(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.isClientSide()) {
            return WindFlagBlock.createTickerHelper(type, (BlockEntityType)((BlockEntityType)ModBlockEntities.WIND_FLAG.get()), WindFlagBlockEntity::serverTick);
        }
        return null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Vec3 wind = GolfBallEntity.getGlobalWind();
            double strength = wind.horizontalDistance();
            String direction = this.getWindDirectionName(wind);
            player.displayClientMessage((Component)Component.translatable((String)"message.minigolf.wind_info", (Object[])new Object[]{direction, String.format("%.1f", strength)}).withStyle(ChatFormatting.AQUA), true);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide());
    }

    private String getWindDirectionName(Vec3 wind) {
        if (wind.horizontalDistance() < 0.1) {
            return "Calm";
        }
        double angle = Math.atan2(wind.z, wind.x);
        if ((angle = Math.toDegrees(angle)) < 0.0) {
            angle += 360.0;
        }
        if (angle >= 337.5 || angle < 22.5) {
            return "E";
        }
        if (angle >= 22.5 && angle < 67.5) {
            return "SE";
        }
        if (angle >= 67.5 && angle < 112.5) {
            return "S";
        }
        if (angle >= 112.5 && angle < 157.5) {
            return "SW";
        }
        if (angle >= 157.5 && angle < 202.5) {
            return "W";
        }
        if (angle >= 202.5 && angle < 247.5) {
            return "NW";
        }
        if (angle >= 247.5 && angle < 292.5) {
            return "N";
        }
        return "NE";
    }

    public static int windToDirection(Vec3 wind) {
        if (wind.horizontalDistance() < 0.1) {
            return 0;
        }
        double angle = Math.atan2(wind.z, wind.x);
        if ((angle = Math.toDegrees(angle)) < 0.0) {
            angle += 360.0;
        }
        return (int)((angle + 22.5) / 45.0) % 8;
    }
}

