/*
 * Decompiled with CFR 0.152.
 */
package com.music.minigolf.block.entity;

import com.music.minigolf.config.MiniGolfConfig;
import com.music.minigolf.entity.GolfBallEntity;
import com.music.minigolf.init.ModBlockEntities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GolfHoleBlockEntity
extends BlockEntity {
    private double radius = (Double)MiniGolfConfig.DEFAULT_HOLE_RADIUS.get();

    public GolfHoleBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.GOLF_HOLE.get(), pos, state);
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        double min = (Double)MiniGolfConfig.MIN_HOLE_RADIUS.get();
        double max = (Double)MiniGolfConfig.MAX_HOLE_RADIUS.get();
        this.radius = Math.max(min, Math.min(max, radius));
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public void increaseRadius() {
        this.setRadius(this.radius + 0.5);
    }

    public void decreaseRadius() {
        this.setRadius(this.radius - 0.5);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, GolfHoleBlockEntity blockEntity) {
        Vec3 center = Vec3.atCenterOf((Vec3i)pos);
        AABB searchBox = new AABB(center, center).inflate(blockEntity.radius);
        List balls = level.getEntitiesOfClass(GolfBallEntity.class, searchBox);
        for (GolfBallEntity ball : balls) {
            double dx = ball.getX() - center.x;
            double dz = ball.getZ() - center.z;
            double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
            double yDiff = ball.getY() - (double)pos.getY();
            Vec3 motion = ball.getDeltaMovement();
            if (horizontalDistance <= 0.6 && yDiff >= -0.5 && yDiff <= 1.0) {
                ball.setDeltaMovement(Vec3.ZERO);
                ball.setPos(center.x, (double)pos.getY() + 1.5, center.z);
                level.playSound(null, pos, SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, center.x, (double)pos.getY() + 1.5, center.z, 15, 0.3, 0.3, 0.3, 0.05);
                }
                return;
            }
            if (!(horizontalDistance <= blockEntity.radius) || !(motion.length() < 0.3) || !(yDiff >= -0.5) || !(yDiff <= 1.0)) continue;
            double attractStrength = Math.min(0.05, horizontalDistance * 0.1);
            Vec3 toCenter = new Vec3(center.x - ball.getX(), 0.0, center.z - ball.getZ()).normalize().scale(attractStrength);
            Vec3 newMotion = motion.scale(0.9).add(toCenter);
            ball.setDeltaMovement(newMotion);
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putDouble("Radius", this.radius);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("Radius")) {
            this.radius = tag.getDouble("Radius");
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putDouble("Radius", this.radius);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

