/*
 * Decompiled with CFR 0.152.
 */
package com.music.minigolf.block.entity;

import com.music.minigolf.init.ModBlockEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class GolfTeeBlockEntity
extends BlockEntity {
    private String ballOwnerName = "";
    private String ballOwnerUUID = "";

    public GolfTeeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.GOLF_TEE.get(), pos, state);
    }

    public void setBallOwner(String name, String uuid) {
        this.ballOwnerName = name != null ? name : "";
        this.ballOwnerUUID = uuid != null ? uuid : "";
        this.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    public String getBallOwnerName() {
        return this.ballOwnerName;
    }

    public String getBallOwnerUUID() {
        return this.ballOwnerUUID;
    }

    public void clearBall() {
        this.ballOwnerName = "";
        this.ballOwnerUUID = "";
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putString("BallOwnerName", this.ballOwnerName);
        tag.putString("BallOwnerUUID", this.ballOwnerUUID);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.ballOwnerName = tag.getString("BallOwnerName");
        this.ballOwnerUUID = tag.getString("BallOwnerUUID");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag tag = super.getUpdateTag(registries);
        tag.putString("BallOwnerName", this.ballOwnerName);
        tag.putString("BallOwnerUUID", this.ballOwnerUUID);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

