/*
 * Decompiled with CFR 0.152.
 */
package com.music.minigolf.client;

import com.music.minigolf.item.GolfClubItem;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.LayeredDraw;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class PowerGaugeOverlay
implements LayeredDraw.Layer {
    public static final PowerGaugeOverlay INSTANCE = new PowerGaugeOverlay();
    private static final int BAR_WIDTH = 100;
    private static final int BAR_HEIGHT = 10;
    private static final int BAR_BORDER = 2;

    public void render(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack heldItem = player.getUseItem();
        Item item = heldItem.getItem();
        if (!(item instanceof GolfClubItem)) {
            return;
        }
        GolfClubItem club = (GolfClubItem)item;
        int useTicks = player.getTicksUsingItem();
        if (useTicks <= 0) {
            return;
        }
        float maxTicks = 40.0f;
        float progress = Math.min((float)useTicks / maxTicks, 1.0f);
        int screenWidth = guiGraphics.guiWidth();
        int screenHeight = guiGraphics.guiHeight();
        int x = (screenWidth - 100) / 2;
        int y = screenHeight / 2 + 30;
        guiGraphics.fill(x - 2, y - 2, x + 100 + 2, y + 10 + 2, -16777216);
        guiGraphics.fill(x, y, x + 100, y + 10, -13421773);
        int fillWidth = (int)(100.0f * progress);
        int color = this.getColorForProgress(progress);
        guiGraphics.fill(x, y, x + fillWidth, y + 10, color);
        String powerText = String.format("%.0f%%", Float.valueOf(progress * 100.0f));
        int textWidth = mc.font.width(powerText);
        guiGraphics.drawString(mc.font, powerText, x + (100 - textWidth) / 2, y - 12, 0xFFFFFF, true);
        String clubName = club.getClubType().getName().toUpperCase();
        int clubTextWidth = mc.font.width(clubName);
        guiGraphics.drawString(mc.font, clubName, x + (100 - clubTextWidth) / 2, y + 10 + 4, 16766720, true);
    }

    private int getColorForProgress(float progress) {
        if (progress < 0.5f) {
            int green = 255;
            int red = (int)(255.0f * (progress * 2.0f));
            return 0xFF000000 | red << 16 | green << 8;
        }
        int red = 255;
        int green = (int)(255.0f * (1.0f - (progress - 0.5f) * 2.0f));
        return 0xFF000000 | red << 16 | green << 8;
    }
}

