/*
 * Decompiled with CFR 0.152.
 */
package com.music.minigolf.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.music.minigolf.entity.GolfBallEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class GolfBallRenderer
extends EntityRenderer<GolfBallEntity> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minigolf", (String)"textures/entity/golf_ball.png");
    private static final int SEGMENTS = 12;
    private static final int RINGS = 8;
    private static final float RADIUS = 0.1f;
    private final Font font;

    public GolfBallRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.shadowRadius = 0.15f;
        this.font = context.getFont();
    }

    public void render(GolfBallEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.1f, 0.0f);
        if (entity.isRolling()) {
            Vec3 motion = entity.getDeltaMovement();
            float speed = (float)motion.horizontalDistance();
            float rotationAngle = ((float)entity.tickCount + partialTicks) * speed * 50.0f;
            float moveAngle = (float)Math.toDegrees(Math.atan2(motion.z, motion.x));
            poseStack.mulPose(Axis.YP.rotationDegrees(-moveAngle));
            poseStack.mulPose(Axis.ZP.rotationDegrees(-rotationAngle));
            poseStack.mulPose(Axis.YP.rotationDegrees(moveAngle));
        }
        this.renderSphere(poseStack, buffer, packedLight);
        poseStack.popPose();
        this.renderLabels(entity, poseStack, buffer, packedLight);
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
    }

    private void renderLabels(GolfBallEntity entity, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        double distanceSq = this.entityRenderDispatcher.distanceToSqr((Entity)entity);
        if (distanceSq > 4096.0) {
            return;
        }
        String ownerName = entity.getOwnerName();
        int strokeCount = entity.getStrokeCount();
        int nameColor = entity.getNameColor();
        String displayName = ownerName != null && !ownerName.isEmpty() ? ownerName : "Golf Ball";
        MutableComponent nameText = Component.literal((String)displayName);
        this.renderNameTagStyle((Component)nameText, poseStack, buffer, packedLight, 0.7f, nameColor | 0xFF000000);
        MutableComponent strokeText = Component.literal((String)("Coups: " + strokeCount));
        this.renderNameTagStyle((Component)strokeText, poseStack, buffer, packedLight, 0.45f, -1);
    }

    private void renderNameTagStyle(Component text, PoseStack poseStack, MultiBufferSource buffer, int packedLight, float yOffset, int color) {
        poseStack.pushPose();
        poseStack.translate(0.0, (double)yOffset, 0.0);
        poseStack.mulPose(this.entityRenderDispatcher.cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float bgOpacity = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int bgColor = (int)(bgOpacity * 255.0f) << 24;
        float halfWidth = -this.font.width((FormattedText)text) / 2;
        this.font.drawInBatch(text, halfWidth, 0.0f, color & 0xFFFFFF | 0x20000000, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, bgColor, packedLight);
        this.font.drawInBatch(text, halfWidth, 0.0f, color, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        poseStack.popPose();
    }

    private void renderSphere(PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        VertexConsumer vertexConsumer = buffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)TEXTURE));
        Matrix4f matrix = poseStack.last().pose();
        for (int ring = 0; ring < 8; ++ring) {
            float theta1 = (float)((double)ring * Math.PI / 8.0);
            float theta2 = (float)((double)(ring + 1) * Math.PI / 8.0);
            for (int seg = 0; seg < 12; ++seg) {
                float phi1 = (float)((double)(seg * 2) * Math.PI / 12.0);
                float phi2 = (float)((double)((seg + 1) * 2) * Math.PI / 12.0);
                float x1 = (float)((double)0.1f * Math.sin(theta1) * Math.cos(phi1));
                float y1 = (float)((double)0.1f * Math.cos(theta1));
                float z1 = (float)((double)0.1f * Math.sin(theta1) * Math.sin(phi1));
                float x2 = (float)((double)0.1f * Math.sin(theta1) * Math.cos(phi2));
                float y2 = (float)((double)0.1f * Math.cos(theta1));
                float z2 = (float)((double)0.1f * Math.sin(theta1) * Math.sin(phi2));
                float x3 = (float)((double)0.1f * Math.sin(theta2) * Math.cos(phi2));
                float y3 = (float)((double)0.1f * Math.cos(theta2));
                float z3 = (float)((double)0.1f * Math.sin(theta2) * Math.sin(phi2));
                float x4 = (float)((double)0.1f * Math.sin(theta2) * Math.cos(phi1));
                float y4 = (float)((double)0.1f * Math.cos(theta2));
                float z4 = (float)((double)0.1f * Math.sin(theta2) * Math.sin(phi1));
                float u1 = (float)seg / 12.0f;
                float u2 = (float)(seg + 1) / 12.0f;
                float v1 = (float)ring / 8.0f;
                float v2 = (float)(ring + 1) / 8.0f;
                float nx1 = x1 / 0.1f;
                float ny1 = y1 / 0.1f;
                float nz1 = z1 / 0.1f;
                float nx2 = x2 / 0.1f;
                float ny2 = y2 / 0.1f;
                float nz2 = z2 / 0.1f;
                float nx3 = x3 / 0.1f;
                float ny3 = y3 / 0.1f;
                float nz3 = z3 / 0.1f;
                float nx4 = x4 / 0.1f;
                float ny4 = y4 / 0.1f;
                float nz4 = z4 / 0.1f;
                this.addVertex(vertexConsumer, matrix, x1, y1, z1, u1, v1, nx1, ny1, nz1, packedLight);
                this.addVertex(vertexConsumer, matrix, x2, y2, z2, u2, v1, nx2, ny2, nz2, packedLight);
                this.addVertex(vertexConsumer, matrix, x3, y3, z3, u2, v2, nx3, ny3, nz3, packedLight);
                this.addVertex(vertexConsumer, matrix, x4, y4, z4, u1, v2, nx4, ny4, nz4, packedLight);
            }
        }
    }

    private void addVertex(VertexConsumer consumer, Matrix4f matrix, float x, float y, float z, float u, float v, float nx, float ny, float nz, int packedLight) {
        consumer.addVertex(matrix, x, y, z).setColor(255, 255, 255, 255).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(nx, ny, nz);
    }

    public ResourceLocation getTextureLocation(GolfBallEntity entity) {
        return TEXTURE;
    }

    public boolean shouldRender(GolfBallEntity entity, Frustum frustum, double camX, double camY, double camZ) {
        return true;
    }
}

