/*
 * Decompiled with CFR 0.152.
 */
package com.music.minigolf.config;

import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class MiniGolfConfig {
    public static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec SPEC;
    public static final ModConfigSpec.DoubleValue WIND_STRENGTH;
    public static final ModConfigSpec.BooleanValue WIND_ENABLED;
    public static final ModConfigSpec.IntValue WIND_CHANGE_INTERVAL;
    public static final ModConfigSpec.DoubleValue DEFAULT_HOLE_RADIUS;
    public static final ModConfigSpec.DoubleValue MAX_HOLE_RADIUS;
    public static final ModConfigSpec.DoubleValue MIN_HOLE_RADIUS;
    public static final ModConfigSpec.DoubleValue BALL_FRICTION;
    public static final ModConfigSpec.DoubleValue BALL_BOUNCE;
    public static final ModConfigSpec.IntValue BALL_LIFETIME;
    public static final ModConfigSpec.IntValue COLLISION_GRACE_PERIOD;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> BLOCK_FRICTION_MODIFIERS;
    public static final ModConfigSpec.DoubleValue PUTTER_POWER;
    public static final ModConfigSpec.DoubleValue IRON_POWER;
    public static final ModConfigSpec.DoubleValue WEDGE_POWER;
    public static final ModConfigSpec.DoubleValue SAND_WEDGE_POWER;
    public static final ModConfigSpec.DoubleValue DRIVER_POWER;

    static {
        BUILDER.push("Wind Settings");
        WIND_ENABLED = BUILDER.comment("Enable wind system").define("windEnabled", true);
        WIND_STRENGTH = BUILDER.comment("Base wind strength multiplier").defineInRange("windStrength", 1.0, 0.0, 5.0);
        WIND_CHANGE_INTERVAL = BUILDER.comment("How often wind direction changes (in ticks)").defineInRange("windChangeInterval", 6000, 100, 72000);
        BUILDER.pop();
        BUILDER.push("Golf Hole Settings");
        DEFAULT_HOLE_RADIUS = BUILDER.comment("Default radius for golf hole detection").defineInRange("defaultHoleRadius", 1.5, 0.5, 10.0);
        MIN_HOLE_RADIUS = BUILDER.comment("Minimum configurable hole radius").defineInRange("minHoleRadius", 0.5, 0.1, 5.0);
        MAX_HOLE_RADIUS = BUILDER.comment("Maximum configurable hole radius").defineInRange("maxHoleRadius", 5.0, 1.0, 20.0);
        BUILDER.pop();
        BUILDER.push("Ball Physics");
        BALL_FRICTION = BUILDER.comment("Ball friction (lower = slides more)").defineInRange("ballFriction", 0.95, 0.5, 1.0);
        BALL_BOUNCE = BUILDER.comment("Ball bounce factor").defineInRange("ballBounce", 0.6, 0.0, 1.0);
        BALL_LIFETIME = BUILDER.comment("Ball lifetime in ticks before despawn (0 = infinite)").defineInRange("ballLifetime", 0, 0, 72000);
        COLLISION_GRACE_PERIOD = BUILDER.comment("Collision grace period in ticks after hitting the ball (prevents collision with tee/ground)").defineInRange("collisionGracePeriod", 1, 0, 20);
        BLOCK_FRICTION_MODIFIERS = BUILDER.comment(new String[]{"Block-specific friction modifiers. Format: 'modid:blockname:multiplier'", "Multiplier > 1.0 = more friction (slower), < 1.0 = less friction (faster)", "Examples: sand slows down, ice speeds up"}).defineListAllowEmpty(List.of("blockFrictionModifiers"), () -> List.of("minecraft:sand:1.5", "minecraft:red_sand:1.5", "minecraft:gravel:1.3", "minecraft:soul_sand:1.8", "minecraft:mud:1.4", "minecraft:ice:0.4", "minecraft:packed_ice:0.3", "minecraft:blue_ice:0.2", "minecraft:frosted_ice:0.35", "minecraft:grass_block:1.1", "minecraft:dirt:1.15", "minecraft:coarse_dirt:1.2", "minecraft:podzol:1.15", "minecraft:mycelium:1.1"), entry -> {
            String s;
            return entry instanceof String && (s = (String)entry).split(":").length == 3;
        });
        BUILDER.pop();
        BUILDER.push("Club Power Settings");
        PUTTER_POWER = BUILDER.comment("Putter base power (ground shot)").defineInRange("putterPower", 0.5, 0.1, 3.0);
        IRON_POWER = BUILDER.comment("Iron base power (medium arc)").defineInRange("ironPower", 1.2, 0.1, 5.0);
        WEDGE_POWER = BUILDER.comment("Wedge base power (high arc)").defineInRange("wedgePower", 0.8, 0.1, 4.0);
        SAND_WEDGE_POWER = BUILDER.comment("Sand Wedge base power (very high arc, for bunkers)").defineInRange("sandWedgePower", 1.2, 0.1, 3.0);
        DRIVER_POWER = BUILDER.comment("Driver base power (long distance)").defineInRange("driverPower", 2.0, 0.1, 10.0);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

