/*
 * Decompiled with CFR 0.152.
 */
package com.music.minigolf.entity;

import com.music.minigolf.block.GolfTeeBlock;
import com.music.minigolf.config.MiniGolfConfig;
import com.music.minigolf.init.ModDataComponents;
import com.music.minigolf.init.ModItems;
import com.music.minigolf.item.GolfClubItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GolfBallEntity
extends Entity {
    private static final EntityDataAccessor<String> OWNER_NAME = SynchedEntityData.defineId(GolfBallEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> OWNER_UUID = SynchedEntityData.defineId(GolfBallEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> CLUB_TYPE = SynchedEntityData.defineId(GolfBallEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> IS_ROLLING = SynchedEntityData.defineId(GolfBallEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> STROKE_COUNT = SynchedEntityData.defineId(GolfBallEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> NAME_COLOR = SynchedEntityData.defineId(GolfBallEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final int[] BALL_COLORS = new int[]{0xFF5555, 0x55FF55, 0x5555FF, 0xFFFF55, 0xFF55FF, 0x55FFFF, 0xFFAA00, 0xAA00FF, 65450, 0xFFAAFF, 0xAAFF00, 43775};
    private int ticksExisted = 0;
    private boolean onGround = false;
    private double groundY = 0.0;
    private int stableTicks = 0;
    private int collisionGracePeriod = 0;
    private static Vec3 globalWind = Vec3.ZERO;
    private static long lastWindUpdate = 0L;
    private static final double GRAVITY = 0.03;
    private static final double AIR_RESISTANCE = 0.99;
    private static final double GROUND_FRICTION = 0.96;
    private static final double MIN_VELOCITY = 5.0E-4;
    private static final double BALL_RADIUS = 0.1;
    private static Map<String, Double> blockFrictionCache = null;
    private static long lastConfigReload = 0L;

    public GolfBallEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
        this.setNoGravity(true);
        this.noPhysics = false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(OWNER_NAME, (Object)"");
        builder.define(OWNER_UUID, (Object)"");
        builder.define(CLUB_TYPE, (Object)0);
        builder.define(IS_ROLLING, (Object)false);
        builder.define(STROKE_COUNT, (Object)0);
        builder.define(NAME_COLOR, (Object)0xFFFFFF);
    }

    public void setOwnerInfo(String name, String uuid) {
        this.entityData.set(OWNER_NAME, (Object)(name != null ? name : ""));
        this.entityData.set(OWNER_UUID, (Object)(uuid != null ? uuid : ""));
    }

    public void generateRandomColor() {
        int colorIndex = this.random.nextInt(BALL_COLORS.length);
        this.entityData.set(NAME_COLOR, (Object)BALL_COLORS[colorIndex]);
    }

    public int getNameColor() {
        return (Integer)this.entityData.get(NAME_COLOR);
    }

    public String getOwnerName() {
        return (String)this.entityData.get(OWNER_NAME);
    }

    public String getOwnerUUID() {
        return (String)this.entityData.get(OWNER_UUID);
    }

    public void setClubType(GolfClubItem.ClubType type) {
        this.entityData.set(CLUB_TYPE, (Object)type.ordinal());
    }

    public GolfClubItem.ClubType getClubType() {
        return GolfClubItem.ClubType.values()[(Integer)this.entityData.get(CLUB_TYPE)];
    }

    public boolean isRolling() {
        return (Boolean)this.entityData.get(IS_ROLLING);
    }

    public void setCollisionGracePeriod(int ticks) {
        this.collisionGracePeriod = ticks;
    }

    public int getStrokeCount() {
        return (Integer)this.entityData.get(STROKE_COUNT);
    }

    public void incrementStrokeCount() {
        this.entityData.set(STROKE_COUNT, (Object)(this.getStrokeCount() + 1));
    }

    public boolean isOwner(Player player) {
        String ownerUUID = this.getOwnerUUID();
        if (ownerUUID == null || ownerUUID.isEmpty()) {
            return true;
        }
        return player.getUUID().toString().equals(ownerUUID);
    }

    public void tick() {
        super.tick();
        ++this.ticksExisted;
        if (!this.level().isClientSide()) {
            this.updateWind();
            this.updatePhysics();
            int lifetime = (Integer)MiniGolfConfig.BALL_LIFETIME.get();
            if (lifetime > 0 && this.ticksExisted > lifetime) {
                this.dropBallItem();
                this.discard();
                return;
            }
        }
        if (this.level().isClientSide()) {
            this.spawnTrailParticles();
        }
    }

    private void updatePhysics() {
        if (this.collisionGracePeriod > 0) {
            --this.collisionGracePeriod;
        }
        Vec3 motion = this.getDeltaMovement();
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        if (this.collisionGracePeriod > 0) {
            motion = motion.add(0.0, -0.03, 0.0);
            if (((Boolean)MiniGolfConfig.WIND_ENABLED.get()).booleanValue()) {
                Vec3 windEffect = globalWind.scale(0.001 * (Double)MiniGolfConfig.WIND_STRENGTH.get());
                motion = motion.add(windEffect);
            }
            motion = motion.scale(0.99);
            this.setDeltaMovement(motion);
            this.setPos(x + motion.x, y + motion.y, z + motion.z);
            return;
        }
        double newGroundY = this.findGroundLevel(x, y, z);
        boolean wasOnGround = this.onGround;
        if (y <= newGroundY + 0.01) {
            this.onGround = true;
            this.groundY = newGroundY;
            if (!wasOnGround && motion.y < -0.02) {
                double bounce = (Double)MiniGolfConfig.BALL_BOUNCE.get();
                double newYVel = -motion.y * bounce;
                if (newYVel > 0.015) {
                    motion = new Vec3(motion.x * 0.8, newYVel, motion.z * 0.8);
                    this.level().playSound(null, x, y, z, SoundEvents.SLIME_BLOCK_FALL, SoundSource.NEUTRAL, 0.3f, 1.6f);
                    this.stableTicks = 0;
                } else {
                    motion = new Vec3(motion.x, 0.0, motion.z);
                    ++this.stableTicks;
                }
            } else {
                double frictionMod = this.getBlockFrictionMultiplier(x, y, z);
                double effectiveFriction = 1.0 - 0.040000000000000036 * frictionMod;
                motion = new Vec3(motion.x * effectiveFriction, 0.0, motion.z * effectiveFriction);
                ++this.stableTicks;
            }
            y = this.groundY;
        } else {
            this.onGround = false;
            this.stableTicks = 0;
            motion = motion.add(0.0, -0.03, 0.0);
            if (((Boolean)MiniGolfConfig.WIND_ENABLED.get()).booleanValue()) {
                Vec3 windEffect = globalWind.scale(0.001 * (Double)MiniGolfConfig.WIND_STRENGTH.get());
                motion = motion.add(windEffect);
            }
        }
        motion = motion.scale(0.99);
        if (this.onGround && motion.horizontalDistance() < 5.0E-4 && this.stableTicks > 5) {
            motion = Vec3.ZERO;
        }
        this.entityData.set(IS_ROLLING, (Object)(this.onGround && motion.horizontalDistance() > 0.005 ? 1 : 0));
        this.setDeltaMovement(motion);
        double newX = x + motion.x;
        double newY = this.onGround ? this.groundY : y + motion.y;
        double newZ = z + motion.z;
        Vec3 adjustedPos = this.handleWallCollisions(x, y, z, newX, newY, newZ, motion);
        newX = adjustedPos.x;
        newZ = adjustedPos.z;
        this.setPos(newX, newY, newZ);
    }

    private double findGroundLevel(double x, double y, double z) {
        for (int checkY = (int)Math.ceil(y); checkY >= (int)y - 2; --checkY) {
            VoxelShape shape;
            BlockPos pos = BlockPos.containing((double)x, (double)checkY, (double)z);
            BlockState state = this.level().getBlockState(pos);
            if (state.getBlock() instanceof GolfTeeBlock || state.isAir() || (shape = state.getCollisionShape((BlockGetter)this.level(), pos)).isEmpty()) continue;
            double maxY = (double)pos.getY() + shape.max(Direction.Axis.Y);
            return maxY;
        }
        return Double.NEGATIVE_INFINITY;
    }

    private Vec3 handleWallCollisions(double oldX, double oldY, double oldZ, double newX, double newY, double newZ, Vec3 motion) {
        double bounce = (Double)MiniGolfConfig.BALL_BOUNCE.get() * 0.7;
        BlockPos posX = BlockPos.containing((double)newX, (double)(oldY + 0.1), (double)oldZ);
        BlockState stateX = this.level().getBlockState(posX);
        if (!(stateX.getBlock() instanceof GolfTeeBlock || stateX.isAir() || stateX.getCollisionShape((BlockGetter)this.level(), posX).isEmpty())) {
            newX = oldX;
            double newMotionX = -motion.x * bounce;
            this.setDeltaMovement(newMotionX, this.getDeltaMovement().y, this.getDeltaMovement().z);
            if (Math.abs(motion.x) > 0.03) {
                this.level().playSound(null, oldX, oldY, oldZ, SoundEvents.SLIME_BLOCK_HIT, SoundSource.NEUTRAL, 0.2f, 1.5f);
            }
        }
        BlockPos posZ = BlockPos.containing((double)newX, (double)(oldY + 0.1), (double)newZ);
        BlockState stateZ = this.level().getBlockState(posZ);
        if (!(stateZ.getBlock() instanceof GolfTeeBlock || stateZ.isAir() || stateZ.getCollisionShape((BlockGetter)this.level(), posZ).isEmpty())) {
            newZ = oldZ;
            double newMotionZ = -motion.z * bounce;
            this.setDeltaMovement(this.getDeltaMovement().x, this.getDeltaMovement().y, newMotionZ);
            if (Math.abs(motion.z) > 0.03) {
                this.level().playSound(null, oldX, oldY, oldZ, SoundEvents.SLIME_BLOCK_HIT, SoundSource.NEUTRAL, 0.2f, 1.5f);
            }
        }
        return new Vec3(newX, newY, newZ);
    }

    private void updateWind() {
        int changeInterval;
        long gameTime = this.level().getGameTime();
        if (gameTime - lastWindUpdate > (long)(changeInterval = ((Integer)MiniGolfConfig.WIND_CHANGE_INTERVAL.get()).intValue()) || lastWindUpdate == 0L) {
            double angle = this.random.nextDouble() * Math.PI * 2.0;
            double strength = this.random.nextDouble() * 2.0;
            globalWind = new Vec3(Math.cos(angle) * strength, 0.0, Math.sin(angle) * strength);
            lastWindUpdate = gameTime;
        }
    }

    public static Vec3 getGlobalWind() {
        return globalWind;
    }

    private static void loadBlockFrictionConfig() {
        blockFrictionCache = new HashMap<String, Double>();
        for (String entry : (List)MiniGolfConfig.BLOCK_FRICTION_MODIFIERS.get()) {
            String[] parts = entry.split(":");
            if (parts.length != 3) continue;
            try {
                String blockId = parts[0] + ":" + parts[1];
                double multiplier = Double.parseDouble(parts[2]);
                blockFrictionCache.put(blockId, multiplier);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private double getBlockFrictionMultiplier(double x, double y, double z) {
        ResourceLocation blockId;
        String blockIdStr;
        if (blockFrictionCache == null || this.ticksExisted % 100 == 0 && this.level().getGameTime() != lastConfigReload) {
            GolfBallEntity.loadBlockFrictionConfig();
            lastConfigReload = this.level().getGameTime();
        }
        BlockPos belowPos = BlockPos.containing((double)x, (double)(y - 0.1), (double)z);
        BlockState belowState = this.level().getBlockState(belowPos);
        if (belowState.isAir()) {
            belowPos = BlockPos.containing((double)x, (double)(y - 1.0), (double)z);
            belowState = this.level().getBlockState(belowPos);
        }
        if (!belowState.isAir() && blockFrictionCache.containsKey(blockIdStr = (blockId = BuiltInRegistries.BLOCK.getKey((Object)belowState.getBlock())).toString())) {
            return blockFrictionCache.get(blockIdStr);
        }
        return 1.0;
    }

    private void spawnTrailParticles() {
        Vec3 motion = this.getDeltaMovement();
        double speed = motion.length();
        if (speed > 0.02) {
            if (this.isRolling()) {
                if (this.random.nextFloat() < 0.3f) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.DUST_PLUME, this.getX(), this.getY() + 0.05, this.getZ(), -motion.x * 0.1, 0.02, -motion.z * 0.1);
                }
            } else if (speed > 0.08) {
                this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, this.getX(), this.getY() + 0.1, this.getZ(), -motion.x * 0.02, -motion.y * 0.02, -motion.z * 0.02);
            }
        }
    }

    public void onEnteredHole() {
        if (this.level().isClientSide()) {
            return;
        }
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.HAPPY_VILLAGER, this.getX(), this.getY() + 0.5, this.getZ(), 20, 0.5, 0.5, 0.5, 0.1);
        }
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.NEUTRAL, 1.0f, 1.0f);
        this.returnBallToOwner();
        this.discard();
    }

    private void returnBallToOwner() {
        String uuidStr = this.getOwnerUUID();
        if (uuidStr == null || uuidStr.isEmpty()) {
            this.dropBallItem();
            return;
        }
        try {
            UUID ownerUUID = UUID.fromString(uuidStr);
            Player owner = this.level().getPlayerByUUID(ownerUUID);
            if (owner != null) {
                ItemStack ball = new ItemStack((ItemLike)ModItems.GOLF_BALL.get());
                ball.set((DataComponentType)ModDataComponents.OWNER_NAME.get(), (Object)this.getOwnerName());
                ball.set((DataComponentType)ModDataComponents.OWNER_UUID.get(), (Object)uuidStr);
                if (!owner.getInventory().add(ball)) {
                    owner.drop(ball, false);
                }
            } else {
                this.dropBallItem();
            }
        }
        catch (IllegalArgumentException e) {
            this.dropBallItem();
        }
    }

    private void dropBallItem() {
        if (!this.level().isClientSide()) {
            ItemStack ball = new ItemStack((ItemLike)ModItems.GOLF_BALL.get());
            String ownerName = this.getOwnerName();
            String ownerUUID = this.getOwnerUUID();
            if (ownerName != null && !ownerName.isEmpty()) {
                ball.set((DataComponentType)ModDataComponents.OWNER_NAME.get(), (Object)ownerName);
            }
            if (ownerUUID != null && !ownerUUID.isEmpty()) {
                ball.set((DataComponentType)ModDataComponents.OWNER_UUID.get(), (Object)ownerUUID);
            }
            this.spawnAtLocation(ball);
        }
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
        if (tag.contains("OwnerName")) {
            this.entityData.set(OWNER_NAME, (Object)tag.getString("OwnerName"));
        }
        if (tag.contains("OwnerUUID")) {
            this.entityData.set(OWNER_UUID, (Object)tag.getString("OwnerUUID"));
        }
        if (tag.contains("ClubType")) {
            this.entityData.set(CLUB_TYPE, (Object)tag.getInt("ClubType"));
        }
        if (tag.contains("StrokeCount")) {
            this.entityData.set(STROKE_COUNT, (Object)tag.getInt("StrokeCount"));
        }
        if (tag.contains("NameColor")) {
            this.entityData.set(NAME_COLOR, (Object)tag.getInt("NameColor"));
        }
        this.ticksExisted = tag.getInt("TicksExisted");
        this.onGround = tag.getBoolean("OnGround");
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
        tag.putString("OwnerName", this.getOwnerName());
        tag.putString("OwnerUUID", this.getOwnerUUID());
        tag.putInt("ClubType", ((Integer)this.entityData.get(CLUB_TYPE)).intValue());
        tag.putInt("StrokeCount", this.getStrokeCount());
        tag.putInt("NameColor", this.getNameColor());
        tag.putInt("TicksExisted", this.ticksExisted);
        tag.putBoolean("OnGround", this.onGround);
    }

    public boolean isPickable() {
        return true;
    }

    public boolean skipAttackInteraction(Entity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Vec3 motion = this.getDeltaMovement();
            if (motion.length() < 0.03) {
                if (!this.level().isClientSide()) {
                    ItemStack ball = new ItemStack((ItemLike)ModItems.GOLF_BALL.get());
                    String ownerName = this.getOwnerName();
                    String ownerUUID = this.getOwnerUUID();
                    if (ownerName != null && !ownerName.isEmpty()) {
                        ball.set((DataComponentType)ModDataComponents.OWNER_NAME.get(), (Object)ownerName);
                    }
                    if (ownerUUID != null && !ownerUUID.isEmpty()) {
                        ball.set((DataComponentType)ModDataComponents.OWNER_UUID.get(), (Object)ownerUUID);
                    }
                    if (!player.getInventory().add(ball)) {
                        player.drop(ball, false);
                    }
                    this.discard();
                }
                return true;
            }
        }
        return super.skipAttackInteraction(entity);
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.getItem() instanceof GolfClubItem) {
            return InteractionResult.PASS;
        }
        Vec3 motion = this.getDeltaMovement();
        if (motion.length() < 0.03) {
            if (!this.level().isClientSide()) {
                ItemStack ball = new ItemStack((ItemLike)ModItems.GOLF_BALL.get());
                String ownerName = this.getOwnerName();
                String ownerUUID = this.getOwnerUUID();
                if (ownerName != null && !ownerName.isEmpty()) {
                    ball.set((DataComponentType)ModDataComponents.OWNER_NAME.get(), (Object)ownerName);
                }
                if (ownerUUID != null && !ownerUUID.isEmpty()) {
                    ball.set((DataComponentType)ModDataComponents.OWNER_UUID.get(), (Object)ownerUUID);
                }
                if (!player.getInventory().add(ball)) {
                    player.drop(ball, false);
                }
                this.discard();
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide());
        }
        return InteractionResult.PASS;
    }

    public boolean isStopped() {
        return this.getDeltaMovement().length() < 0.03;
    }
}

