/*
 * Decompiled with CFR 0.152.
 */
package com.music.minigolf.item;

import com.music.minigolf.init.ModDataComponents;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class GolfBallItem
extends Item {
    public GolfBallItem(Item.Properties properties) {
        super(properties);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (!level.isClientSide() && entity instanceof Player) {
            Player player = (Player)entity;
            if (!stack.has((DataComponentType)ModDataComponents.OWNER_NAME.get())) {
                stack.set((DataComponentType)ModDataComponents.OWNER_NAME.get(), (Object)player.getName().getString());
                stack.set((DataComponentType)ModDataComponents.OWNER_UUID.get(), (Object)player.getUUID().toString());
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        String ownerName = (String)stack.get((DataComponentType)ModDataComponents.OWNER_NAME.get());
        if (ownerName != null && !ownerName.isEmpty()) {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.minigolf.owner", (Object[])new Object[]{ownerName}).withStyle(ChatFormatting.GRAY));
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.minigolf.no_owner").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
    }

    public Component getName(ItemStack stack) {
        String ownerName = (String)stack.get((DataComponentType)ModDataComponents.OWNER_NAME.get());
        if (ownerName != null && !ownerName.isEmpty()) {
            return Component.translatable((String)"item.minigolf.golf_ball.owned", (Object[])new Object[]{ownerName});
        }
        return super.getName(stack);
    }

    public static String getOwnerName(ItemStack stack) {
        return (String)stack.get((DataComponentType)ModDataComponents.OWNER_NAME.get());
    }

    public static String getOwnerUUID(ItemStack stack) {
        return (String)stack.get((DataComponentType)ModDataComponents.OWNER_UUID.get());
    }

    public static void setOwner(ItemStack stack, Player player) {
        stack.set((DataComponentType)ModDataComponents.OWNER_NAME.get(), (Object)player.getName().getString());
        stack.set((DataComponentType)ModDataComponents.OWNER_UUID.get(), (Object)player.getUUID().toString());
    }
}

