/*
 * Decompiled with CFR 0.152.
 */
package com.music.minigolf.item;

import com.music.minigolf.block.GolfTeeBlock;
import com.music.minigolf.block.entity.GolfTeeBlockEntity;
import com.music.minigolf.config.MiniGolfConfig;
import com.music.minigolf.entity.GolfBallEntity;
import com.music.minigolf.init.ModDataComponents;
import com.music.minigolf.init.ModEntities;
import com.music.minigolf.item.GolfBallItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class GolfClubItem
extends Item {
    private final ClubType clubType;
    private static final int SEARCH_RADIUS = 5;

    public GolfClubItem(Item.Properties properties, ClubType clubType) {
        super(properties);
        this.clubType = clubType;
    }

    public ClubType getClubType() {
        return this.clubType;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        TeeWithBall teeInfo = this.findNearbyTeeWithBall(level, player);
        GolfBallEntity groundBall = this.findNearbyGroundBall(level, player);
        boolean hasBallInInventory = this.hasGolfBallInInventory(player);
        if (teeInfo == null && groundBall == null && !hasBallInInventory) {
            if (level.isClientSide()) {
                player.displayClientMessage((Component)Component.translatable((String)"message.minigolf.no_ball").withStyle(ChatFormatting.RED), true);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entity, int timeLeft) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (level.isClientSide()) {
            return;
        }
        int useDuration = this.getUseDuration(stack, entity) - timeLeft;
        float power = this.calculatePower(useDuration);
        TeeWithBall teeInfo = this.findNearbyTeeWithBall(level, player);
        if (teeInfo != null) {
            this.shootBallFromTee(level, player, power, teeInfo);
        } else {
            GolfBallEntity groundBall = this.findNearbyGroundBall(level, player);
            if (groundBall != null) {
                this.shootGroundBall(level, player, power, groundBall);
            } else {
                this.shootBallFromInventory(level, player, power);
            }
        }
        stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
    }

    private void shootBallFromTee(Level level, Player player, float power, TeeWithBall teeInfo) {
        Vec3 lookVec = player.getLookAngle();
        Vec3 horizontalLook = new Vec3(lookVec.x, 0.0, lookVec.z).normalize();
        double totalPower = this.clubType.getBasePower() * (double)this.clubType.getPowerMultiplier() * (double)power;
        double angle = (double)this.clubType.getLaunchAngle() * Math.PI / 2.5;
        double horizontalPower = totalPower * Math.cos(angle);
        double verticalPower = totalPower * Math.sin(angle);
        Vec3 velocity = new Vec3(horizontalLook.x * horizontalPower, verticalPower, horizontalLook.z * horizontalPower);
        GolfBallEntity ball = new GolfBallEntity((EntityType)ModEntities.GOLF_BALL.get(), level);
        double ballX = (double)teeInfo.pos.getX() + 0.5 + horizontalLook.x * 0.3;
        double ballY = (double)teeInfo.pos.getY() + 0.5;
        double ballZ = (double)teeInfo.pos.getZ() + 0.5 + horizontalLook.z * 0.3;
        ball.setPos(ballX, ballY, ballZ);
        ball.setDeltaMovement(velocity);
        ball.setOwnerInfo(teeInfo.ownerName, teeInfo.ownerUUID);
        ball.setClubType(this.clubType);
        ball.setNoGravity(false);
        ball.setCollisionGracePeriod((Integer)MiniGolfConfig.COLLISION_GRACE_PERIOD.get());
        ball.generateRandomColor();
        ball.incrementStrokeCount();
        level.addFreshEntity((Entity)ball);
        BlockState state = level.getBlockState(teeInfo.pos);
        if (state.getBlock() instanceof GolfTeeBlock) {
            level.setBlock(teeInfo.pos, (BlockState)state.setValue((Property)GolfTeeBlock.HAS_BALL, (Comparable)Boolean.valueOf(false)), 3);
            BlockEntity be = level.getBlockEntity(teeInfo.pos);
            if (be instanceof GolfTeeBlockEntity) {
                GolfTeeBlockEntity teeBE = (GolfTeeBlockEntity)be;
                teeBE.clearBall();
            }
        }
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WOOD_HIT, SoundSource.PLAYERS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
    }

    private void shootBallFromInventory(Level level, Player player, float power) {
        ItemStack ballStack = this.findGolfBallInInventory(player);
        if (ballStack.isEmpty()) {
            return;
        }
        String ownerName = (String)ballStack.get((DataComponentType)ModDataComponents.OWNER_NAME.get());
        String ownerUUID = (String)ballStack.get((DataComponentType)ModDataComponents.OWNER_UUID.get());
        if (ownerName == null || ownerName.isEmpty()) {
            ownerName = player.getName().getString();
            ownerUUID = player.getUUID().toString();
        }
        GolfBallEntity ball = new GolfBallEntity((EntityType)ModEntities.GOLF_BALL.get(), level);
        ball.setPos(player.getX(), player.getY() + 0.1, player.getZ());
        Vec3 lookVec = player.getLookAngle();
        Vec3 horizontalLook = new Vec3(lookVec.x, 0.0, lookVec.z).normalize();
        double totalPower = this.clubType.getBasePower() * (double)this.clubType.getPowerMultiplier() * (double)power;
        double angle = (double)this.clubType.getLaunchAngle() * Math.PI / 2.5;
        double horizontalPower = totalPower * Math.cos(angle);
        double verticalPower = totalPower * Math.sin(angle);
        Vec3 velocity = new Vec3(horizontalLook.x * horizontalPower, verticalPower, horizontalLook.z * horizontalPower);
        ball.setDeltaMovement(velocity);
        ball.setOwnerInfo(ownerName, ownerUUID);
        ball.setClubType(this.clubType);
        ball.generateRandomColor();
        ball.incrementStrokeCount();
        level.addFreshEntity((Entity)ball);
        ballStack.shrink(1);
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WOOD_HIT, SoundSource.PLAYERS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
    }

    private TeeWithBall findNearbyTeeWithBall(Level level, Player player) {
        BlockPos playerPos = player.blockPosition();
        String playerUUID = player.getUUID().toString();
        for (int x = -5; x <= 5; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -5; z <= 5; ++z) {
                    GolfTeeBlockEntity tee;
                    String ballOwnerUUID;
                    BlockEntity be;
                    BlockPos checkPos = playerPos.offset(x, y, z);
                    BlockState state = level.getBlockState(checkPos);
                    if (!(state.getBlock() instanceof GolfTeeBlock) || !((Boolean)state.getValue((Property)GolfTeeBlock.HAS_BALL)).booleanValue() || !((be = level.getBlockEntity(checkPos)) instanceof GolfTeeBlockEntity) || (ballOwnerUUID = (tee = (GolfTeeBlockEntity)be).getBallOwnerUUID()) != null && !ballOwnerUUID.isEmpty() && !ballOwnerUUID.equals(playerUUID)) continue;
                    return new TeeWithBall(checkPos, tee.getBallOwnerName(), tee.getBallOwnerUUID());
                }
            }
        }
        return null;
    }

    private GolfBallEntity findNearbyGroundBall(Level level, Player player) {
        AABB searchBox = player.getBoundingBox().inflate(5.0);
        List balls = level.getEntitiesOfClass(GolfBallEntity.class, searchBox, ball -> ball.isStopped() && ball.isOwner(player));
        if (balls.isEmpty()) {
            return null;
        }
        GolfBallEntity closest = null;
        double closestDist = Double.MAX_VALUE;
        for (GolfBallEntity ball2 : balls) {
            double dist = ball2.distanceToSqr((Entity)player);
            if (!(dist < closestDist)) continue;
            closestDist = dist;
            closest = ball2;
        }
        return closest;
    }

    private void shootGroundBall(Level level, Player player, float power, GolfBallEntity ball) {
        Vec3 lookVec = player.getLookAngle();
        Vec3 horizontalLook = new Vec3(lookVec.x, 0.0, lookVec.z).normalize();
        double totalPower = this.clubType.getBasePower() * (double)this.clubType.getPowerMultiplier() * (double)power;
        double angle = (double)this.clubType.getLaunchAngle() * Math.PI / 2.5;
        double horizontalPower = totalPower * Math.cos(angle);
        double verticalPower = totalPower * Math.sin(angle);
        Vec3 velocity = new Vec3(horizontalLook.x * horizontalPower, verticalPower, horizontalLook.z * horizontalPower);
        ball.setPos(ball.getX() + horizontalLook.x * 0.2, ball.getY() + 0.1, ball.getZ() + horizontalLook.z * 0.2);
        ball.setDeltaMovement(velocity);
        ball.setClubType(this.clubType);
        ball.setCollisionGracePeriod((Integer)MiniGolfConfig.COLLISION_GRACE_PERIOD.get());
        ball.incrementStrokeCount();
        level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.WOOD_HIT, SoundSource.PLAYERS, 1.0f, 0.8f + level.random.nextFloat() * 0.4f);
    }

    private boolean hasGolfBallInInventory(Player player) {
        return !this.findGolfBallInInventory(player).isEmpty();
    }

    private ItemStack findGolfBallInInventory(Player player) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!(stack.getItem() instanceof GolfBallItem)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }

    private float calculatePower(int useTicks) {
        float maxTicks = 40.0f;
        float progress = Math.min((float)useTicks / maxTicks, 1.0f);
        return 0.3f + 0.7f * progress;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)("tooltip.minigolf.club_type." + this.clubType.getName())).withStyle(ChatFormatting.GOLD));
        String trajectory = switch (this.clubType.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> "tooltip.minigolf.trajectory.ground";
            case 1 -> "tooltip.minigolf.trajectory.medium";
            case 2 -> "tooltip.minigolf.trajectory.high";
            case 3 -> "tooltip.minigolf.trajectory.very_high";
            case 4 -> "tooltip.minigolf.trajectory.long";
        };
        tooltipComponents.add((Component)Component.translatable((String)trajectory).withStyle(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.minigolf.hold_to_charge").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
    }

    public static enum ClubType {
        PUTTER("putter", 0.05f, 0.8f),
        IRON("iron", 0.35f, 1.2f),
        WEDGE("wedge", 0.7f, 0.9f),
        SAND_WEDGE("sand_wedge", 1.1f, 0.5f),
        DRIVER("driver", 0.25f, 2.0f);

        private final String name;
        private final float launchAngle;
        private final float powerMultiplier;

        private ClubType(String name, float launchAngle, float powerMultiplier) {
            this.name = name;
            this.launchAngle = launchAngle;
            this.powerMultiplier = powerMultiplier;
        }

        public String getName() {
            return this.name;
        }

        public float getLaunchAngle() {
            return this.launchAngle;
        }

        public float getPowerMultiplier() {
            return this.powerMultiplier;
        }

        public double getBasePower() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> (Double)MiniGolfConfig.PUTTER_POWER.get();
                case 1 -> (Double)MiniGolfConfig.IRON_POWER.get();
                case 2 -> (Double)MiniGolfConfig.WEDGE_POWER.get();
                case 3 -> (Double)MiniGolfConfig.SAND_WEDGE_POWER.get();
                case 4 -> (Double)MiniGolfConfig.DRIVER_POWER.get();
            };
        }
    }

    private record TeeWithBall(BlockPos pos, String ownerName, String ownerUUID) {
    }
}

