/*
 * Decompiled with CFR 0.152.
 */
package net.spartanweapons.data;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1834;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2447;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8074;
import net.minecraft.class_8790;
import net.spartanweapons.SpartanWeaponsMain;
import net.spartanweapons.init.ItemInit;

public class RecipeLoader
extends FabricRecipeProvider {
    private static final List<BasicRecipe> WOODEN_BASE_ITEMS = List.of(new BasicRecipe("pole", new String[]{"s  ", " l ", "  s"}, true), new BasicRecipe("spear", new String[]{"s  ", " sb", " bb"}, false), new BasicRecipe("club", new String[]{"s  ", " bs", " sb"}, false), new BasicRecipe("staff", new String[]{"s", "b", "s"}, false));

    public RecipeLoader(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    public void method_10419(class_8790 exporter) {
        for (String woodHandle : ItemInit.WOOD_MATERIALS) {
            class_1792 stickItem = this.getHandleItem(woodHandle, "stick");
            class_1792 planksItem = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60656((String)(woodHandle + "_planks")));
            for (BasicRecipe recipe : WOODEN_BASE_ITEMS) {
                class_1792 resultItem = (class_1792)class_7923.field_41178.method_10223(SpartanWeaponsMain.identifierOf(woodHandle + "_" + recipe.suffix()));
                class_2447 builder = class_2447.method_10437((class_7800)class_7800.field_40642, (class_1935)resultItem).method_10434(Character.valueOf('s'), (class_1935)stickItem);
                if (recipe.needsLeather()) {
                    builder.method_10434(Character.valueOf('l'), (class_1935)class_1802.field_8745);
                } else {
                    builder.method_10434(Character.valueOf('b'), (class_1935)planksItem);
                }
                for (String line : recipe.pattern()) {
                    builder.method_10439(line);
                }
                builder.method_10429(RecipeLoader.method_32807((class_1935)stickItem), RecipeLoader.method_10426((class_1935)stickItem)).method_10431(exporter);
            }
        }
        for (class_1834 toolMaterial : class_1834.values()) {
            if (toolMaterial == class_1834.field_8922 || toolMaterial == class_1834.field_8927) continue;
            for (String woodHandle : ItemInit.WOOD_MATERIALS) {
                for (ItemInit.WeaponType type : ItemInit.TYPES) {
                    if (type.pattern() == null) continue;
                    String fullName = ItemInit.getFormattedName(toolMaterial, woodHandle, type.suffix());
                    class_1792 resultItem = (class_1792)class_7923.field_41178.method_10223(SpartanWeaponsMain.identifierOf(fullName));
                    if (toolMaterial == class_1834.field_22033) {
                        String baseName = ItemInit.getFormattedName(class_1834.field_8930, woodHandle, type.suffix());
                        class_1792 baseItem = (class_1792)class_7923.field_41178.method_10223(SpartanWeaponsMain.identifierOf(baseName));
                        class_8074.method_48535((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_41946}), (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{baseItem}), (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_22020}), (class_7800)class_7800.field_40639, (class_1792)resultItem).method_48536(RecipeLoader.method_32807((class_1935)class_1802.field_22020), RecipeLoader.method_10426((class_1935)class_1802.field_22020)).method_48537(exporter, SpartanWeaponsMain.identifierOf(fullName + "_smithing"));
                        continue;
                    }
                    this.generateShapedRecipe(exporter, toolMaterial, woodHandle, type, resultItem);
                }
            }
        }
    }

    private void generateShapedRecipe(class_8790 exporter, class_1834 toolMaterial, String woodHandle, ItemInit.WeaponType type, class_1792 resultItem) {
        class_1792 ingotItem = this.getBaseIngredient(toolMaterial);
        class_2447 builder = class_2447.method_10437((class_7800)class_7800.field_40639, (class_1935)resultItem);
        String fullPattern = String.join((CharSequence)"", type.pattern());
        if (fullPattern.contains("i")) {
            builder.method_10434(Character.valueOf('i'), (class_1935)ingotItem);
        }
        if (fullPattern.contains("b")) {
            builder.method_10434(Character.valueOf('b'), (class_1935)this.getBlockItem(toolMaterial));
        }
        if (fullPattern.contains("s")) {
            builder.method_10434(Character.valueOf('s'), (class_1935)this.getHandleItem(woodHandle, "stick"));
        }
        if (fullPattern.contains("p")) {
            builder.method_10434(Character.valueOf('p'), (class_1935)this.getHandleItem(woodHandle, "pole"));
        }
        if (fullPattern.contains("x")) {
            builder.method_10434(Character.valueOf('x'), (class_1935)class_1802.field_8777);
        }
        for (String line : type.pattern()) {
            builder.method_10439(line);
        }
        builder.method_10429(RecipeLoader.method_32807((class_1935)ingotItem), RecipeLoader.method_10426((class_1935)ingotItem)).method_10431(exporter);
    }

    private class_1792 getBaseIngredient(class_1834 material) {
        if (material == class_1834.field_8923) {
            return class_1802.field_8620;
        }
        if (material == class_1834.field_8929) {
            return class_1802.field_8695;
        }
        if (material == class_1834.field_8930) {
            return class_1802.field_8477;
        }
        if (material == class_1834.field_22033) {
            return class_1802.field_22020;
        }
        return (class_1792)class_7923.field_41178.method_10223(class_2960.method_60656((String)(material.name().toLowerCase() + "_ingot")));
    }

    private class_1792 getBlockItem(class_1834 mat) {
        return (class_1792)class_7923.field_41178.method_10223(class_2960.method_60656((String)(mat.name().toLowerCase() + "_block")));
    }

    private class_1792 getHandleItem(String wood, String type) {
        class_2960 id = wood.equals("oak") && type.equals("stick") ? class_2960.method_60656((String)type) : SpartanWeaponsMain.identifierOf(wood + "_" + type);
        return (class_1792)class_7923.field_41178.method_10223(id);
    }

    private record BasicRecipe(String suffix, String[] pattern, boolean needsLeather) {
    }
}

