/*
 * Decompiled with CFR 0.152.
 */
package net.spartanweapons.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3856;
import net.minecraft.class_3966;
import net.minecraft.class_7225;
import net.spartanweapons.init.EntityInit;
import net.spartanweapons.item.Javelin;
import org.jetbrains.annotations.Nullable;

public class JavelinEntity
extends class_1665
implements class_3856 {
    private static final class_2940<Byte> LOYALTY = class_2945.method_12791(JavelinEntity.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> ENCHANTMENT_GLINT = class_2945.method_12791(JavelinEntity.class, (class_2941)class_2943.field_13323);
    private class_1799 javelin;
    private final Set<UUID> piercedEntities = new HashSet<UUID>();
    public int returnTimer;
    private boolean dealtDamage;

    public JavelinEntity(class_1299<? extends JavelinEntity> entityType, class_1937 world, Javelin item) {
        super(entityType, world);
        this.javelin = new class_1799((class_1935)item);
    }

    public JavelinEntity(class_1937 world, class_1309 owner, class_1799 stack) {
        super(((Javelin)stack.method_7909()).getType(), owner, world, stack, null);
        this.javelin = stack;
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(stack));
        this.field_6011.method_12778(ENCHANTMENT_GLINT, (Object)stack.method_7958());
    }

    public JavelinEntity(class_1937 world, double x, double y, double z, class_1799 stack) {
        super(((Javelin)stack.method_7909()).getType(), x, y, z, world, stack, stack);
        this.javelin = stack;
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(stack));
        this.field_6011.method_12778(ENCHANTMENT_GLINT, (Object)stack.method_7958());
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(LOYALTY, (Object)0);
        builder.method_56912(ENCHANTMENT_GLINT, (Object)false);
    }

    protected class_1799 method_7445() {
        return this.javelin.method_7972();
    }

    @Environment(value=EnvType.CLIENT)
    public boolean enchantingGlint() {
        return (Boolean)this.field_6011.method_12789(ENCHANTMENT_GLINT);
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1297 hitEntity = entityHitResult.method_17782();
        if (this.piercedEntities.contains(hitEntity.method_5667()) || this.piercedEntities.size() > this.method_7447()) {
            return;
        }
        this.piercedEntities.add(hitEntity.method_5667());
        float damage = ((Javelin)this.javelin.method_7909()).method_8022().method_8028() * 2.35f;
        this.dealtDamage = true;
        class_1297 owner = this.method_24921();
        class_1282 damageSource = this.createDamageSource((class_1297)this, (class_1297)(owner == null ? this : owner));
        if (hitEntity.method_5643(damageSource, damage)) {
            if (hitEntity.method_5864() == class_1299.field_6091) {
                return;
            }
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                class_1890.method_60619((class_3218)serverWorld, (class_1297)hitEntity, (class_1282)damageSource, (class_1799)this.method_59958());
            }
            if (hitEntity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)hitEntity;
                this.method_59957(livingEntity, damageSource);
                this.method_7450(livingEntity);
            }
        }
        if (this.piercedEntities.size() > this.method_7447()) {
            this.method_18799(this.method_18798().method_18805(-0.01, -0.1, -0.01));
        } else {
            this.method_18799(this.method_18798().method_1021(0.75));
        }
        this.method_5783(class_3417.field_15213, 1.0f, 1.0f);
    }

    @Nullable
    protected class_3966 method_7434(class_243 currentPosition, class_243 nextPosition) {
        return this.dealtDamage ? null : super.method_7434(currentPosition, nextPosition);
    }

    public void method_5773() {
        if (this.field_7576 > 4) {
            this.dealtDamage = true;
        }
        class_1297 entity = this.method_24921();
        byte i = (Byte)this.field_6011.method_12789(LOYALTY);
        if (i > 0 && (this.dealtDamage || this.method_7441()) && entity != null) {
            if (!this.isOwnerAlive()) {
                if (!this.method_37908().method_8608() && this.field_7572 == class_1665.class_1666.field_7593) {
                    this.method_5699(this.method_7445(), 0.1f);
                }
                this.method_31472();
            } else {
                this.method_7433(true);
                class_243 vec3d = entity.method_33571().method_1020(this.method_19538());
                this.method_23327(this.method_23317(), this.method_23318() + vec3d.field_1351 * 0.015 * (double)i, this.method_23321());
                if (this.method_37908().method_8608()) {
                    this.field_5971 = this.method_23318();
                }
                double d = 0.05 * (double)i;
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(vec3d.method_1029().method_1021(d)));
                if (this.returnTimer == 0) {
                    this.method_5783(class_3417.field_14698, 10.0f, 1.0f);
                }
                ++this.returnTimer;
            }
        }
        super.method_5773();
    }

    private boolean isOwnerAlive() {
        class_1297 entity = this.method_24921();
        if (entity != null && entity.method_5805()) {
            return !(entity instanceof class_3222) || !entity.method_7325();
        }
        return false;
    }

    public void method_5694(class_1657 player) {
        class_1297 entity = this.method_24921();
        if (entity == null || entity.method_5667() == player.method_5667()) {
            super.method_5694(player);
        }
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10573("javelin", 10)) {
            this.javelin = class_1799.method_57360((class_7225.class_7874)this.method_56673(), (class_2520)nbt.method_10562("javelin")).orElse(this.method_57314());
            this.field_6011.method_12778(ENCHANTMENT_GLINT, (Object)this.javelin.method_7958());
        }
        this.piercedEntities.clear();
        if (nbt.method_10573("javelin_hit", 9)) {
            for (class_2520 hitEntity : nbt.method_10554("javelin_hit", 10)) {
                this.piercedEntities.add(((class_2487)hitEntity).method_25926("UUID"));
            }
        }
        this.dealtDamage = nbt.method_10577("DealtDamage");
        this.field_6011.method_12778(LOYALTY, (Object)this.getLoyalty(this.method_54759()));
    }

    private byte getLoyalty(class_1799 stack) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            return (byte)class_3532.method_15340((int)class_1890.method_60169((class_3218)serverWorld, (class_1799)stack, (class_1297)this), (int)0, (int)127);
        }
        return 0;
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (!this.javelin.method_7960()) {
            nbt.method_10566("javelin", this.javelin.method_57358((class_7225.class_7874)this.method_56673()));
            class_2499 tags = new class_2499();
            for (UUID uuid : this.piercedEntities) {
                class_2487 c = new class_2487();
                c.method_25927("UUID", uuid);
                tags.add((Object)c);
            }
            nbt.method_10556("DealtDamage", this.dealtDamage);
            nbt.method_10566("javelin_hit", (class_2520)tags);
        }
    }

    public void method_7446() {
        byte i = (Byte)this.field_6011.method_12789(LOYALTY);
        if (this.field_7572 != class_1665.class_1666.field_7593 || i <= 0) {
            super.method_7446();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public boolean method_5727(double cameraX, double cameraY, double cameraZ) {
        return true;
    }

    public class_1799 method_7495() {
        return this.javelin;
    }

    private class_1282 createDamageSource(class_1297 source, class_1297 attacker) {
        return attacker.method_48923().method_48797(EntityInit.JAVELIN, source, attacker);
    }

    protected class_1799 method_57314() {
        return this.javelin;
    }
}

