/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.block;

import com.logistics.block.entity.LogisticsBlockEntities;
import com.logistics.block.entity.PipeBlockEntity;
import com.logistics.pipe.Pipe;
import com.logistics.pipe.PipeContext;
import com.mojang.serialization.MapCodec;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_10225;
import net.minecraft.class_1269;
import net.minecraft.class_1750;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.Nullable;

public class PipeBlock
extends class_2237
implements class_3737 {
    public static final MapCodec<PipeBlock> CODEC = PipeBlock.method_54094(PipeBlock::new);
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final double PIPE_SIZE = 8.0;
    private static final class_265 CORE_SHAPE = class_2248.method_9541((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final class_265 NORTH_SHAPE = class_2248.method_9541((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
    private static final class_265 SOUTH_SHAPE = class_2248.method_9541((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
    private static final class_265 EAST_SHAPE = class_2248.method_9541((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    private static final class_265 WEST_SHAPE = class_2248.method_9541((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
    private static final class_265 UP_SHAPE = class_2248.method_9541((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final class_265 DOWN_SHAPE = class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    private final Pipe pipe;

    public PipeBlock(class_4970.class_2251 settings) {
        this(settings, null);
    }

    public PipeBlock(class_4970.class_2251 settings, Pipe pipe) {
        super(settings);
        this.pipe = pipe;
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    protected MapCodec<? extends class_2237> method_53969() {
        return CODEC;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{POWERED, WATERLOGGED});
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    public class_1269 onWrenchUse(class_1838 context) {
        if (this.pipe == null) {
            return class_1269.field_5811;
        }
        if (context.method_8045().method_8608()) {
            return class_1269.field_5812;
        }
        class_2586 blockEntity = context.method_8045().method_8321(context.method_8037());
        if (!(blockEntity instanceof PipeBlockEntity)) {
            return class_1269.field_5811;
        }
        PipeBlockEntity pipeEntity = (PipeBlockEntity)blockEntity;
        PipeContext pipeContext = new PipeContext(context.method_8045(), context.method_8037(), context.method_8045().method_8320(context.method_8037()), pipeEntity);
        this.pipe.onWrenchUse(pipeContext, context);
        return class_1269.field_5812;
    }

    public boolean method_9498(class_2680 state) {
        return this.pipe != null && this.pipe.hasComparatorOutput();
    }

    protected int method_9572(class_2680 state, class_1937 world, class_2338 pos, class_2350 direction) {
        if (this.pipe == null) {
            return 0;
        }
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof PipeBlockEntity) {
            PipeBlockEntity blockEntity = (PipeBlockEntity)class_25862;
            return this.pipe.getComparatorOutput(new PipeContext(world, pos, state, blockEntity));
        }
        return 0;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new PipeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return PipeBlock.method_31618(type, LogisticsBlockEntities.PIPE_BLOCK_ENTITY, (world1, pos, state1, blockEntity) -> PipeBlockEntity.tick(world1, pos, state1, blockEntity));
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 shape = CORE_SHAPE;
        if (this.getConnectionType(world, pos, class_2350.field_11043) != ConnectionType.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)NORTH_SHAPE);
        }
        if (this.getConnectionType(world, pos, class_2350.field_11035) != ConnectionType.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)SOUTH_SHAPE);
        }
        if (this.getConnectionType(world, pos, class_2350.field_11034) != ConnectionType.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)EAST_SHAPE);
        }
        if (this.getConnectionType(world, pos, class_2350.field_11039) != ConnectionType.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)WEST_SHAPE);
        }
        if (this.getConnectionType(world, pos, class_2350.field_11036) != ConnectionType.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)UP_SHAPE);
        }
        if (this.getConnectionType(world, pos, class_2350.field_11033) != ConnectionType.NONE) {
            shape = class_259.method_1084((class_265)shape, (class_265)DOWN_SHAPE);
        }
        return shape;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_3610 fluidState = world.method_8316(pos);
        return (class_2680)((class_2680)this.method_9564().method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(ctx.method_8045().method_49803(pos)))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return state;
    }

    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 block, @Nullable class_9904 wireOrientation, boolean notify) {
        boolean powered;
        if (!world.method_8608() && (powered = world.method_49803(pos)) != (Boolean)state.method_11654((class_2769)POWERED)) {
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        }
        super.method_9612(state, world, pos, block, wireOrientation, notify);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        class_2586 class_25862;
        super.method_9496(state, world, pos, random);
        if (this.pipe != null && (class_25862 = world.method_8321(pos)) instanceof PipeBlockEntity) {
            PipeBlockEntity blockEntity = (PipeBlockEntity)class_25862;
            PipeContext context = new PipeContext(world, pos, state, blockEntity);
            this.pipe.randomDisplayTick(context, random);
        }
    }

    public ConnectionType getConnectionType(class_1922 world, class_2338 pos, class_2350 direction) {
        class_1937 actualWorld;
        class_2338 neighborPos;
        class_2680 neighborState;
        class_2248 neighborBlock;
        class_1937 actualWorld2;
        if (world instanceof class_1937 && (actualWorld2 = (class_1937)world).method_8608()) {
            PipeBlockEntity blockEntity;
            PipeBlockEntity pipeEntity;
            class_2586 class_25862 = actualWorld2.method_8321(pos);
            PipeBlockEntity pipeBlockEntity = pipeEntity = class_25862 instanceof PipeBlockEntity ? (blockEntity = (PipeBlockEntity)class_25862) : null;
            if (pipeEntity != null) {
                return pipeEntity.getConnectionType(direction);
            }
        }
        if ((neighborBlock = (neighborState = world.method_8320(neighborPos = pos.method_10093(direction))).method_26204()) instanceof PipeBlock) {
            ConnectionType candidate = ConnectionType.PIPE;
            if (this.pipe != null && world instanceof class_1937) {
                PipeBlockEntity blockEntity;
                class_1937 actualWorld3 = (class_1937)world;
                class_2586 class_25863 = actualWorld3.method_8321(pos);
                PipeBlockEntity pipeEntity = class_25863 instanceof PipeBlockEntity ? (blockEntity = (PipeBlockEntity)class_25863) : null;
                PipeContext context = pipeEntity != null ? new PipeContext(actualWorld3, pos, actualWorld3.method_8320(pos), pipeEntity) : null;
                return this.pipe.filterConnection(context, direction, neighborBlock, candidate);
            }
            return candidate;
        }
        if (world instanceof class_1937 && ItemStorage.SIDED.find(actualWorld = (class_1937)world, neighborPos, (Object)direction.method_10153()) != null) {
            ConnectionType candidate = ConnectionType.INVENTORY;
            if (this.pipe != null) {
                PipeBlockEntity blockEntity;
                class_2586 class_25864 = actualWorld.method_8321(pos);
                PipeBlockEntity pipeEntity = class_25864 instanceof PipeBlockEntity ? (blockEntity = (PipeBlockEntity)class_25864) : null;
                PipeContext context = pipeEntity != null ? new PipeContext(actualWorld, pos, actualWorld.method_8320(pos), pipeEntity) : null;
                return this.pipe.filterConnection(context, direction, neighborBlock, candidate);
            }
            return candidate;
        }
        return ConnectionType.NONE;
    }

    public static enum ConnectionType implements class_3542
    {
        NONE("none"),
        PIPE("pipe"),
        INVENTORY("inventory");

        private final String name;

        private ConnectionType(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

