/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.client.render;

import com.logistics.block.PipeBlock;
import com.logistics.block.entity.PipeBlockEntity;
import com.logistics.client.render.PipeModelRegistry;
import com.logistics.client.render.PipeRenderState;
import com.logistics.client.render.TravelingItemRenderState;
import com.logistics.pipe.PipeContext;
import com.logistics.pipe.runtime.TravelingItem;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10442;
import net.minecraft.class_1087;
import net.minecraft.class_11659;
import net.minecraft.class_11683;
import net.minecraft.class_11954;
import net.minecraft.class_12075;
import net.minecraft.class_12249;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4608;
import net.minecraft.class_4696;
import net.minecraft.class_5614;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class PipeBlockEntityRenderer
implements class_827<PipeBlockEntity, PipeRenderState> {
    private final class_10442 itemModelManager;

    public PipeBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.itemModelManager = ctx.comp_4536();
    }

    public PipeRenderState createRenderState() {
        return new PipeRenderState();
    }

    public void updateRenderState(PipeBlockEntity entity, PipeRenderState state, float tickDelta, class_243 cameraPos, @Nullable class_11683.class_11792 crumblingOverlay) {
        PipeBlock pipeBlock;
        class_2680 blockState;
        class_11954.method_74399((class_2586)entity, (class_11954)state, (class_11683.class_11792)crumblingOverlay);
        state.tickDelta = tickDelta;
        state.modelIds.clear();
        state.travelingItems.clear();
        state.blockState = blockState = entity.method_11010();
        float targetSpeed = 0.15f;
        float accelerationRate = 0.0f;
        boolean canAccelerate = false;
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof PipeBlock && (pipeBlock = (PipeBlock)class_22482).getPipe() != null && entity.method_10997() != null) {
            PipeContext context = new PipeContext(entity.method_10997(), entity.method_11016(), blockState, entity);
            targetSpeed = pipeBlock.getPipe().getTargetSpeed(context);
            accelerationRate = pipeBlock.getPipe().getAccelerationRate(context);
            canAccelerate = pipeBlock.getPipe().canAccelerate(context);
            state.modelIds.add(pipeBlock.getPipe().getCoreModelId());
            for (class_2350 direction : class_2350.values()) {
                PipeBlock.ConnectionType type = entity.getConnectionType(direction);
                if (type == PipeBlock.ConnectionType.NONE) continue;
                state.modelIds.add(pipeBlock.getPipe().getPipeArm(context, direction));
                state.modelIds.addAll(pipeBlock.getPipe().getPipeDecorations(context, direction));
            }
        }
        for (TravelingItem travelingItem : entity.getTravelingItems()) {
            TravelingItemRenderState itemState = new TravelingItemRenderState();
            this.itemModelManager.method_65596(itemState.itemRenderState, travelingItem.getStack(), class_811.field_4318, entity.method_10997(), null, 0);
            itemState.direction = travelingItem.getDirection();
            itemState.progress = travelingItem.getProgress();
            itemState.currentSpeed = travelingItem.getSpeed();
            itemState.targetSpeed = targetSpeed;
            itemState.accelerationRate = accelerationRate;
            itemState.canAccelerate = canAccelerate;
            state.travelingItems.add(itemState);
        }
    }

    public void render(PipeRenderState state, class_4587 matrices, class_11659 queue, class_12075 cameraState) {
        if (!state.modelIds.isEmpty()) {
            class_1921 renderLayer = state.blockState == null ? class_12249.method_75972() : class_4696.method_23683((class_2680)state.blockState);
            for (class_2960 modelId : state.modelIds) {
                class_1087 model = PipeModelRegistry.getModel(modelId);
                if (model == null) continue;
                queue.method_73484(matrices, renderLayer, model, 1.0f, 1.0f, 1.0f, state.field_62676, class_4608.field_21444, 0);
            }
        }
        for (TravelingItemRenderState itemState : state.travelingItems) {
            matrices.method_22903();
            float speedChange = itemState.currentSpeed < itemState.targetSpeed ? (itemState.canAccelerate ? Math.min(itemState.accelerationRate * state.tickDelta, itemState.targetSpeed - itemState.currentSpeed) : 0.0f) : (itemState.currentSpeed > itemState.targetSpeed ? Math.max(-itemState.accelerationRate * state.tickDelta, itemState.targetSpeed - itemState.currentSpeed) : 0.0f);
            float interpolatedSpeed = itemState.currentSpeed + speedChange;
            float avgSpeed = (itemState.currentSpeed + interpolatedSpeed) / 2.0f;
            float interpolatedProgress = itemState.progress + avgSpeed * state.tickDelta;
            matrices.method_22904(0.5, 0.375, 0.5);
            float travelDistance = interpolatedProgress - 0.5f;
            matrices.method_46416((float)itemState.direction.method_10148() * travelDistance, (float)itemState.direction.method_10164() * travelDistance, (float)itemState.direction.method_10165() * travelDistance);
            itemState.itemRenderState.method_65604(matrices, queue, state.field_62676, class_4608.field_21444, 0);
            matrices.method_22909();
        }
    }
}

