/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.client.render;

import com.logistics.LogisticsMod;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.model.loading.v1.ExtraModelKey;
import net.fabricmc.fabric.api.client.model.loading.v1.FabricBakedModelManager;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.model.loading.v1.SimpleUnbakedExtraModel;
import net.fabricmc.fabric.api.client.model.loading.v1.UnbakedExtraModel;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1087;
import net.minecraft.class_1092;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class PipeModelRegistry {
    private static final Map<class_2960, ExtraModelKey<class_1087>> MODEL_KEYS = new HashMap<class_2960, ExtraModelKey<class_1087>>();
    private static boolean registered;

    private PipeModelRegistry() {
    }

    public static void register() {
        if (registered) {
            return;
        }
        registered = true;
        Set<class_2960> modelIds = PipeModelRegistry.collectModelIds();
        if (modelIds.isEmpty()) {
            LogisticsMod.LOGGER.warn("No pipe models found to register for block entity rendering");
        }
        for (class_2960 id : modelIds) {
            MODEL_KEYS.put(id, (ExtraModelKey<class_1087>)ExtraModelKey.create(() -> ((class_2960)id).toString()));
        }
        ModelLoadingPlugin.register(context -> {
            for (class_2960 id : modelIds) {
                ExtraModelKey<class_1087> key = MODEL_KEYS.get(id);
                if (key == null) continue;
                context.addModel(key, (UnbakedExtraModel)SimpleUnbakedExtraModel.blockStateModel((class_2960)id));
            }
        });
    }

    @Nullable
    public static class_1087 getModel(class_2960 id) {
        ExtraModelKey<class_1087> key = MODEL_KEYS.get(id);
        if (key == null) {
            return null;
        }
        class_1092 modelManager = class_310.method_1551().method_1554();
        if (!(modelManager instanceof FabricBakedModelManager)) {
            return null;
        }
        class_1092 fabricManager = modelManager;
        return (class_1087)fabricManager.getModel(key);
    }

    private static Set<class_2960> collectModelIds() {
        Optional container = FabricLoader.getInstance().getModContainer("logistics");
        Optional root = container.flatMap(mod -> mod.findPath("assets/logistics/models/block"));
        if (root.isEmpty()) {
            return Set.of();
        }
        HashSet<class_2960> modelIds = new HashSet<class_2960>();
        try (Stream<Path> files = Files.walk((Path)root.get(), new FileVisitOption[0]);){
            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(path -> {
                String relative = ((Path)root.get()).relativize((Path)path).toString().replace('\\', '/');
                if (!relative.endsWith(".json")) {
                    return;
                }
                String name = relative.substring(0, relative.length() - ".json".length());
                modelIds.add(class_2960.method_60655((String)"logistics", (String)("block/" + name)));
            });
        }
        catch (IOException e) {
            LogisticsMod.LOGGER.warn("Failed to scan pipe model resources", (Throwable)e);
        }
        return modelIds;
    }
}

