/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.pipe;

import com.logistics.block.PipeBlock;
import com.logistics.block.entity.PipeBlockEntity;
import com.logistics.pipe.Pipe;
import com.logistics.pipe.modules.Module;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.Nullable;

public record PipeContext(class_1937 world, class_2338 pos, class_2680 state, PipeBlockEntity blockEntity) {
    @Nullable
    public Pipe pipe() {
        class_2248 class_22482 = this.state.method_26204();
        if (class_22482 instanceof PipeBlock) {
            PipeBlock pipeBlock = (PipeBlock)class_22482;
            return pipeBlock.getPipe();
        }
        return null;
    }

    public class_2487 moduleState(String key) {
        return this.blockEntity.getOrCreateModuleState(key);
    }

    public String getString(Module module, String key, String defaultValue) {
        return this.moduleState(module.getStateKey()).method_68564(key, defaultValue);
    }

    public void saveString(Module module, String key, String value) {
        this.moduleState(module.getStateKey()).method_10582(key, value);
    }

    public int getInt(Module module, String key, int defaultValue) {
        return this.moduleState(module.getStateKey()).method_68083(key, defaultValue);
    }

    public void saveInt(Module module, String key, int value) {
        this.moduleState(module.getStateKey()).method_10569(key, value);
    }

    public void remove(Module module, String key) {
        this.moduleState(module.getStateKey()).method_10551(key);
    }

    public class_2487 getNbtCompound(Module module, String key) {
        return this.moduleState(module.getStateKey()).method_68568(key);
    }

    public void putNbtCompound(Module module, String key, class_2487 value) {
        this.moduleState(module.getStateKey()).method_10566(key, (class_2520)value);
    }

    public void markDirty() {
        this.blockEntity.method_5431();
    }

    public void markDirtyAndSync() {
        this.markDirty();
        if (!this.world.method_8608()) {
            this.world.method_8413(this.pos, this.state, this.state, 3);
        }
    }

    public boolean isPowered() {
        return this.state.method_28498((class_2769)PipeBlock.POWERED) && (Boolean)this.state.method_11654((class_2769)PipeBlock.POWERED) != false;
    }

    public class_2680 getNeighborState(class_2350 direction) {
        return this.world.method_8320(this.pos.method_10093(direction));
    }

    public boolean isNeighborPipe(class_2350 direction) {
        return this.getNeighborState(direction).method_26204() instanceof PipeBlock;
    }

    public List<class_2350> getConnectedDirections() {
        ArrayList<class_2350> connected = new ArrayList<class_2350>();
        class_2350[] class_2350Array = this.state.method_26204();
        if (!(class_2350Array instanceof PipeBlock)) {
            return connected;
        }
        PipeBlock pipeBlock = (PipeBlock)class_2350Array;
        for (class_2350 direction : class_2350.values()) {
            PipeBlock.ConnectionType type = pipeBlock.getConnectionType((class_1922)this.world, this.pos, direction);
            if (type == PipeBlock.ConnectionType.NONE) continue;
            connected.add(direction);
        }
        return connected;
    }

    public boolean hasConnection(class_2350 direction) {
        class_2248 class_22482 = this.state.method_26204();
        if (!(class_22482 instanceof PipeBlock)) {
            return false;
        }
        PipeBlock pipeBlock = (PipeBlock)class_22482;
        PipeBlock.ConnectionType type = pipeBlock.getConnectionType((class_1922)this.world, this.pos, direction);
        return type != PipeBlock.ConnectionType.NONE;
    }

    public PipeBlock.ConnectionType getConnectionType(class_2350 direction) {
        class_2248 class_22482 = this.state.method_26204();
        if (!(class_22482 instanceof PipeBlock)) {
            return PipeBlock.ConnectionType.NONE;
        }
        PipeBlock pipeBlock = (PipeBlock)class_22482;
        return pipeBlock.getConnectionType((class_1922)this.world, this.pos, direction);
    }

    public List<class_2350> getPipeConnections() {
        ArrayList<class_2350> outputs = new ArrayList<class_2350>();
        for (class_2350 direction : this.getConnectedDirections()) {
            if (!this.isNeighborPipe(direction)) continue;
            outputs.add(direction);
        }
        return outputs;
    }

    public List<class_2350> getInventoryConnections() {
        ArrayList<class_2350> faces = new ArrayList<class_2350>();
        for (class_2350 direction : class_2350.values()) {
            if (!this.isInventoryConnection(direction)) continue;
            faces.add(direction);
        }
        return faces;
    }

    public boolean isInventoryConnection(class_2350 direction) {
        return this.getConnectionType(direction) == PipeBlock.ConnectionType.INVENTORY;
    }
}

