/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.pipe.modules;

import com.logistics.pipe.PipeContext;
import com.logistics.pipe.modules.Module;
import com.logistics.pipe.runtime.RoutePlan;
import com.logistics.pipe.runtime.TravelingItem;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class MergerModule
implements Module {
    private static final String OUTPUT_DIRECTION = "output_direction";

    @Override
    public void onConnectionsChanged(PipeContext ctx, List<class_2350> options) {
        List<class_2350> outputs = ctx.getConnectedDirections();
        if (outputs.isEmpty()) {
            this.setOutputDirection(ctx, null);
            return;
        }
        class_2350 current = this.getOutputDirection(ctx);
        if (current == null || !outputs.contains(current)) {
            this.setOutputDirection(ctx, outputs.getFirst());
        }
    }

    @Override
    public RoutePlan route(PipeContext ctx, TravelingItem item, List<class_2350> options) {
        class_2350 out = this.getOutputDirection(ctx);
        if (out == null || options == null || options.isEmpty() || !options.contains(out)) {
            return RoutePlan.drop();
        }
        return RoutePlan.reroute(out);
    }

    @Override
    public void onWrenchUse(PipeContext ctx, class_1838 usage) {
        List<class_2350> connected = ctx.getConnectedDirections();
        if (connected.isEmpty()) {
            this.setOutputDirection(ctx, null);
            return;
        }
        class_2350 current = this.getOutputDirection(ctx);
        class_2350 next = this.nextInCycle(connected, current);
        this.setOutputDirection(ctx, next);
    }

    @Override
    public boolean canAcceptFrom(PipeContext ctx, class_2350 from, class_1799 stack) {
        class_2350 out = this.getOutputDirection(ctx);
        return out == null || from != out;
    }

    @Nullable
    private class_2350 getOutputDirection(PipeContext ctx) {
        class_2487 state = ctx.moduleState(this.getStateKey());
        if (!state.method_10545(OUTPUT_DIRECTION)) {
            return null;
        }
        return state.method_10558(OUTPUT_DIRECTION).map(class_2350::method_10168).orElse(null);
    }

    private void setOutputDirection(PipeContext ctx, @Nullable class_2350 direction) {
        class_2350 current = this.getOutputDirection(ctx);
        if (current == direction) {
            return;
        }
        if (direction == null) {
            ctx.remove(this, OUTPUT_DIRECTION);
        } else {
            ctx.saveString(this, OUTPUT_DIRECTION, direction.method_10151());
        }
        ctx.markDirtyAndSync();
    }

    private class_2350 nextInCycle(List<class_2350> ordered, @Nullable class_2350 current) {
        if (ordered.isEmpty()) {
            throw new IllegalArgumentException("ordered directions must not be empty");
        }
        int idx = current == null ? -1 : ordered.indexOf(current);
        return idx < 0 ? ordered.getFirst() : ordered.get((idx + 1) % ordered.size());
    }

    @Override
    @Nullable
    public class_2960 getPipeArm(PipeContext ctx, class_2350 direction) {
        if (!this.isOutputDirection(ctx, direction)) {
            return null;
        }
        return class_2960.method_60655((String)"logistics", (String)this.featureBasePath(ctx, direction));
    }

    @Override
    public List<class_2960> getPipeDecorations(PipeContext ctx, class_2350 direction) {
        if (!this.isOutputDirection(ctx, direction) || !ctx.isInventoryConnection(direction)) {
            return List.of();
        }
        return List.of(class_2960.method_60655((String)"logistics", (String)(this.featureBasePath(ctx, direction) + "_extension")));
    }

    private boolean isOutputDirection(PipeContext ctx, class_2350 direction) {
        return this.getOutputDirection(ctx) == direction;
    }

    private String featureBasePath(PipeContext ctx, class_2350 direction) {
        return ctx.pipe().getModelBasePath(direction) + "_feature";
    }
}

