/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.pipe.runtime;

import com.logistics.pipe.runtime.TravelingItem;
import java.util.List;
import net.minecraft.class_2350;

public final class RoutePlan {
    private static final RoutePlan PASS = new RoutePlan(Type.PASS, List.of(), List.of());
    private static final RoutePlan DROP = new RoutePlan(Type.DROP, List.of(), List.of());
    private static final RoutePlan DISCARD = new RoutePlan(Type.DISCARD, List.of(), List.of());
    private final Type type;
    private final List<class_2350> directions;
    private final List<TravelingItem> items;

    private RoutePlan(Type type, List<class_2350> directions, List<TravelingItem> items) {
        this.type = type;
        this.directions = directions;
        this.items = items;
    }

    public static RoutePlan pass() {
        return PASS;
    }

    public static RoutePlan drop() {
        return DROP;
    }

    public static RoutePlan discard() {
        return DISCARD;
    }

    public static RoutePlan reroute(List<class_2350> directions) {
        return new RoutePlan(Type.REROUTE, List.copyOf(directions), List.of());
    }

    public static RoutePlan reroute(class_2350 direction) {
        return new RoutePlan(Type.REROUTE, List.of(direction), List.of());
    }

    public static RoutePlan split(List<TravelingItem> items) {
        return new RoutePlan(Type.SPLIT, List.of(), items);
    }

    public Type getType() {
        return this.type;
    }

    public List<class_2350> getDirections() {
        return this.directions;
    }

    public List<TravelingItem> getItems() {
        return this.items;
    }

    public static enum Type {
        PASS,
        DROP,
        DISCARD,
        REROUTE,
        SPLIT;

    }
}

