/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.pipe.runtime;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_2350;

public class TravelingItem {
    public static final Codec<TravelingItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("item").forGetter(t -> t.stack), (App)Codec.INT.fieldOf("direction").xmap(class_2350::method_10143, class_2350::method_10146).forGetter(t -> t.direction), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(0.15f)).forGetter(t -> Float.valueOf(t.speed)), (App)Codec.FLOAT.optionalFieldOf("progress", (Object)Float.valueOf(0.0f)).forGetter(t -> Float.valueOf(t.progress)), (App)Codec.BOOL.optionalFieldOf("routed", (Object)false).forGetter(t -> t.routed)).apply((Applicative)instance, TravelingItem::fromCodec));
    private class_1799 stack;
    private float progress;
    private class_2350 direction;
    private float speed;
    private boolean routed;

    private static TravelingItem fromCodec(class_1799 stack, class_2350 direction, float speed, float progress, boolean routed) {
        TravelingItem item = new TravelingItem(stack, direction, speed);
        item.progress = progress;
        item.routed = routed;
        return item;
    }

    public TravelingItem(class_1799 stack, class_2350 direction, float speed) {
        this.stack = stack.method_7972();
        this.progress = 0.0f;
        this.direction = direction;
        this.speed = speed;
        this.routed = false;
    }

    public boolean tick(float targetSpeed, float accelerationRate, boolean canAccelerate) {
        if (this.speed < targetSpeed) {
            if (canAccelerate) {
                this.speed = Math.min(this.speed + accelerationRate, targetSpeed);
            }
        } else if (this.speed > targetSpeed) {
            this.speed = Math.max(this.speed - accelerationRate, targetSpeed);
        }
        this.progress += this.speed;
        return this.progress >= 1.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public class_2350 getDirection() {
        return this.direction;
    }

    public void setDirection(class_2350 direction) {
        this.direction = direction;
        this.routed = true;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public boolean isRouted() {
        return this.routed;
    }

    public void setRouted(boolean routed) {
        this.routed = routed;
    }
}

