/*
 * Decompiled with CFR 0.152.
 */
package velo.radial.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import velo.radial.config.RadialSlot;
import velo.radial.config.SlotMode;

public class RadialConfig {
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("radial.json").toFile();
    private static final File TEMP_FILE = FabricLoader.getInstance().getConfigDir().resolve("radial.json.tmp").toFile();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static RadialConfig INSTANCE = new RadialConfig();
    public int version = 1;
    public int slotCount = 8;
    public int ringRadius = 75;
    public int innerPadding = 40;
    public int outerReach = 100;
    public int animationSpeedMs = 200;
    public List<RadialSlot> slots = new ArrayList<RadialSlot>();

    public RadialConfig() {
        this.ensureSlotCapacity();
    }

    public void validate() {
        this.slotCount = Math.max(3, Math.min(this.slotCount, 12));
        this.ringRadius = Math.max(30, Math.min(this.ringRadius, 200));
        this.innerPadding = Math.max(0, Math.min(this.innerPadding, 200));
        this.outerReach = Math.max(10, Math.min(this.outerReach, 300));
        this.animationSpeedMs = Math.max(0, Math.min(this.animationSpeedMs, 2000));
        if (this.slots == null) {
            this.slots = new ArrayList<RadialSlot>();
        }
        for (RadialSlot slot : this.slots) {
            if (slot == null) continue;
            if (slot.name == null) {
                slot.name = "";
            }
            if (slot.mode == null) {
                slot.mode = SlotMode.EMPTY;
            }
            if (slot.value == null) {
                slot.value = "";
            }
            if (slot.itemId != null) continue;
            slot.itemId = "minecraft:air";
        }
        this.ensureSlotCapacity();
    }

    public static void load() {
        if (!CONFIG_FILE.exists()) {
            RadialConfig.save();
            return;
        }
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            RadialConfig loaded = (RadialConfig)GSON.fromJson((Reader)reader, RadialConfig.class);
            if (loaded != null) {
                if (loaded.version < RadialConfig.INSTANCE.version) {
                    loaded = RadialConfig.handleMigration(loaded);
                }
                INSTANCE = loaded;
                INSTANCE.validate();
            }
        }
        catch (Exception e) {
            System.err.println("[Radial] Failed to load config! Creating backup.");
            RadialConfig.backupCorruptedConfig();
            INSTANCE = new RadialConfig();
            RadialConfig.save();
        }
    }

    private static RadialConfig handleMigration(RadialConfig loaded) {
        loaded.version = RadialConfig.INSTANCE.version;
        RadialConfig.save();
        return loaded;
    }

    public static void save() {
        try {
            try (FileWriter writer = new FileWriter(TEMP_FILE);){
                GSON.toJson((Object)INSTANCE, (Appendable)writer);
            }
            Files.move(TEMP_FILE.toPath(), CONFIG_FILE.toPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (Exception e) {
            System.err.println("[Radial] Critical error during config save!");
            e.printStackTrace();
        }
    }

    private static void backupCorruptedConfig() {
        if (CONFIG_FILE.exists()) {
            File backup = new File(CONFIG_FILE.getAbsolutePath() + ".bak");
            CONFIG_FILE.renameTo(backup);
        }
    }

    private void ensureSlotCapacity() {
        while (this.slots.size() < 12) {
            this.slots.add(new RadialSlot("Empty Slot " + (this.slots.size() + 1), SlotMode.EMPTY, "", "minecraft:air"));
        }
    }
}

