/*
 * Decompiled with CFR 0.152.
 */
package velo.radial.ui;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_11909;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_7923;

public class ItemPickerScreen
extends class_437 {
    private static final int SLOT_SIZE = 18;
    private static final int GRID_TOP = 45;
    private static final int HORIZONTAL_PADDING = 40;
    private static final int BOTTOM_PADDING = 20;
    private final class_437 parent;
    private final Consumer<String> onSelect;
    private class_342 searchField;
    private List<class_1792> filteredItems;
    private int scrollOffset = 0;
    private int columns = 12;
    private int maxRows = 7;

    public ItemPickerScreen(class_437 parent, Consumer<String> onSelect) {
        super((class_2561)class_2561.method_43470((String)"Item Selector"));
        this.parent = parent;
        this.onSelect = onSelect;
        this.filteredItems = class_7923.field_41178.method_10220().collect(Collectors.toList());
    }

    protected void method_25426() {
        int searchWidth = Math.min(400, (int)((double)this.field_22789 * 0.8));
        this.searchField = new class_342(this.field_22793, this.field_22789 / 2 - searchWidth / 2, 15, searchWidth, 20, (class_2561)class_2561.method_43470((String)"Search..."));
        this.searchField.method_47404((class_2561)class_2561.method_43471((String)"gui.recipebook.search_hint"));
        this.searchField.method_1863(this::updateSearch);
        this.method_37063((class_364)this.searchField);
        this.method_48265((class_364)this.searchField);
        this.columns = Math.max(1, (this.field_22789 - 40) / 18);
        this.maxRows = Math.max(1, (this.field_22790 - 45 - 20) / 18);
    }

    private void updateSearch(String query) {
        String q = query.toLowerCase();
        this.filteredItems = class_7923.field_41178.method_10220().filter(item -> item.method_63680().getString().toLowerCase().contains(q) || class_7923.field_41178.method_10221(item).toString().contains(q)).collect(Collectors.toList());
        this.scrollOffset = 0;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int index;
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        int startX = this.field_22789 / 2 - this.columns * 18 / 2;
        for (int i = 0; i < this.maxRows * this.columns && (index = i + this.scrollOffset * this.columns) < this.filteredItems.size(); ++i) {
            int x = startX + i % this.columns * 18;
            int y = 45 + i / this.columns * 18;
            class_1799 stack = new class_1799((class_1935)this.filteredItems.get(index));
            context.method_51427(stack, x + 1, y + 1);
            if (mouseX < x || mouseX >= x + 18 || mouseY < y || mouseY >= y + 18) continue;
            context.method_25294(x, y, x + 18, y + 18, 0x40FFFFFF);
            context.method_51446(this.field_22793, stack, mouseX, mouseY);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        assert (this.field_22787 != null);
        double mx = click.comp_4798();
        double my = click.comp_4799();
        int startX = this.field_22789 / 2 - this.columns * 18 / 2;
        for (int i = 0; i < this.maxRows * this.columns; ++i) {
            int index;
            int x = startX + i % this.columns * 18;
            int y = 45 + i / this.columns * 18;
            if (!(mx >= (double)x) || !(mx < (double)(x + 18)) || !(my >= (double)y) || !(my < (double)(y + 18)) || (index = i + this.scrollOffset * this.columns) >= this.filteredItems.size()) continue;
            this.onSelect.accept(class_7923.field_41178.method_10221((Object)this.filteredItems.get(index)).toString());
            this.field_22787.method_1507(this.parent);
            return true;
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int totalRows = (this.filteredItems.size() + this.columns - 1) / this.columns;
        int maxScroll = Math.max(0, totalRows - this.maxRows);
        this.scrollOffset = Math.max(0, Math.min(maxScroll, this.scrollOffset - (int)verticalAmount));
        return true;
    }

    public void method_25419() {
        assert (this.field_22787 != null);
        this.field_22787.method_1507(this.parent);
    }
}

