/*
 * Decompiled with CFR 0.152.
 */
package velo.radial.ui;

import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.lwjgl.glfw.GLFW;
import velo.radial.RadialClient;
import velo.radial.config.RadialConfig;
import velo.radial.config.RadialSlot;
import velo.radial.config.SlotMode;
import velo.radial.ui.RadialSlotEditorScreen;

public class RadialScreen
extends class_437 {
    private static final class_2960 SLOT_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"gamemode_switcher/slot");
    private static final class_2960 SELECTION_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"gamemode_switcher/selection");
    private static final int SLOT_SIZE = 26;
    private final List<RadialSlot> rootSlots;
    private List<RadialSlot> activeSlots;
    private int currentSlotCount;
    private int hoveredSlot = -1;
    private boolean backHovered = false;
    private float animProgress = 0.0f;

    public RadialScreen() {
        super((class_2561)class_2561.method_43473());
        this.rootSlots = RadialConfig.INSTANCE.slots;
        this.activeSlots = this.rootSlots;
        this.currentSlotCount = RadialConfig.INSTANCE.slotCount;
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25393() {
        super.method_25393();
        int keyCode = KeyBindingHelper.getBoundKeyOf((class_304)RadialClient.OPEN_RADIAL).method_1444();
        long handle = class_310.method_1551().method_22683().method_4490();
        if (GLFW.glfwGetKey((long)handle, (int)keyCode) == 0) {
            this.method_25419();
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        RadialConfig config = RadialConfig.INSTANCE;
        if (config.animationSpeedMs <= 0) {
            this.animProgress = 1.0f;
        } else {
            float speed = 50.0f / (float)config.animationSpeedMs;
            if (this.animProgress < 1.0f) {
                this.animProgress = Math.min(1.0f, this.animProgress + speed * delta);
            }
        }
        float ease = 1.0f - (float)Math.pow(1.0f - this.animProgress, 3.0);
        int cx = this.field_22789 / 2;
        int cy = this.field_22790 / 2;
        int count = this.currentSlotCount;
        double dx = mouseX - cx;
        double dy = mouseY - cy;
        double dist = Math.sqrt(dx * dx + dy * dy);
        int backX = cx - 13;
        int backY = cy - config.ringRadius - 50;
        int hitboxPadding = 4;
        boolean bl = this.backHovered = this.activeSlots != this.rootSlots && mouseX >= backX - hitboxPadding && mouseX <= backX + 26 + hitboxPadding && mouseY >= backY - hitboxPadding && mouseY <= backY + 26 + hitboxPadding;
        if (!this.backHovered && dist >= (double)Math.max(0, config.ringRadius - config.innerPadding) && dist <= (double)(config.ringRadius + config.outerReach)) {
            double angle = Math.atan2(dy, dx) + 1.5707963267948966;
            if (angle < 0.0) {
                angle += Math.PI * 2;
            }
            double sectorSize = Math.PI * 2 / (double)count;
            this.hoveredSlot = (int)((angle + sectorSize / 2.0) / sectorSize) % count;
        } else {
            this.hoveredSlot = -1;
        }
        if (this.activeSlots != this.rootSlots) {
            this.drawSlot(context, backX, backY, this.backHovered, ease, -1);
        }
        for (int i = 0; i < count; ++i) {
            double slotAngle = Math.PI * 2 / (double)count * (double)i - 1.5707963267948966;
            float radius = (float)config.ringRadius * ease;
            float x = (float)((double)cx + Math.cos(slotAngle) * (double)radius - 13.0);
            float y = (float)((double)cy + Math.sin(slotAngle) * (double)radius - 13.0);
            this.drawSlot(context, x, y, i == this.hoveredSlot, ease, i);
        }
        if (this.hoveredSlot != -1 && this.hoveredSlot < this.activeSlots.size()) {
            String name = this.activeSlots.get((int)this.hoveredSlot).name;
            int alpha = (int)(ease * 255.0f);
            context.method_27535(this.field_22793, class_2561.method_30163((String)name), cx - this.field_22793.method_1727(name) / 2, cy - 4, alpha << 24 | 0xFFFFFF);
        } else if (this.backHovered) {
            class_5250 backText = class_2561.method_43471((String)"radial.ui.back");
            context.method_27535(this.field_22793, (class_2561)backText, cx - this.field_22793.method_27525((class_5348)backText) / 2, cy - 4, -1);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawSlot(class_332 context, float x, float y, boolean hovered, float ease, int index) {
        int alpha = (int)(ease * 255.0f);
        int color = alpha << 24 | 0xFFFFFF;
        context.method_51448().pushMatrix();
        context.method_51448().translate(x, y);
        context.method_52707(class_10799.field_56883, SLOT_TEXTURE, 0, 0, 26, 26, color);
        if (hovered) {
            context.method_52707(class_10799.field_56883, SELECTION_TEXTURE, 0, 0, 26, 26, color);
        }
        if (index >= 0 && index < this.activeSlots.size()) {
            context.method_51427(this.activeSlots.get(index).getRenderStack(), 5, 5);
        } else if (index == -1) {
            String icon = "\u2716";
            int xOff = (26 - this.field_22793.method_1727(icon)) / 2;
            int yOff = 9;
            context.method_25303(this.field_22793, icon, xOff, yOff, color);
        }
        context.method_51448().popMatrix();
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (click.method_74245() == 0) {
            if (this.backHovered) {
                this.goBack();
                return true;
            }
            if (this.hoveredSlot != -1 && this.hoveredSlot < this.activeSlots.size()) {
                this.performAction(this.activeSlots.get(this.hoveredSlot));
            } else {
                this.method_25419();
            }
            return true;
        }
        if (click.method_74245() == 1 && this.hoveredSlot != -1) {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new RadialSlotEditorScreen(this.activeSlots.get(this.hoveredSlot), this.activeSlots == this.rootSlots));
            }
            return true;
        }
        return super.method_25402(click, doubled);
    }

    private void performAction(RadialSlot slot) {
        if (slot.mode == SlotMode.EMPTY) {
            return;
        }
        if (slot.mode == SlotMode.SUBMENU && this.activeSlots == this.rootSlots) {
            this.activeSlots = slot.children;
            this.currentSlotCount = slot.childSlotCount;
            this.animProgress = 0.0f;
            return;
        }
        class_310 client = class_310.method_1551();
        if (slot.mode == SlotMode.CHAT) {
            if (slot.value.startsWith("/")) {
                Objects.requireNonNull(client.method_1562()).method_45730(slot.value.substring(1));
            } else {
                Objects.requireNonNull(client.method_1562()).method_45729(slot.value);
            }
        } else if (slot.mode == SlotMode.KEYBIND) {
            for (class_304 key : client.field_1690.field_1839) {
                if (!key.method_1431().equals(slot.value)) continue;
                RadialClient.scheduleKeyPress(key);
            }
        }
        RadialClient.lockKey();
        this.method_25419();
    }

    private void goBack() {
        this.activeSlots = this.rootSlots;
        this.currentSlotCount = RadialConfig.INSTANCE.slotCount;
        this.animProgress = 0.0f;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float deltaTicks) {
    }
}

