/*
 * Decompiled with CFR 0.152.
 */
package velo.radial.ui;

import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import velo.radial.config.RadialConfig;
import velo.radial.config.RadialSlot;
import velo.radial.config.SlotMode;
import velo.radial.ui.ItemPickerScreen;
import velo.radial.ui.KeybindPickerScreen;

public class RadialSlotEditorScreen
extends class_437 {
    private static final class_2960 SLOT_TEXTURE = class_2960.method_60655((String)"minecraft", (String)"gamemode_switcher/slot");
    private static final int SLOT_SIZE = 26;
    private static final int GAP = 38;
    private final RadialSlot slot;
    private final boolean isRoot;
    private final String oldName;
    private final String oldValue;
    private final String oldId;
    private final SlotMode oldMode;
    private final int oldChildCount;
    private class_342 nameField;
    private class_342 valueField;
    private class_342 iconField;
    private class_357 subCountSlider;
    private class_4185 modeButton;
    private class_4185 browseIconButton;
    private class_4185 handButton;
    private class_4185 valueBrowseButton;
    private class_4185 saveButton;
    private class_4185 cancelButton;

    public RadialSlotEditorScreen(RadialSlot slot, boolean isRoot) {
        super((class_2561)class_2561.method_43471((String)"screen.radial.editor.title"));
        this.slot = slot;
        this.isRoot = isRoot;
        this.oldName = slot.name;
        this.oldValue = slot.value;
        this.oldId = slot.itemId;
        this.oldMode = slot.mode;
        this.oldChildCount = slot.childSlotCount;
    }

    protected void method_25426() {
        int centerX = this.field_22789 / 2;
        int baseY = this.field_22790 / 2 - 60;
        int contentWidth = Math.min(300, (int)((double)this.field_22789 * 0.9));
        int left = centerX - contentWidth / 2;
        this.nameField = new class_342(this.field_22793, left, baseY, contentWidth, 20, (class_2561)class_2561.method_43471((String)"screen.radial.editor.name"));
        this.nameField.method_1880(Integer.MAX_VALUE);
        this.nameField.method_1852(this.slot.name);
        this.nameField.method_1863(v -> {
            this.slot.name = v;
        });
        this.method_37063((class_364)this.nameField);
        this.modeButton = class_4185.method_46430((class_2561)class_2561.method_30163((String)("Type: " + this.slot.mode.getTranslatedName().getString())), btn -> {
            this.slot.mode = SlotMode.values()[(this.slot.mode.ordinal() + 1) % SlotMode.values().length];
            if (!this.isRoot && this.slot.mode == SlotMode.SUBMENU) {
                this.slot.mode = SlotMode.values()[(this.slot.mode.ordinal() + 1) % SlotMode.values().length];
            }
            btn.method_25355(class_2561.method_30163((String)("Type: " + this.slot.mode.getTranslatedName().getString())));
            this.refreshWidgets();
        }).method_46434(left, baseY + 38, contentWidth, 20).method_46431();
        this.method_37063((class_364)this.modeButton);
        this.valueField = new class_342(this.field_22793, left, baseY + 76, contentWidth - 30, 20, (class_2561)class_2561.method_43471((String)"screen.radial.editor.value"));
        this.valueField.method_1880(Integer.MAX_VALUE);
        this.valueField.method_1852(this.slot.value);
        this.valueField.method_1863(v -> {
            this.slot.value = v;
        });
        this.method_37063((class_364)this.valueField);
        this.valueBrowseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"..."), btn -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new KeybindPickerScreen(this, id -> {
                    this.valueField.method_1852(id);
                    this.slot.value = id;
                }));
            }
        }).method_46434(left + contentWidth - 25, baseY + 76, 25, 20).method_46431();
        this.method_37063((class_364)this.valueBrowseButton);
        this.subCountSlider = new class_357(left, baseY + 76, contentWidth, 20, this.getSliderText(this.slot.childSlotCount), (double)(this.slot.childSlotCount - 3) / 9.0){

            protected void method_25346() {
                int val = 3 + (int)(this.field_22753 * 9.0);
                this.method_25355(RadialSlotEditorScreen.this.getSliderText(val));
            }

            protected void method_25344() {
                RadialSlotEditorScreen.this.slot.childSlotCount = 3 + (int)(this.field_22753 * 9.0);
                if (RadialSlotEditorScreen.this.slot.mode == SlotMode.SUBMENU) {
                    RadialSlotEditorScreen.this.ensureChildren();
                }
            }
        };
        this.method_37063((class_364)this.subCountSlider);
        int buttonWidth = 50;
        int iconFieldWidth = contentWidth - buttonWidth * 2 - 10;
        this.iconField = new class_342(this.field_22793, left, baseY + 114, iconFieldWidth, 20, (class_2561)class_2561.method_43471((String)"screen.radial.editor.icon"));
        this.iconField.method_1880(Integer.MAX_VALUE);
        this.iconField.method_1852(this.slot.itemId);
        this.iconField.method_1863(v -> {
            this.slot.itemId = v;
            this.slot.clearCache();
        });
        this.method_37063((class_364)this.iconField);
        this.browseIconButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.radial.editor.browse"), btn -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507((class_437)new ItemPickerScreen(this, id -> {
                    this.iconField.method_1852(id);
                    this.slot.itemId = id;
                    this.slot.clearCache();
                }));
            }
        }).method_46434(left + iconFieldWidth + 5, baseY + 114, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.browseIconButton);
        this.handButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.radial.editor.hand"), btn -> {
            if (this.field_22787 != null && this.field_22787.field_1724 != null) {
                class_1799 stack = this.field_22787.field_1724.method_6047();
                String id = !stack.method_7960() ? class_7923.field_41178.method_10221((Object)stack.method_7909()).toString() : "minecraft:air";
                this.iconField.method_1852(id);
                this.slot.itemId = id;
                this.slot.clearCache();
            }
        }).method_46434(left + iconFieldWidth + buttonWidth + 10, baseY + 114, buttonWidth, 20).method_46431();
        this.method_37063((class_364)this.handButton);
        int actionY = baseY + 152 + 10;
        int halfWidth = (contentWidth - 10) / 2;
        this.saveButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.radial.editor.save"), btn -> {
            RadialConfig.save();
            if (this.field_22787 != null) {
                this.field_22787.method_1507(null);
            }
        }).method_46434(left, actionY, halfWidth, 20).method_46431();
        this.method_37063((class_364)this.saveButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"screen.radial.editor.cancel"), btn -> this.method_25419()).method_46434(left + halfWidth + 10, actionY, halfWidth, 20).method_46431();
        this.method_37063((class_364)this.cancelButton);
        this.refreshWidgets();
    }

    private class_2561 getSliderText(int value) {
        return class_2561.method_43469((String)"screen.radial.editor.sub_size", (Object[])new Object[]{value});
    }

    private void ensureChildren() {
        if (this.slot.children == null) {
            this.slot.children = new ArrayList<RadialSlot>();
        }
        while (this.slot.children.size() < this.slot.childSlotCount) {
            this.slot.children.add(new RadialSlot("Sub Slot " + (this.slot.children.size() + 1), SlotMode.EMPTY, "", "minecraft:stone"));
        }
    }

    private void refreshWidgets() {
        boolean isKey;
        boolean isSub = this.slot.mode == SlotMode.SUBMENU;
        boolean isEmpty = this.slot.mode == SlotMode.EMPTY;
        boolean bl = isKey = this.slot.mode == SlotMode.KEYBIND;
        if (isSub) {
            this.ensureChildren();
        }
        this.valueField.method_1862(!isEmpty && !isSub);
        this.valueBrowseButton.field_22764 = isKey;
        this.subCountSlider.field_22764 = isSub;
        this.iconField.method_1862(!isEmpty);
        this.browseIconButton.field_22764 = !isEmpty;
        this.handButton.field_22764 = !isEmpty;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        int centerX = this.field_22789 / 2;
        int contentWidth = Math.min(300, (int)((double)this.field_22789 * 0.9));
        int left = centerX - contentWidth / 2;
        int baseY = this.field_22790 / 2 - 60;
        context.method_52706(class_10799.field_56883, SLOT_TEXTURE, centerX - 13, this.field_22790 / 2 - 110, 26, 26);
        context.method_51427(this.slot.getRenderStack(), centerX - 8, this.field_22790 / 2 - 105);
        context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.radial.editor.name"), left, baseY - 12, -5592406);
        if (this.slot.mode == SlotMode.SUBMENU) {
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.radial.editor.submenu"), left, baseY + 76 - 12, -5592406);
        } else if (this.slot.mode != SlotMode.EMPTY) {
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.radial.editor.value"), left, baseY + 76 - 12, -5592406);
        }
        if (this.slot.mode != SlotMode.EMPTY) {
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43471((String)"screen.radial.editor.icon"), left, baseY + 114 - 12, -5592406);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25419() {
        if (this.saveButton != null && !this.saveButton.method_25370()) {
            this.slot.name = this.oldName;
            this.slot.value = this.oldValue;
            this.slot.itemId = this.oldId;
            this.slot.mode = this.oldMode;
            this.slot.childSlotCount = this.oldChildCount;
            this.slot.clearCache();
        }
        Objects.requireNonNull(this.field_22787).method_1507(null);
    }

    public boolean method_25421() {
        return false;
    }
}

