/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.block.entity;

import com.logistics.LogisticsMod;
import com.logistics.block.PipeBlock;
import com.logistics.block.entity.LogisticsBlockEntities;
import com.logistics.block.entity.PipeItemStorage;
import com.logistics.pipe.Pipe;
import com.logistics.pipe.PipeContext;
import com.logistics.pipe.runtime.PipeRuntime;
import com.logistics.pipe.runtime.TravelingItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class PipeBlockEntity
extends class_2586 {
    public static final int VIRTUAL_CAPACITY = 320;
    private final List<TravelingItem> travelingItems = new ArrayList<TravelingItem>();
    private final class_2487 moduleState = new class_2487();
    private int lastConnectionsMask = -1;
    private final PipeBlock.ConnectionType[] connectionTypes = new PipeBlock.ConnectionType[6];

    public PipeBlockEntity(class_2338 pos, class_2680 state) {
        super(LogisticsBlockEntities.PIPE_BLOCK_ENTITY, pos, state);
        for (int i = 0; i < 6; ++i) {
            this.connectionTypes[i] = PipeBlock.ConnectionType.NONE;
        }
    }

    public PipeBlock.ConnectionType getConnectionType(class_2350 direction) {
        return this.connectionTypes[direction.ordinal()];
    }

    public void setConnectionType(class_2350 direction, PipeBlock.ConnectionType type) {
        this.connectionTypes[direction.ordinal()] = type;
    }

    public boolean addItem(TravelingItem item, class_2350 fromDirection, boolean bypassIngress) {
        long accepted = this.getInsertableAmount(item.getStack().method_7947(), fromDirection, item.getStack(), bypassIngress);
        if (accepted <= 0L) {
            PipeBlockEntity.dropItem(this.field_11863, this.field_11867, item);
            return false;
        }
        TravelingItem remainder = null;
        if (accepted < (long)item.getStack().method_7947()) {
            class_1799 remainderStack = item.getStack().method_7972();
            remainderStack.method_7939(item.getStack().method_7947() - (int)accepted);
            remainder = new TravelingItem(remainderStack, fromDirection.method_10153(), item.getSpeed());
        }
        class_1799 acceptedStack = item.getStack().method_7972();
        acceptedStack.method_7939((int)accepted);
        this.acceptInsertedStack(acceptedStack, fromDirection, Float.valueOf(item.getSpeed()));
        if (remainder != null) {
            PipeBlockEntity.dropItem(this.field_11863, this.field_11867, remainder);
            return false;
        }
        return true;
    }

    public boolean forceAddItem(TravelingItem item, class_2350 fromDirection) {
        return this.addItem(item, fromDirection, true);
    }

    public List<TravelingItem> getTravelingItems() {
        return this.travelingItems;
    }

    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        if (!this.travelingItems.isEmpty()) {
            class_11372.class_11373 appender = view.method_71467("TravelingItems", TravelingItem.CODEC);
            for (TravelingItem item : this.travelingItems) {
                appender.method_71484((Object)item);
            }
        } else {
            view.method_71478("TravelingItems");
        }
        if (!this.moduleState.method_33133()) {
            view.method_71468("ModuleState", class_2487.field_25128, (Object)this.moduleState);
        } else {
            view.method_71478("ModuleState");
        }
        class_2487 connectionsNbt = new class_2487();
        for (class_2350 direction : class_2350.values()) {
            PipeBlock.ConnectionType type = this.connectionTypes[direction.ordinal()];
            if (type == PipeBlock.ConnectionType.NONE) continue;
            connectionsNbt.method_10582(direction.name().toLowerCase(), type.method_15434());
        }
        if (!connectionsNbt.method_33133()) {
            view.method_71468("Connections", class_2487.field_25128, (Object)connectionsNbt);
        } else {
            view.method_71478("Connections");
        }
    }

    protected void method_11014(class_11368 view) {
        long readStart = System.nanoTime();
        super.method_11014(view);
        this.travelingItems.clear();
        view.method_71435("TravelingItems", TravelingItem.CODEC).ifPresent(list -> list.forEach(this.travelingItems::add));
        if (!this.moduleState.method_10541().isEmpty()) {
            for (String key : new ArrayList(this.moduleState.method_10541())) {
                this.moduleState.method_10551(key);
            }
        }
        view.method_71426("ModuleState", class_2487.field_25128).ifPresent(stored -> {
            for (String key : stored.method_10541()) {
                this.moduleState.method_10566(key, Objects.requireNonNull(stored.method_10580(key)).method_10707());
            }
        });
        view.method_71426("Connections", class_2487.field_25128).ifPresent(connectionsNbt -> {
            for (int i = 0; i < 6; ++i) {
                this.connectionTypes[i] = PipeBlock.ConnectionType.NONE;
            }
            block1: for (class_2350 direction : class_2350.values()) {
                String typeName = connectionsNbt.method_10558(direction.name().toLowerCase()).orElse("none");
                for (PipeBlock.ConnectionType type : PipeBlock.ConnectionType.values()) {
                    if (!type.method_15434().equals(typeName)) continue;
                    this.connectionTypes[direction.ordinal()] = type;
                    continue block1;
                }
            }
        });
        long durationMs = (System.nanoTime() - readStart) / 1000000L;
        if (durationMs >= 2L && Boolean.getBoolean("logistics.timing")) {
            LogisticsMod.LOGGER.info("[timing] PipeBlockEntity readData at {} took {} ms (items={})", new Object[]{this.method_11016(), durationMs, this.travelingItems.size()});
        }
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registries) {
        return this.method_38244(registries);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PipeBlockEntity blockEntity) {
        PipeRuntime.tick(world, pos, state, blockEntity);
    }

    public static void dropItem(class_1937 world, class_2338 pos, TravelingItem item) {
        class_243 spawnPos = class_243.method_24953((class_2382)pos);
        class_1542 itemEntity = new class_1542(world, spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350, item.getStack().method_7972());
        itemEntity.method_6988();
        world.method_8649((class_1297)itemEntity);
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            for (TravelingItem travelingItem : this.travelingItems) {
                class_1542 itemEntity = new class_1542(this.field_11863, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, travelingItem.getStack().method_7972());
                itemEntity.method_6988();
                this.field_11863.method_8649((class_1297)itemEntity);
            }
        }
    }

    public class_2487 getOrCreateModuleState(String key) {
        if (!this.moduleState.method_10545(key)) {
            this.moduleState.method_10566(key, (class_2520)new class_2487());
        }
        return this.moduleState.method_10562(key).orElseGet(class_2487::new);
    }

    public PipeContext createContext() {
        return new PipeContext(this.field_11863, this.field_11867, this.method_11010(), this);
    }

    public int getLastConnectionsMask() {
        return this.lastConnectionsMask;
    }

    public void setLastConnectionsMask(int lastConnectionsMask) {
        this.lastConnectionsMask = lastConnectionsMask;
    }

    @Nullable
    public Storage<ItemVariant> getItemStorage(@Nullable class_2350 side) {
        if (side == null || this.field_11863 == null) {
            return null;
        }
        class_2680 state = this.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof PipeBlock)) {
            return null;
        }
        PipeBlock pipeBlock = (PipeBlock)class_22482;
        if (pipeBlock.getPipe() != null) {
            PipeContext context = new PipeContext(this.field_11863, this.field_11867, state, this);
            Pipe modulePipe = pipeBlock.getPipe();
            if (modulePipe.canAcceptFrom(context, side, class_1799.field_8037)) {
                return new PipeItemStorage(this, side);
            }
            return null;
        }
        return null;
    }

    long getInsertableAmount(long maxAmount, class_2350 fromDirection, class_1799 stack) {
        return this.getInsertableAmount(maxAmount, fromDirection, stack, false);
    }

    long getInsertableAmount(long maxAmount, class_2350 fromDirection, class_1799 stack, boolean bypassIngress) {
        boolean fromPipe;
        if (maxAmount <= 0L) {
            return 0L;
        }
        if (!bypassIngress && !this.canAcceptFrom(fromDirection, fromPipe = this.isNeighborPipe(fromDirection), stack)) {
            return 0L;
        }
        int remaining = this.getRemainingCapacity();
        if (remaining <= 0) {
            return 0L;
        }
        return Math.min(maxAmount, (long)remaining);
    }

    void acceptInsertedStack(class_1799 stack, class_2350 fromDirection, @Nullable Float speedOverride) {
        if (stack.method_7960()) {
            return;
        }
        float speed = speedOverride != null ? speedOverride.floatValue() : this.getInitialSpeed();
        TravelingItem newItem = new TravelingItem(stack, fromDirection.method_10153(), speed);
        this.travelingItems.add(newItem);
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    private float getInitialSpeed() {
        PipeBlock pipeBlock;
        if (this.field_11863 == null) {
            return 0.016666668f;
        }
        class_2680 state = this.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof PipeBlock && (pipeBlock = (PipeBlock)class_22482).getPipe() != null) {
            return 0.016666668f;
        }
        return 0.016666668f;
    }

    private boolean isNeighborPipe(class_2350 fromDirection) {
        if (this.field_11863 == null) {
            return false;
        }
        class_2338 sourcePos = this.field_11867.method_10093(fromDirection);
        class_2680 sourceState = this.field_11863.method_8320(sourcePos);
        return sourceState.method_26204() instanceof PipeBlock;
    }

    private boolean canAcceptFrom(class_2350 fromDirection, boolean fromPipe, class_1799 stack) {
        if (this.field_11863 == null) {
            return false;
        }
        class_2680 state = this.method_11010();
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof PipeBlock)) {
            return false;
        }
        PipeBlock pipeBlock = (PipeBlock)class_22482;
        if (pipeBlock.getPipe() != null) {
            PipeContext context = new PipeContext(this.field_11863, this.field_11867, state, this);
            return pipeBlock.getPipe().canAcceptFrom(context, fromDirection, stack);
        }
        return false;
    }

    private int getRemainingCapacity() {
        return 320 - this.getTotalItemCount();
    }

    private int getTotalItemCount() {
        int total = 0;
        for (TravelingItem item : this.travelingItems) {
            total += item.getStack().method_7947();
        }
        return total;
    }

    public int getComparatorOutput() {
        int total = this.getTotalItemCount();
        if (total <= 0) {
            return 0;
        }
        int clamped = Math.min(total, 320);
        return Math.max(1, clamped * 15 / 320);
    }
}

