/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.pipe;

import com.logistics.block.PipeBlock;
import com.logistics.pipe.PipeContext;
import com.logistics.pipe.modules.Module;
import com.logistics.pipe.runtime.RoutePlan;
import com.logistics.pipe.runtime.TravelingItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public abstract class Pipe {
    private final List<Module> modules;
    private PipeBlock pipeBlock;

    protected Pipe(Module ... modules) {
        this.modules = List.of(modules);
    }

    public void setPipeBlock(PipeBlock block) {
        this.pipeBlock = block;
    }

    public String getPipeName() {
        if (this.pipeBlock == null) {
            throw new IllegalStateException("Pipe has not been registered yet");
        }
        return class_7923.field_41175.method_10221((Object)this.pipeBlock).method_12832();
    }

    public class_2960 getCoreModelId() {
        return class_2960.method_60655((String)"logistics", (String)("block/" + this.getPipeName() + "_core"));
    }

    public class_2960 getPipeArm(PipeContext ctx, class_2350 direction) {
        for (Module module : this.modules) {
            class_2960 override = module.getPipeArm(ctx, direction);
            if (override == null) continue;
            return override;
        }
        return class_2960.method_60655((String)"logistics", (String)this.getModelBasePath(direction));
    }

    public List<class_2960> getPipeDecorations(PipeContext ctx, class_2350 direction) {
        ArrayList<class_2960> models = new ArrayList<class_2960>();
        if (ctx.isInventoryConnection(direction)) {
            models.add(class_2960.method_60655((String)"logistics", (String)(this.getModelBasePath(direction) + "_extension")));
        }
        for (Module module : this.modules) {
            models.addAll(module.getPipeDecorations(ctx, direction));
        }
        return models;
    }

    public String getModelBasePath(class_2350 direction) {
        return "block/" + this.getPipeName() + "_" + direction.name().toLowerCase();
    }

    public <T extends Module> T getModule(Class<T> moduleClass) {
        for (Module module : this.modules) {
            if (!moduleClass.isInstance(module)) continue;
            return (T)module;
        }
        return null;
    }

    public float getAccelerationRate(PipeContext ctx) {
        for (Module module : this.modules) {
            float accel = module.getAcceleration(ctx);
            if (!(accel > 0.0f)) continue;
            return accel;
        }
        return 0.0f;
    }

    public float getDrag(PipeContext ctx) {
        for (Module module : this.modules) {
            float drag = module.getDrag(ctx);
            if (!(drag > 0.0f)) continue;
            return drag;
        }
        return 0.00536f;
    }

    public float getMaxSpeed(PipeContext ctx) {
        for (Module module : this.modules) {
            float max = module.getMaxSpeed(ctx);
            if (!(max > 0.0f)) continue;
            return max;
        }
        return 0.25f;
    }

    public RoutePlan route(PipeContext ctx, TravelingItem item, List<class_2350> options) {
        for (Module module : this.modules) {
            RoutePlan plan = module.route(ctx, item, options);
            if (plan.getType() == RoutePlan.Type.PASS) continue;
            return plan;
        }
        return RoutePlan.pass();
    }

    public boolean canAcceptFrom(PipeContext ctx, class_2350 from, class_1799 stack) {
        if (!ctx.isNeighborPipe(from)) {
            return false;
        }
        for (Module module : this.modules) {
            if (module.canAcceptFrom(ctx, from, stack)) continue;
            return false;
        }
        return true;
    }

    public boolean discardWhenNoRoute(PipeContext ctx) {
        for (Module module : this.modules) {
            if (!module.discardWhenNoRoute(ctx)) continue;
            return true;
        }
        return false;
    }

    public void onWrenchUse(PipeContext ctx, class_1838 usage) {
        for (Module module : this.modules) {
            module.onWrenchUse(ctx, usage);
        }
    }

    public void onConnectionsChanged(PipeContext ctx, List<class_2350> connected) {
        for (Module module : this.modules) {
            module.onConnectionsChanged(ctx, connected);
        }
    }

    public void onTick(PipeContext ctx) {
        for (Module module : this.modules) {
            module.onTick(ctx);
        }
    }

    public boolean hasComparatorOutput() {
        for (Module module : this.modules) {
            if (!module.hasComparatorOutput()) continue;
            return true;
        }
        return false;
    }

    public int getComparatorOutput(PipeContext ctx) {
        int output = 0;
        for (Module module : this.modules) {
            output = Math.max(output, module.comparatorOutput(ctx));
        }
        return output;
    }

    public void randomDisplayTick(PipeContext ctx, class_5819 random) {
        for (Module module : this.modules) {
            module.randomDisplayTick(ctx, random);
        }
    }

    public PipeBlock.ConnectionType filterConnection(@Nullable PipeContext ctx, class_2350 direction, class_2248 neighborBlock, PipeBlock.ConnectionType candidate) {
        if (candidate == PipeBlock.ConnectionType.NONE) {
            return PipeBlock.ConnectionType.NONE;
        }
        for (Module module : this.modules) {
            if (module.allowsConnection(ctx, direction, this, neighborBlock)) continue;
            return PipeBlock.ConnectionType.NONE;
        }
        return candidate;
    }
}

