/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.pipe.modules;

import com.logistics.pipe.PipeContext;
import com.logistics.pipe.modules.Module;
import com.logistics.pipe.runtime.TravelingItem;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ExtractionModule
implements Module {
    private static final String EXTRACT_FROM = "extract_direction";

    @Override
    public void onTick(PipeContext ctx) {
        Module.super.onTick(ctx);
        if (ctx.world().method_8608()) {
            return;
        }
        if (ctx.world().method_75260() % 60L != 0L) {
            return;
        }
        class_2350 extractDirection = this.getExtractionDirection(ctx);
        if (extractDirection != null && ctx.getInventoryConnections().contains(extractDirection)) {
            this.extractFromDirection(ctx, extractDirection);
            return;
        }
        List<class_2350> inventoryFaces = ctx.getInventoryConnections();
        if (inventoryFaces.size() == 1) {
            class_2350 selected = inventoryFaces.getFirst();
            this.setExtractionDirection(ctx, selected);
            this.extractFromDirection(ctx, selected);
        }
    }

    @Override
    public void onConnectionsChanged(PipeContext ctx, List<class_2350> options) {
        List<class_2350> inventoryFaces = ctx.getInventoryConnections();
        if (inventoryFaces.isEmpty()) {
            this.setExtractionDirection(ctx, null);
            return;
        }
        class_2350 current = this.getExtractionDirection(ctx);
        if (current == null || !inventoryFaces.contains(current)) {
            this.setExtractionDirection(ctx, inventoryFaces.getFirst());
        }
    }

    @Override
    public void onWrenchUse(PipeContext ctx, class_1838 usage) {
        List<class_2350> connected = ctx.getInventoryConnections();
        if (connected.isEmpty()) {
            this.setExtractionDirection(ctx, null);
            return;
        }
        class_2350 current = this.getExtractionDirection(ctx);
        class_2350 next = this.nextInCycle(connected, current);
        this.setExtractionDirection(ctx, next);
    }

    @Override
    public boolean canAcceptFrom(PipeContext ctx, class_2350 from, class_1799 stack) {
        return false;
    }

    @Nullable
    private class_2350 getExtractionDirection(PipeContext ctx) {
        class_2487 state = ctx.moduleState(this.getStateKey());
        if (!state.method_10545(EXTRACT_FROM)) {
            return null;
        }
        return state.method_10558(EXTRACT_FROM).map(class_2350::method_10168).orElse(null);
    }

    private void setExtractionDirection(PipeContext ctx, @Nullable class_2350 direction) {
        class_2350 current = this.getExtractionDirection(ctx);
        if (current == direction) {
            return;
        }
        if (direction == null) {
            ctx.remove(this, EXTRACT_FROM);
        } else {
            ctx.saveString(this, EXTRACT_FROM, direction.method_10151());
        }
        ctx.markDirtyAndSync();
    }

    private class_2350 nextInCycle(List<class_2350> ordered, @Nullable class_2350 current) {
        if (ordered.isEmpty()) {
            throw new IllegalArgumentException("ordered directions must not be empty");
        }
        int idx = current == null ? -1 : ordered.indexOf(current);
        return idx < 0 ? ordered.getFirst() : ordered.get((idx + 1) % ordered.size());
    }

    private boolean extractFromDirection(PipeContext ctx, class_2350 direction) {
        class_2338 targetPos = ctx.pos().method_10093(direction);
        Storage storage = (Storage)ItemStorage.SIDED.find(ctx.world(), targetPos, (Object)direction.method_10153());
        if (storage == null) {
            return false;
        }
        try (Transaction transaction = Transaction.openOuter();){
            for (StorageView view : storage) {
                ItemVariant variant = (ItemVariant)view.getResource();
                if (variant.isBlank()) continue;
                long extracted = view.extract((Object)variant, 1L, (TransactionContext)transaction);
                if (extracted <= 0L) continue;
                class_1799 stack = variant.toStack((int)extracted);
                TravelingItem item = new TravelingItem(stack, direction.method_10153(), 0.016666668f);
                ctx.blockEntity().forceAddItem(item, direction);
                transaction.commit();
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public class_2960 getPipeArm(PipeContext ctx, class_2350 direction) {
        if (!this.isExtractionFace(ctx, direction)) {
            return null;
        }
        return class_2960.method_60655((String)"logistics", (String)this.featureBasePath(ctx, direction));
    }

    @Override
    public List<class_2960> getPipeDecorations(PipeContext ctx, class_2350 direction) {
        if (!this.isExtractionFace(ctx, direction) || !ctx.isInventoryConnection(direction)) {
            return List.of();
        }
        return List.of(class_2960.method_60655((String)"logistics", (String)(this.featureBasePath(ctx, direction) + "_extension")));
    }

    private boolean isExtractionFace(PipeContext ctx, class_2350 direction) {
        return this.getExtractionDirection(ctx) == direction;
    }

    private String featureBasePath(PipeContext ctx, class_2350 direction) {
        return ctx.pipe().getModelBasePath(direction) + "_feature";
    }
}

