/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.pipe.modules;

import com.logistics.pipe.PipeContext;
import com.logistics.pipe.modules.Module;
import com.logistics.pipe.runtime.RoutePlan;
import com.logistics.pipe.runtime.TravelingItem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;

public class InsertionModule
implements Module {
    @Override
    public RoutePlan route(PipeContext ctx, TravelingItem item, List<class_2350> options) {
        if (options == null || options.isEmpty()) {
            return RoutePlan.drop();
        }
        ArrayList<class_2350> inventoryWithSpace = new ArrayList<class_2350>();
        ArrayList<class_2350> pipeDirections = new ArrayList<class_2350>();
        for (class_2350 direction : options) {
            if (ctx.isInventoryConnection(direction)) {
                if (!this.hasInsertSpace(ctx, item, direction)) continue;
                inventoryWithSpace.add(direction);
                continue;
            }
            if (!ctx.isNeighborPipe(direction)) continue;
            pipeDirections.add(direction);
        }
        if (!inventoryWithSpace.isEmpty()) {
            return RoutePlan.reroute(inventoryWithSpace);
        }
        if (!pipeDirections.isEmpty()) {
            return RoutePlan.reroute(pipeDirections);
        }
        return RoutePlan.drop();
    }

    private boolean hasInsertSpace(PipeContext ctx, TravelingItem item, class_2350 direction) {
        class_2338 targetPos = ctx.pos().method_10093(direction);
        Storage storage = (Storage)ItemStorage.SIDED.find(ctx.world(), targetPos, (Object)direction.method_10153());
        if (storage == null) {
            return false;
        }
        ItemVariant variant = ItemVariant.of((class_1799)item.getStack());
        long amount = item.getStack().method_7947();
        if (variant.isBlank() || amount <= 0L) {
            return false;
        }
        try (Transaction transaction = Transaction.openOuter();){
            boolean bl = storage.insert((Object)variant, amount, (TransactionContext)transaction) > 0L;
            return bl;
        }
    }
}

