/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.pipe.modules;

import com.logistics.block.entity.PipeBlockEntity;
import com.logistics.pipe.PipeContext;
import com.logistics.pipe.modules.Module;
import com.logistics.pipe.runtime.RoutePlan;
import com.logistics.pipe.runtime.TravelingItem;
import com.logistics.pipe.ui.ItemFilterScreenHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_747;
import net.minecraft.class_7923;

public class ItemFilterModule
implements Module {
    private static final String FILTERS = "filters";
    public static final int FILTER_SLOTS_PER_SIDE = 8;
    public static final class_2350[] FILTER_ORDER = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034, class_2350.field_11036, class_2350.field_11033};

    @Override
    public RoutePlan route(PipeContext ctx, TravelingItem item, List<class_2350> options) {
        if (options == null) {
            options = List.of();
        }
        String itemId = class_7923.field_41178.method_10221((Object)item.getStack().method_7909()).toString();
        ArrayList<class_2350> matches = new ArrayList<class_2350>();
        ArrayList<class_2350> fallbacks = new ArrayList<class_2350>();
        for (class_2350 class_23502 : options) {
            List<String> filters = this.getFiltersForSide(ctx, class_23502);
            if (filters.isEmpty()) {
                fallbacks.add(class_23502);
                continue;
            }
            if (!filters.contains(itemId)) continue;
            matches.add(class_23502);
        }
        ArrayList<class_2350> candidates = !matches.isEmpty() ? matches : fallbacks;
        return RoutePlan.reroute(candidates);
    }

    @Override
    public void onWrenchUse(PipeContext ctx, class_1838 usage) {
        if (ctx.world().method_8608()) {
            return;
        }
        class_1657 class_16572 = usage.method_8036();
        if (!(class_16572 instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)class_16572;
        class_1937 world = ctx.world();
        class_2338 pos = ctx.pos();
        player.method_17355((class_3908)new class_747((syncId, inventory, playerEntity) -> {
            PipeBlockEntity entity;
            class_2586 patt0$temp = world.method_8321(pos);
            PipeBlockEntity pipeEntity = patt0$temp instanceof PipeBlockEntity ? (entity = (PipeBlockEntity)patt0$temp) : null;
            return new ItemFilterScreenHandler(syncId, inventory, pipeEntity);
        }, (class_2561)class_2561.method_43471((String)"screen.logistics.item_filter")));
    }

    public static int getFilterColor(class_2350 direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043 -> 4159204;
            case class_2350.field_11035 -> 14237503;
            case class_2350.field_11039 -> 13218618;
            case class_2350.field_11034 -> 5942861;
            case class_2350.field_11036 -> 0xE5E5E5;
            case class_2350.field_11033 -> 0x4A4A4A;
        };
    }

    public List<String> getFilterSlots(PipeContext ctx, class_2350 direction) {
        class_2487 filters = ctx.getNbtCompound(this, FILTERS);
        class_2499 list = filters.method_68569(direction.method_10151());
        ArrayList<String> slots = new ArrayList<String>(8);
        for (int i = 0; i < 8; ++i) {
            if (i < list.size()) {
                slots.add(list.method_10608(i).orElse(""));
                continue;
            }
            slots.add("");
        }
        return slots;
    }

    public void setFilterSlots(PipeContext ctx, class_2350 direction, List<String> slots) {
        class_2487 filters = ctx.getNbtCompound(this, FILTERS);
        class_2499 list = new class_2499();
        boolean hasAny = false;
        for (String slot : slots) {
            String value;
            String string = value = slot == null ? "" : slot;
            if (!value.isEmpty()) {
                hasAny = true;
            }
            list.add((Object)class_2519.method_23256((String)value));
        }
        if (hasAny) {
            filters.method_10566(direction.method_10151(), (class_2520)list);
        } else {
            filters.method_10551(direction.method_10151());
        }
        if (!filters.method_33133()) {
            ctx.putNbtCompound(this, FILTERS, filters);
        } else {
            ctx.remove(this, FILTERS);
        }
    }

    private List<String> getFiltersForSide(PipeContext ctx, class_2350 direction) {
        List<String> slots = this.getFilterSlots(ctx, direction);
        ArrayList<String> ids = new ArrayList<String>(slots.size());
        for (String id : slots) {
            if (id.isEmpty()) continue;
            ids.add(id);
        }
        return ids;
    }
}

