/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.pipe.runtime;

import com.logistics.block.PipeBlock;
import com.logistics.block.entity.PipeBlockEntity;
import com.logistics.block.entity.PipeItemStorage;
import com.logistics.pipe.Pipe;
import com.logistics.pipe.PipeContext;
import com.logistics.pipe.runtime.RoutePlan;
import com.logistics.pipe.runtime.TravelingItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public final class PipeRuntime {
    private PipeRuntime() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void tick(class_1937 world, class_2338 pos, class_2680 state, PipeBlockEntity blockEntity) {
        PipeBlock pipeBlock;
        float maxSpeed = 0.25f;
        float accelerationRate = 0.0f;
        float dragCoefficient = 0.00536f;
        Pipe pipe = null;
        PipeContext pipeContext = null;
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof PipeBlock && (pipeBlock = (PipeBlock)class_22482).getPipe() != null) {
            pipe = pipeBlock.getPipe();
            pipeContext = new PipeContext(world, pos, state, blockEntity);
            maxSpeed = pipe.getMaxSpeed(pipeContext);
            accelerationRate = pipe.getAccelerationRate(pipeContext);
            dragCoefficient = pipe.getDrag(pipeContext);
        }
        boolean needsSync = false;
        if (pipe != null && pipeContext != null) {
            class_2350[] class_2350Array = state.method_26204();
            if (class_2350Array instanceof PipeBlock) {
                PipeBlock pipeBlock2 = (PipeBlock)class_2350Array;
                for (class_2350 direction : class_2350.values()) {
                    PipeBlock.ConnectionType type = pipeBlock2.getDynamicConnectionType((class_1922)world, pos, direction);
                    blockEntity.setConnectionType(direction, type);
                }
            }
            List<class_2350> connected = PipeRuntime.getAllConnectedDirections(world, pos, state);
            int mask = 0;
            for (class_2350 d : connected) {
                mask |= 1 << d.method_10146();
            }
            if (mask != blockEntity.getLastConnectionsMask()) {
                blockEntity.setLastConnectionsMask(mask);
                pipe.onConnectionsChanged(pipeContext, connected);
                if (!world.method_8608()) {
                    needsSync = true;
                }
            }
            pipe.onTick(pipeContext);
        }
        ArrayList<TravelingItem> itemsToRoute = new ArrayList<TravelingItem>();
        ArrayList<TravelingItem> itemsToRemove = new ArrayList<TravelingItem>();
        ArrayList<TravelingItem> itemsToDiscard = new ArrayList<TravelingItem>();
        ArrayList<TravelingItem> itemsToReplace = new ArrayList<TravelingItem>();
        ArrayList<TravelingItem> itemsToAdd = new ArrayList<TravelingItem>();
        for (TravelingItem item : blockEntity.getTravelingItems()) {
            block33: {
                class_2350 newDirection;
                block34: {
                    RoutePlan.Type type;
                    RoutePlan plan;
                    block35: {
                        float progressBefore = item.getProgress();
                        if (item.tick(accelerationRate, dragCoefficient, maxSpeed)) {
                            itemsToRoute.add(item);
                        }
                        if (!(progressBefore < 0.5f) || !(item.getProgress() >= 0.5f)) break block33;
                        if (pipe == null || pipeContext == null || item.isRouted()) break block34;
                        List<class_2350> validDirections = PipeRuntime.getValidDirections(world, pos, state, item.getDirection());
                        if (validDirections.isEmpty()) {
                            if (pipe.discardWhenNoRoute(pipeContext)) {
                                itemsToDiscard.add(item);
                            } else if (!world.method_8608()) {
                                PipeBlockEntity.dropItem(world, pos, item);
                            }
                            itemsToRoute.remove(item);
                            needsSync = true;
                            continue;
                        }
                        plan = pipe.route(pipeContext, item, validDirections);
                        type = plan.getType();
                        if (type == RoutePlan.Type.PASS) {
                            plan = RoutePlan.reroute(validDirections);
                            type = RoutePlan.Type.REROUTE;
                        }
                        if (type == RoutePlan.Type.DROP) {
                            if (!world.method_8608()) {
                                PipeBlockEntity.dropItem(world, pos, item);
                            }
                            itemsToDiscard.add(item);
                            itemsToRoute.remove(item);
                            needsSync = true;
                            continue;
                        }
                        if (type == RoutePlan.Type.DISCARD) {
                            itemsToDiscard.add(item);
                            itemsToRoute.remove(item);
                            needsSync = true;
                            continue;
                        }
                        if (type != RoutePlan.Type.REROUTE) break block35;
                        List<class_2350> candidates = plan.getDirections();
                        if (candidates.isEmpty()) {
                            if (!world.method_8608()) {
                                PipeBlockEntity.dropItem(world, pos, item);
                            }
                            itemsToDiscard.add(item);
                            itemsToRoute.remove(item);
                            needsSync = true;
                            continue;
                        }
                        class_2350 chosen = candidates.size() == 1 ? candidates.getFirst() : PipeRuntime.chooseRandomDirection(pipeContext, item.getDirection(), candidates);
                        item.setDirection(chosen);
                        item.setRouted(true);
                        if (!world.method_8608()) {
                            needsSync = true;
                        }
                        break block33;
                    }
                    if (type != RoutePlan.Type.SPLIT) break block33;
                    List<TravelingItem> routed = plan.getItems();
                    if (routed.isEmpty()) {
                        itemsToDiscard.add(item);
                        itemsToRoute.remove(item);
                        needsSync = true;
                        continue;
                    }
                    if (routed.size() == 1 && routed.get(0) == item) {
                        item.setRouted(true);
                        if (!world.method_8608()) {
                            needsSync = true;
                        }
                        break block33;
                    } else {
                        itemsToReplace.add(item);
                        itemsToRoute.remove(item);
                        for (TravelingItem routedItem : routed) {
                            if (routedItem != item) {
                                routedItem.setProgress(item.getProgress());
                                routedItem.setSpeed(item.getSpeed());
                                routedItem.setRouted(true);
                            }
                            itemsToAdd.add(routedItem);
                        }
                        needsSync = true;
                        continue;
                    }
                }
                if (pipe == null && (newDirection = PipeRuntime.chooseDirection(world, pos, state, item.getDirection())) != null && newDirection != item.getDirection()) {
                    item.setDirection(newDirection);
                    if (!world.method_8608()) {
                        needsSync = true;
                    }
                }
            }
            if (!world.method_8608() || !(item.getProgress() > 1.3f)) continue;
            itemsToRemove.add(item);
        }
        if (world.method_8608()) {
            blockEntity.getTravelingItems().removeAll(itemsToRemove);
            blockEntity.getTravelingItems().removeAll(itemsToDiscard);
            blockEntity.getTravelingItems().removeAll(itemsToReplace);
            blockEntity.getTravelingItems().addAll(itemsToAdd);
        } else {
            blockEntity.getTravelingItems().removeAll(itemsToRoute);
            blockEntity.getTravelingItems().removeAll(itemsToDiscard);
            blockEntity.getTravelingItems().removeAll(itemsToReplace);
            blockEntity.getTravelingItems().addAll(itemsToAdd);
        }
        if (!world.method_8608() && needsSync) {
            blockEntity.method_5431();
            world.method_8413(pos, state, state, 3);
        }
        if (!(world.method_8608() || itemsToRoute.isEmpty() && itemsToDiscard.isEmpty() && itemsToAdd.isEmpty())) {
            for (TravelingItem item : itemsToRoute) {
                PipeRuntime.routeItem(world, pos, state, blockEntity, item);
            }
            blockEntity.method_5431();
            world.method_8413(pos, state, state, 3);
        }
    }

    private static void routeItem(class_1937 world, class_2338 pos, class_2680 state, PipeBlockEntity blockEntity, TravelingItem item) {
        class_2350 direction = item.getDirection();
        class_2338 targetPos = pos.method_10093(direction);
        Storage storage = (Storage)ItemStorage.SIDED.find(world, targetPos, (Object)direction.method_10153());
        if (storage != null) {
            try (Transaction transaction = Transaction.openOuter();){
                long inserted;
                if (storage instanceof PipeItemStorage) {
                    PipeItemStorage pipeStorage = (PipeItemStorage)storage;
                    inserted = pipeStorage.insert(item, (TransactionContext)transaction);
                } else {
                    ItemVariant variant = ItemVariant.of((class_1799)item.getStack());
                    inserted = storage.insert((Object)variant, (long)item.getStack().method_7947(), (TransactionContext)transaction);
                }
                if (inserted > 0L) {
                    transaction.commit();
                    if (inserted < (long)item.getStack().method_7947()) {
                        item.getStack().method_7934((int)inserted);
                        PipeBlockEntity.dropItem(world, pos, item);
                    }
                    return;
                }
            }
        }
        PipeBlockEntity.dropItem(world, pos, item);
    }

    private static List<class_2350> getValidDirections(class_1937 world, class_2338 pos, class_2680 state, class_2350 currentDirection) {
        ArrayList<class_2350> validDirections = new ArrayList<class_2350>();
        class_2350 oppositeDirection = currentDirection.method_10153();
        class_2350[] class_2350Array = state.method_26204();
        if (!(class_2350Array instanceof PipeBlock)) {
            return validDirections;
        }
        PipeBlock pipeBlock = (PipeBlock)class_2350Array;
        for (class_2350 direction : class_2350.values()) {
            PipeBlock.ConnectionType type;
            if (direction == oppositeDirection || (type = pipeBlock.getConnectionType((class_1922)world, pos, direction)) == PipeBlock.ConnectionType.NONE) continue;
            validDirections.add(direction);
        }
        return validDirections;
    }

    private static class_2350 chooseRandomDirection(PipeContext ctx, class_2350 currentDirection, List<class_2350> options) {
        long seed = PipeRuntime.mixHash(ctx.pos().method_10063(), ctx.world().method_75260(), currentDirection.method_10146());
        Random random = new Random(seed);
        return options.get(random.nextInt(options.size()));
    }

    private static List<class_2350> getAllConnectedDirections(class_1937 world, class_2338 pos, class_2680 state) {
        ArrayList<class_2350> connected = new ArrayList<class_2350>();
        class_2350[] class_2350Array = state.method_26204();
        if (!(class_2350Array instanceof PipeBlock)) {
            return connected;
        }
        PipeBlock pipeBlock = (PipeBlock)class_2350Array;
        for (class_2350 direction : class_2350.values()) {
            PipeBlock.ConnectionType type = pipeBlock.getConnectionType((class_1922)world, pos, direction);
            if (type == PipeBlock.ConnectionType.NONE) continue;
            connected.add(direction);
        }
        return connected;
    }

    private static class_2350 chooseDirection(class_1937 world, class_2338 pos, class_2680 state, class_2350 currentDirection) {
        List<class_2350> validDirections = PipeRuntime.getValidDirections(world, pos, state, currentDirection);
        if (validDirections.isEmpty()) {
            return null;
        }
        if (validDirections.size() == 1) {
            return validDirections.getFirst();
        }
        long seed = PipeRuntime.mixHash(pos.method_10063(), world.method_75260(), currentDirection.method_10146());
        Random random = new Random(seed);
        return validDirections.get(random.nextInt(validDirections.size()));
    }

    private static long mixHash(long a, long b, long c) {
        long hash = a;
        hash = hash * 31L + b;
        hash = hash * 31L + c;
        hash ^= hash >>> 33;
        hash *= -49064778989728563L;
        hash ^= hash >>> 33;
        hash *= -4265267296055464877L;
        hash ^= hash >>> 33;
        return hash;
    }
}

