/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.pipe.runtime;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1799;
import net.minecraft.class_2350;

public class TravelingItem {
    public static final Codec<TravelingItem> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1799.field_24671.fieldOf("item").forGetter(t -> t.stack), (App)Codec.INT.fieldOf("direction").xmap(class_2350::method_10143, class_2350::method_10146).forGetter(t -> t.direction), (App)Codec.FLOAT.optionalFieldOf("speed", (Object)Float.valueOf(0.016666668f)).forGetter(t -> Float.valueOf(t.speed)), (App)Codec.FLOAT.optionalFieldOf("progress", (Object)Float.valueOf(0.0f)).forGetter(t -> Float.valueOf(t.progress)), (App)Codec.BOOL.optionalFieldOf("routed", (Object)false).forGetter(t -> t.routed)).apply((Applicative)instance, TravelingItem::fromCodec));
    private class_1799 stack;
    private float progress;
    private class_2350 direction;
    private float speed;
    private boolean routed;

    private static TravelingItem fromCodec(class_1799 stack, class_2350 direction, float speed, float progress, boolean routed) {
        TravelingItem item = new TravelingItem(stack, direction, speed);
        item.progress = progress;
        item.routed = routed;
        return item;
    }

    public TravelingItem(class_1799 stack, class_2350 direction, float speed) {
        this.stack = stack.method_7972();
        this.progress = 0.0f;
        this.direction = direction;
        this.speed = speed;
        this.routed = false;
    }

    public boolean tick(float accelerationRate, float dragCoefficient, float maxSpeed) {
        boolean deceleratingToMax;
        boolean bl = deceleratingToMax = this.speed > maxSpeed;
        if (deceleratingToMax) {
            float remaining = Math.max(1.0E-4f, 1.0f - this.progress);
            float targetSquared = maxSpeed * maxSpeed;
            float currentSquared = this.speed * this.speed;
            float decel = (targetSquared - currentSquared) / (2.0f * remaining);
            this.speed += decel;
            if (this.speed < maxSpeed) {
                this.speed = maxSpeed;
            }
        } else if (accelerationRate != 0.0f) {
            this.speed += accelerationRate;
        } else if (dragCoefficient != 0.0f) {
            this.speed -= this.speed * dragCoefficient;
        }
        if (this.speed < 0.016666668f) {
            this.speed = 0.016666668f;
        } else if (!deceleratingToMax && this.speed > maxSpeed) {
            this.speed = maxSpeed;
        }
        this.progress += this.speed;
        return this.progress >= 1.0f;
    }

    public float getProgress() {
        return this.progress;
    }

    public class_2350 getDirection() {
        return this.direction;
    }

    public void setDirection(class_2350 direction) {
        this.direction = direction;
        this.routed = true;
    }

    public class_1799 getStack() {
        return this.stack;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setProgress(float progress) {
        this.progress = progress;
    }

    public boolean isRouted() {
        return this.routed;
    }

    public void setRouted(boolean routed) {
        this.routed = routed;
    }
}

