/*
 * Decompiled with CFR 0.152.
 */
package com.logistics.pipe.ui;

import com.logistics.block.PipeBlock;
import com.logistics.block.entity.PipeBlockEntity;
import com.logistics.pipe.Pipe;
import com.logistics.pipe.PipeContext;
import com.logistics.pipe.modules.ItemFilterModule;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class FilterInventory
implements class_1263 {
    private final class_2371<class_1799> stacks = class_2371.method_10213((int)(ItemFilterModule.FILTER_ORDER.length * 8), (Object)class_1799.field_8037);
    private final PipeBlockEntity pipeEntity;
    private final ItemFilterModule module;

    public FilterInventory(PipeBlockEntity pipeEntity) {
        this.pipeEntity = pipeEntity;
        this.module = this.getModuleFromPipe(pipeEntity);
        if (pipeEntity != null) {
            this.loadFromBlockEntity();
        }
    }

    private ItemFilterModule getModuleFromPipe(PipeBlockEntity entity) {
        if (entity == null) {
            return new ItemFilterModule();
        }
        PipeBlock block = (PipeBlock)entity.method_11010().method_26204();
        Pipe pipe = block.getPipe();
        ItemFilterModule pipeModule = pipe.getModule(ItemFilterModule.class);
        return pipeModule != null ? pipeModule : new ItemFilterModule();
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.stacks) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.stacks.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 existing = (class_1799)this.stacks.get(slot);
        if (existing.method_7960()) {
            return class_1799.field_8037;
        }
        this.method_5447(slot, class_1799.field_8037);
        return existing;
    }

    public class_1799 method_5441(int slot) {
        class_1799 existing = (class_1799)this.stacks.get(slot);
        this.method_5447(slot, class_1799.field_8037);
        return existing;
    }

    public void method_5447(int slot, class_1799 stack) {
        if (slot < 0 || slot >= this.stacks.size()) {
            return;
        }
        class_1799 copy = stack.method_7960() ? class_1799.field_8037 : stack.method_46651(1);
        this.stacks.set(slot, (Object)copy);
        if (this.pipeEntity != null) {
            this.syncToBlockEntity();
        }
    }

    public void method_5431() {
        if (this.pipeEntity != null) {
            this.syncToBlockEntity();
        }
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        for (int i = 0; i < this.stacks.size(); ++i) {
            this.stacks.set(i, (Object)class_1799.field_8037);
        }
        if (this.pipeEntity != null) {
            this.syncToBlockEntity();
        }
    }

    private void loadFromBlockEntity() {
        int slotIndex = 0;
        PipeContext ctx = this.pipeEntity.createContext();
        for (class_2350 direction : ItemFilterModule.FILTER_ORDER) {
            List<String> slots = this.module.getFilterSlots(ctx, direction);
            for (int i = 0; i < 8; ++i) {
                class_1792 item;
                class_2960 identifier;
                String id = slots.get(i);
                class_1799 stack = class_1799.field_8037;
                if (!id.isEmpty() && (identifier = class_2960.method_12829((String)id)) != null && (item = (class_1792)class_7923.field_41178.method_63535(identifier)) != class_1802.field_8162) {
                    stack = new class_1799((class_1935)item);
                }
                this.stacks.set(slotIndex++, (Object)stack);
            }
        }
    }

    private void syncToBlockEntity() {
        class_1937 world = this.pipeEntity.method_10997();
        if (world == null || world.method_8608()) {
            return;
        }
        int slotIndex = 0;
        PipeContext ctx = this.pipeEntity.createContext();
        for (class_2350 direction : ItemFilterModule.FILTER_ORDER) {
            ArrayList<String> slots = new ArrayList<String>(8);
            for (int i = 0; i < 8; ++i) {
                class_1799 stack;
                if ((stack = (class_1799)this.stacks.get(slotIndex++)).method_7960()) {
                    slots.add("");
                    continue;
                }
                class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
                slots.add(id.toString());
            }
            this.module.setFilterSlots(ctx, direction, slots);
        }
        this.pipeEntity.method_5431();
        world.method_8413(this.pipeEntity.method_11016(), this.pipeEntity.method_11010(), this.pipeEntity.method_11010(), 3);
    }
}

