/*
 * Decompiled with CFR 0.152.
 */
package com.mayflower.steelhold.command;

import com.mayflower.steelhold.content.SafeBlockEntity;
import com.mayflower.steelhold.content.SafeKeyItem;
import com.mayflower.steelhold.registry.ModBlocks;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class SteelholdCommands {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"steelhold").then(Commands.m_82127_((String)"makekey").executes(ctx -> SteelholdCommands.makeKey((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"resetlock").executes(ctx -> SteelholdCommands.resetLock((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"whoowns").executes(ctx -> SteelholdCommands.whoOwns((CommandSourceStack)ctx.getSource()))));
    }

    private static int makeKey(CommandSourceStack source) {
        ServerPlayer player;
        try {
            player = source.m_81375_();
        }
        catch (Exception e) {
            return 0;
        }
        HitResult hit = player.m_19907_(5.0, 0.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            source.m_81352_((Component)Component.m_237113_((String)"Look at a safe within 5 blocks."));
            return 0;
        }
        BlockHitResult bhr = (BlockHitResult)hit;
        BlockPos pos = bhr.m_82425_();
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SafeBlockEntity)) {
            source.m_81352_((Component)Component.m_237113_((String)"That isn't a Steelhold safe."));
            return 0;
        }
        SafeBlockEntity be = (SafeBlockEntity)blockEntity;
        if (be.getOwner() == null || !be.getOwner().equals(player.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)"Only the owner can create keys."));
            return 0;
        }
        ItemStack key = new ItemStack((ItemLike)ModBlocks.SAFE_KEY.get());
        SafeKeyItem.setSafeId(key, be.getSafeId());
        String safeName = be.m_58900_().m_60734_().m_49954_().getString();
        String posString = "X " + pos.m_123341_() + " Y " + pos.m_123342_() + " Z " + pos.m_123343_();
        SafeKeyItem.setSafeInfo(key, safeName, posString);
        key.m_41714_((Component)Component.m_237113_((String)"Safe Key"));
        if (!player.m_150109_().m_36054_(key)) {
            player.m_36176_(key, false);
        }
        source.m_288197_(() -> Component.m_237113_((String)"\u2705 Key created. Give it to someone you trust."), true);
        return 1;
    }

    private static int resetLock(CommandSourceStack source) {
        ServerPlayer player;
        try {
            player = source.m_81375_();
        }
        catch (Exception e) {
            return 0;
        }
        HitResult hit = player.m_19907_(5.0, 0.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            source.m_81352_((Component)Component.m_237113_((String)"Look at a safe within 5 blocks."));
            return 0;
        }
        BlockHitResult bhr = (BlockHitResult)hit;
        BlockPos pos = bhr.m_82425_();
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SafeBlockEntity)) {
            source.m_81352_((Component)Component.m_237113_((String)"That isn't a Steelhold safe."));
            return 0;
        }
        SafeBlockEntity be = (SafeBlockEntity)blockEntity;
        if (be.getOwner() == null || !be.getOwner().equals(player.m_20148_())) {
            source.m_81352_((Component)Component.m_237113_((String)"Only the owner can reset the lock."));
            return 0;
        }
        be.resetLockId();
        source.m_288197_(() -> Component.m_237113_((String)"\ud83d\udd01 Lock reset! Old keys will no longer work for this safe."), true);
        return 1;
    }

    private static int whoOwns(CommandSourceStack source) {
        ServerPlayer player;
        try {
            player = source.m_81375_();
        }
        catch (Exception e) {
            return 0;
        }
        HitResult hit = player.m_19907_(5.0, 0.0f, false);
        if (!(hit instanceof BlockHitResult)) {
            source.m_81352_((Component)Component.m_237113_((String)"Look at a safe within 5 blocks."));
            return 0;
        }
        BlockHitResult bhr = (BlockHitResult)hit;
        BlockPos pos = bhr.m_82425_();
        Level level = player.m_9236_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof SafeBlockEntity)) {
            source.m_81352_((Component)Component.m_237113_((String)"That isn't a Steelhold safe."));
            return 0;
        }
        SafeBlockEntity be = (SafeBlockEntity)blockEntity;
        if (be.getOwner() == null) {
            source.m_288197_(() -> Component.m_237113_((String)"This safe has no owner yet."), false);
            return 1;
        }
        String ownerName = be.getOwnerName(level);
        source.m_288197_(() -> Component.m_237113_((String)("\ud83d\udc64 Owner: " + ownerName)), false);
        return 1;
    }
}

