/*
 * Decompiled with CFR 0.152.
 */
package com.mayflower.steelhold.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class SteelholdConfig {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final Common COMMON;

    static {
        ForgeConfigSpec.Builder b = new ForgeConfigSpec.Builder();
        COMMON = new Common(b);
        COMMON_SPEC = b.build();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue dropContentsOnBreak;
        public final ForgeConfigSpec.BooleanValue explosionCanBreakSafes;
        public final ForgeConfigSpec.IntValue basicSlots;
        public final ForgeConfigSpec.IntValue reinforcedSlots;
        public final ForgeConfigSpec.IntValue steelholdSlots;
        public final ForgeConfigSpec.IntValue vaultSlots;
        public final ForgeConfigSpec.IntValue bankSlots;
        public final ForgeConfigSpec.DoubleValue basicHardness;
        public final ForgeConfigSpec.DoubleValue reinforcedHardness;
        public final ForgeConfigSpec.DoubleValue steelholdHardness;
        public final ForgeConfigSpec.DoubleValue vaultHardness;
        public final ForgeConfigSpec.DoubleValue bankHardness;
        public final ForgeConfigSpec.DoubleValue basicResistance;
        public final ForgeConfigSpec.DoubleValue reinforcedResistance;
        public final ForgeConfigSpec.DoubleValue steelholdResistance;
        public final ForgeConfigSpec.DoubleValue vaultResistance;
        public final ForgeConfigSpec.DoubleValue bankResistance;
        public final ForgeConfigSpec.IntValue basicToolLevel;
        public final ForgeConfigSpec.IntValue reinforcedToolLevel;
        public final ForgeConfigSpec.IntValue steelholdToolLevel;
        public final ForgeConfigSpec.IntValue vaultToolLevel;
        public final ForgeConfigSpec.IntValue bankToolLevel;

        Common(ForgeConfigSpec.Builder b) {
            b.push("global");
            this.dropContentsOnBreak = b.comment("If true, breaking a safe drops all stored items on the ground.").define("dropContentsOnBreak", true);
            this.explosionCanBreakSafes = b.comment("If false, explosions will not destroy safes (TNT/creepers).").define("explosionCanBreakSafes", true);
            b.pop();
            b.push("tiers");
            b.comment(new String[]{"==============================================", "IMPORTANT: Slot count settings apply ONLY to", "newly placed safes. Existing safes keep their", "original inventory size to prevent item loss.", "", "You may safely INCREASE these values.", "Decreasing them will NOT shrink old safes.", "=============================================="});
            b.comment("--- slots (must be multiples of 9) ---");
            this.basicSlots = b.defineInRange("basicSlots", 9, 9, 54);
            this.reinforcedSlots = b.defineInRange("reinforcedSlots", 18, 9, 54);
            this.steelholdSlots = b.defineInRange("steelholdSlots", 27, 9, 54);
            this.vaultSlots = b.defineInRange("vaultSlots", 36, 9, 54);
            this.bankSlots = b.defineInRange("bankSlots", 54, 9, 54);
            b.comment("--- hardness ---");
            this.basicHardness = b.defineInRange("basicHardness", 8.0, 0.1, 200.0);
            this.reinforcedHardness = b.defineInRange("reinforcedHardness", 12.0, 0.1, 200.0);
            this.steelholdHardness = b.defineInRange("steelholdHardness", 16.0, 0.1, 200.0);
            this.vaultHardness = b.defineInRange("vaultHardness", 22.0, 0.1, 200.0);
            this.bankHardness = b.defineInRange("bankHardness", 28.0, 0.1, 200.0);
            b.comment("--- resistance ---");
            this.basicResistance = b.defineInRange("basicResistance", 20.0, 0.0, 5000.0);
            this.reinforcedResistance = b.defineInRange("reinforcedResistance", 40.0, 0.0, 5000.0);
            this.steelholdResistance = b.defineInRange("steelholdResistance", 60.0, 0.0, 5000.0);
            this.vaultResistance = b.defineInRange("vaultResistance", 90.0, 0.0, 5000.0);
            this.bankResistance = b.defineInRange("bankResistance", 120.0, 0.0, 5000.0);
            b.comment("--- tool levels (0 wood/gold, 1 stone, 2 iron, 3 diamond, 4 netherite) ---");
            this.basicToolLevel = b.defineInRange("basicToolLevel", 2, 0, 4);
            this.reinforcedToolLevel = b.defineInRange("reinforcedToolLevel", 3, 0, 4);
            this.steelholdToolLevel = b.defineInRange("steelholdToolLevel", 3, 0, 4);
            this.vaultToolLevel = b.defineInRange("vaultToolLevel", 4, 0, 4);
            this.bankToolLevel = b.defineInRange("bankToolLevel", 4, 0, 4);
            b.pop();
        }
    }
}

