/*
 * Decompiled with CFR 0.152.
 */
package com.mayflower.steelhold.content;

import com.mayflower.steelhold.config.SteelholdConfig;
import com.mayflower.steelhold.content.HasSafeTier;
import com.mayflower.steelhold.content.SafeAccess;
import com.mayflower.steelhold.content.SafeBlockEntity;
import com.mayflower.steelhold.content.SafeTier;
import com.mayflower.steelhold.registry.ModSounds;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class BankMegaSafeBlock
extends FallingBlock
implements EntityBlock,
HasSafeTier {
    private final SafeTier tier;
    private static final Set<Long> FALLING_POS = new HashSet<Long>();
    private static final Set<Long> BREAK_GUARD = new HashSet<Long>();
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final IntegerProperty PX = IntegerProperty.m_61631_((String)"px", (int)0, (int)1);
    public static final IntegerProperty PY = IntegerProperty.m_61631_((String)"py", (int)0, (int)1);
    public static final IntegerProperty PZ = IntegerProperty.m_61631_((String)"pz", (int)0, (int)1);
    private static final VoxelShape FULL = Shapes.m_83144_();
    private static final VoxelShape EMPTY = Shapes.m_83040_();
    private static final boolean FRONT_ONLY_CLICK = false;

    public BankMegaSafeBlock(SafeTier tier, BlockBehaviour.Properties props) {
        super(props);
        this.tier = tier;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PX, (Comparable)Integer.valueOf(0))).m_61124_((Property)PY, (Comparable)Integer.valueOf(0))).m_61124_((Property)PZ, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public SafeTier getTier() {
        return this.tier;
    }

    private int requiredToolLevelFromConfig() {
        SteelholdConfig.Common c = SteelholdConfig.COMMON;
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case SafeTier.BASIC -> (Integer)c.basicToolLevel.get();
            case SafeTier.REINFORCED -> (Integer)c.reinforcedToolLevel.get();
            case SafeTier.STEELHOLD -> (Integer)c.steelholdToolLevel.get();
            case SafeTier.VAULT -> (Integer)c.vaultToolLevel.get();
            case SafeTier.BANK -> (Integer)c.bankToolLevel.get();
        };
    }

    private double hardnessFromConfig() {
        SteelholdConfig.Common c = SteelholdConfig.COMMON;
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case SafeTier.BASIC -> (Double)c.basicHardness.get();
            case SafeTier.REINFORCED -> (Double)c.reinforcedHardness.get();
            case SafeTier.STEELHOLD -> (Double)c.steelholdHardness.get();
            case SafeTier.VAULT -> (Double)c.vaultHardness.get();
            case SafeTier.BANK -> (Double)c.bankHardness.get();
        };
    }

    private double resistanceFromConfig() {
        SteelholdConfig.Common c = SteelholdConfig.COMMON;
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case SafeTier.BASIC -> (Double)c.basicResistance.get();
            case SafeTier.REINFORCED -> (Double)c.reinforcedResistance.get();
            case SafeTier.STEELHOLD -> (Double)c.steelholdResistance.get();
            case SafeTier.VAULT -> (Double)c.vaultResistance.get();
            case SafeTier.BANK -> (Double)c.bankResistance.get();
        };
    }

    private boolean hasRequiredPickaxe(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        ItemStack held = player.m_21205_();
        if (!held.canPerformAction(ToolActions.PICKAXE_DIG)) {
            return false;
        }
        Item item = held.m_41720_();
        if (!(item instanceof TieredItem)) {
            return false;
        }
        TieredItem tool = (TieredItem)item;
        int toolLevel = tool.m_43314_().m_6604_();
        int required = this.requiredToolLevelFromConfig();
        return toolLevel >= required;
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return this.hasRequiredPickaxe(player);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (!this.hasRequiredPickaxe(player)) {
            return 0.0f;
        }
        float h = (float)this.hardnessFromConfig();
        if (h <= 0.0f) {
            return 0.0f;
        }
        return super.m_5880_(state, player, level, pos) * (10.0f / h);
    }

    public float m_7325_() {
        if (!((Boolean)SteelholdConfig.COMMON.explosionCanBreakSafes.get()).booleanValue()) {
            return 5000.0f;
        }
        return (float)this.resistanceFromConfig();
    }

    private static Direction rightDir(Direction facing) {
        return facing.m_122428_();
    }

    private static Direction backDir(Direction facing) {
        return facing.m_122424_();
    }

    private static BlockPos partPos(BlockPos origin, Direction facing, int px, int py, int pz) {
        BlockPos p = origin;
        if (px != 0) {
            p = p.m_5484_(BankMegaSafeBlock.rightDir(facing), px);
        }
        if (pz != 0) {
            p = p.m_5484_(BankMegaSafeBlock.backDir(facing), pz);
        }
        if (py != 0) {
            p = p.m_6630_(py);
        }
        return p;
    }

    private static boolean isOrigin(BlockState state) {
        return (Integer)state.m_61143_((Property)PX) == 0 && (Integer)state.m_61143_((Property)PY) == 0 && (Integer)state.m_61143_((Property)PZ) == 0;
    }

    private static BlockPos getOriginPos(BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int px = (Integer)state.m_61143_((Property)PX);
        int py = (Integer)state.m_61143_((Property)PY);
        int pz = (Integer)state.m_61143_((Property)PZ);
        BlockPos o = pos;
        if (px != 0) {
            o = o.m_5484_(BankMegaSafeBlock.rightDir(facing), -px);
        }
        if (pz != 0) {
            o = o.m_5484_(BankMegaSafeBlock.backDir(facing), -pz);
        }
        if (py != 0) {
            o = o.m_6625_(py);
        }
        return o;
    }

    private boolean canPlaceAt(Level level, BlockPos origin, Direction facing, BlockPlaceContext ctx) {
        for (int px = 0; px <= 1; ++px) {
            for (int py = 0; py <= 1; ++py) {
                for (int pz = 0; pz <= 1; ++pz) {
                    BlockPos p = BankMegaSafeBlock.partPos(origin, facing, px, py, pz);
                    if (level.m_8055_(p).m_60629_(ctx)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private void placeAllParts(Level level, BlockPos origin, Direction facing, boolean open) {
        for (int px = 0; px <= 1; ++px) {
            for (int py = 0; py <= 1; ++py) {
                for (int pz = 0; pz <= 1; ++pz) {
                    BlockPos p = BankMegaSafeBlock.partPos(origin, facing, px, py, pz);
                    BlockState s = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open))).m_61124_((Property)PX, (Comparable)Integer.valueOf(px))).m_61124_((Property)PY, (Comparable)Integer.valueOf(py))).m_61124_((Property)PZ, (Comparable)Integer.valueOf(pz));
                    level.m_7731_(p, s, 3);
                }
            }
        }
    }

    private void setOpenAll(Level level, BlockPos origin, Direction facing, boolean open) {
        for (int px = 0; px <= 1; ++px) {
            for (int py = 0; py <= 1; ++py) {
                for (int pz = 0; pz <= 1; ++pz) {
                    BlockPos p = BankMegaSafeBlock.partPos(origin, facing, px, py, pz);
                    BlockState s = level.m_8055_(p);
                    if (s.m_60734_() != this) continue;
                    level.m_7731_(p, (BlockState)s.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
                }
            }
        }
    }

    private void removeAllParts(Level level, BlockPos origin, Direction facing) {
        for (int px = 0; px <= 1; ++px) {
            for (int py = 0; py <= 1; ++py) {
                for (int pz = 0; pz <= 1; ++pz) {
                    BlockPos p = BankMegaSafeBlock.partPos(origin, facing, px, py, pz);
                    BlockState s = level.m_8055_(p);
                    if (s.m_60734_() != this) continue;
                    level.m_7731_(p, Blocks.f_50016_.m_49966_(), 35);
                }
            }
        }
    }

    private void removeOtherParts(Level level, BlockPos origin, Direction facing) {
        for (int px = 0; px <= 1; ++px) {
            for (int py = 0; py <= 1; ++py) {
                for (int pz = 0; pz <= 1; ++pz) {
                    BlockPos p;
                    BlockState s;
                    if (px == 0 && py == 0 && pz == 0 || (s = level.m_8055_(p = BankMegaSafeBlock.partPos(origin, facing, px, py, pz))).m_60734_() != this) continue;
                    level.m_7731_(p, Blocks.f_50016_.m_49966_(), 35);
                }
            }
        }
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        Direction facing = ctx.m_8125_().m_122424_();
        BlockPos origin = ctx.m_8083_();
        if (!this.canPlaceAt(level, origin, facing, ctx)) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)facing)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)PX, (Comparable)Integer.valueOf(0))).m_61124_((Property)PY, (Comparable)Integer.valueOf(0))).m_61124_((Property)PZ, (Comparable)Integer.valueOf(0));
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (level.f_46443_) {
            return;
        }
        BlockPos origin = pos;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        this.placeAllParts(level, origin, facing, (Boolean)state.m_61143_((Property)OPEN));
        if (placer instanceof Player) {
            Player p = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(origin);
            if (blockEntity instanceof SafeBlockEntity) {
                SafeBlockEntity be = (SafeBlockEntity)blockEntity;
                if (be.getOwner() == null) {
                    be.setOwner(p.m_20148_());
                }
                be.getSafeId();
            }
        }
    }

    @Nullable
    public SafeBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return BankMegaSafeBlock.isOrigin(state) ? new SafeBlockEntity(pos, state) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos origin = BankMegaSafeBlock.getOriginPos(pos, state);
        BlockState originState = level.m_8055_(origin);
        if (originState.m_60734_() != this) {
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(origin);
        if (!(blockEntity instanceof SafeBlockEntity)) {
            return InteractionResult.CONSUME;
        }
        SafeBlockEntity be = (SafeBlockEntity)blockEntity;
        if (!SafeAccess.canOpen(level, origin, player)) {
            String ownerName = be.getOwnerName(level);
            player.m_5661_((Component)Component.m_237113_((String)("\ud83d\udd12 Locked. Owner: " + ownerName + " \u2014 you need a key.")), true);
            level.m_5594_(null, origin, (SoundEvent)ModSounds.SAFE_LOCKED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            Direction facing = (Direction)originState.m_61143_((Property)FACING);
            this.setOpenAll(level, origin, facing, true);
            level.m_5594_(null, origin, (SoundEvent)ModSounds.SAFE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)be, (BlockPos)origin);
        }
        return InteractionResult.CONSUME;
    }

    private boolean isFrontLayer(BlockState state) {
        return true;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return FULL;
    }

    public VoxelShape m_6079_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.isFrontLayer(state) ? FULL : EMPTY;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.m_6079_(state, level, pos);
    }

    public RenderShape m_7514_(BlockState state) {
        return BankMegaSafeBlock.isOrigin(state) ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        BlockPos origin = BankMegaSafeBlock.getOriginPos(pos, state);
        BlockState originState = level.m_8055_(origin);
        if (originState.m_60734_() != this) {
            return Blocks.f_50016_.m_49966_();
        }
        Direction facing = (Direction)originState.m_61143_((Property)FACING);
        for (int px = 0; px <= 1; ++px) {
            for (int py = 0; py <= 1; ++py) {
                for (int pz = 0; pz <= 1; ++pz) {
                    if (!neighborPos.equals((Object)BankMegaSafeBlock.partPos(origin, facing, px, py, pz)) || neighbor.m_60734_() == this) continue;
                    return Blocks.f_50016_.m_49966_();
                }
            }
        }
        return super.m_7417_(state, dir, neighbor, level, pos, neighborPos);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (FALLING_POS.contains(pos.m_121878_())) {
            super.m_6810_(state, level, pos, newState, movedByPiston);
            return;
        }
        if (state.m_60734_() != newState.m_60734_() && BankMegaSafeBlock.isOrigin(state)) {
            BlockEntity blockEntity;
            BlockPos master = BankMegaSafeBlock.getOriginPos(pos, state);
            Direction facing = (Direction)state.m_61143_((Property)FACING);
            if (!level.f_46443_ && ((Boolean)SteelholdConfig.COMMON.dropContentsOnBreak.get()).booleanValue() && (blockEntity = level.m_7702_(master)) instanceof SafeBlockEntity) {
                SafeBlockEntity safeBe = (SafeBlockEntity)blockEntity;
                for (int i = 0; i < safeBe.getItems().getSlots(); ++i) {
                    ItemStack stack = safeBe.getItems().getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)master.m_123341_(), (double)master.m_123342_(), (double)master.m_123343_(), (ItemStack)stack);
                    safeBe.getItems().setStackInSlot(i, ItemStack.f_41583_);
                }
            }
            this.removeOtherParts(level, master, facing);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockPos p;
        if (!BankMegaSafeBlock.isOrigin(state)) {
            return List.of();
        }
        Vec3 origin = (Vec3)builder.m_287261_(LootContextParams.f_81460_);
        if (origin != null && FALLING_POS.contains((p = BlockPos.m_274446_((Position)origin)).m_121878_())) {
            return List.of();
        }
        return super.m_49635_(state, builder);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        int pz;
        int px;
        if (!BankMegaSafeBlock.isOrigin(state)) {
            return;
        }
        if (!FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_()))) {
            return;
        }
        if (pos.m_123342_() < level.m_141937_()) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        CompoundTag beTag = null;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SafeBlockEntity) {
            SafeBlockEntity be = (SafeBlockEntity)blockEntity;
            beTag = be.m_187482_();
        }
        for (px = 0; px <= 1; ++px) {
            for (int py = 0; py <= 1; ++py) {
                for (pz = 0; pz <= 1; ++pz) {
                    FALLING_POS.add(BankMegaSafeBlock.partPos(pos, facing, px, py, pz).m_121878_());
                }
            }
        }
        for (px = 0; px <= 1; ++px) {
            for (int py = 0; py <= 1; ++py) {
                for (pz = 0; pz <= 1; ++pz) {
                    BlockPos p;
                    BlockState s;
                    if (px == 0 && py == 0 && pz == 0 || (s = level.m_8055_(p = BankMegaSafeBlock.partPos(pos, facing, px, py, pz))).m_60734_() != this) continue;
                    level.m_7731_(p, Blocks.f_50016_.m_49966_(), 35);
                }
            }
        }
        FallingBlockEntity falling = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
        if (beTag != null) {
            falling.f_31944_ = beTag;
        }
    }

    public void m_48792_(Level level, BlockPos pos, BlockState state, BlockState replacedState, FallingBlockEntity falling) {
        int pz;
        int py;
        int px;
        super.m_48792_(level, pos, state, replacedState, falling);
        if (!BankMegaSafeBlock.isOrigin(state)) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        boolean ok = true;
        for (px = 0; px <= 1 && ok; ++px) {
            for (py = 0; py <= 1 && ok; ++py) {
                for (pz = 0; pz <= 1 && ok; ++pz) {
                    BlockPos p;
                    if (px == 0 && py == 0 && pz == 0 || level.m_8055_(p = BankMegaSafeBlock.partPos(pos, facing, px, py, pz)).m_247087_()) continue;
                    ok = false;
                }
            }
        }
        if (ok) {
            this.placeAllParts(level, pos, facing, (Boolean)state.m_61143_((Property)OPEN));
        }
        for (px = 0; px <= 1; ++px) {
            for (py = 0; py <= 1; ++py) {
                for (pz = 0; pz <= 1; ++pz) {
                    FALLING_POS.remove(BankMegaSafeBlock.partPos(pos, facing, px, py, pz).m_121878_());
                }
            }
        }
    }

    public void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        BlockPos origin = BankMegaSafeBlock.getOriginPos(pos, state);
        BlockState originState = level.m_8055_(origin);
        if (originState.m_60734_() != this) {
            super.m_142387_(level, player, pos, state);
            return;
        }
        super.m_142387_(level, player, pos, originState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        Direction facing;
        if (level.f_46443_) {
            super.m_5707_(level, pos, state, player);
            return;
        }
        BlockPos master = BankMegaSafeBlock.getOriginPos(pos, state);
        long key = master.m_121878_();
        if (BREAK_GUARD.contains(key)) {
            super.m_5707_(level, pos, state, player);
            return;
        }
        BlockState masterStateNow = level.m_8055_(master);
        Direction direction = facing = masterStateNow.m_60734_() == this ? (Direction)masterStateNow.m_61143_((Property)FACING) : (Direction)state.m_61143_((Property)FACING);
        if (!BankMegaSafeBlock.isOrigin(state)) {
            BREAK_GUARD.add(key);
            try {
                level.m_46953_(master, true, (Entity)player);
                this.removeOtherParts(level, master, facing);
            }
            finally {
                BREAK_GUARD.remove(key);
            }
            return;
        }
        this.removeOtherParts(level, master, facing);
        super.m_5707_(level, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, PX, PY, PZ});
    }
}

