/*
 * Decompiled with CFR 0.152.
 */
package com.mayflower.steelhold.content;

import com.mayflower.steelhold.config.SteelholdConfig;
import com.mayflower.steelhold.content.HasSafeTier;
import com.mayflower.steelhold.content.SafeTier;
import com.mayflower.steelhold.registry.ModBlockEntities;
import com.mayflower.steelhold.ui.SafeMenu;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeBlockEntity
extends BlockEntity
implements MenuProvider {
    private final SafeTier tier;
    private ItemStackHandler items;
    private LazyOptional<ItemStackHandler> itemCap = LazyOptional.empty();
    private UUID owner;
    private UUID safeId;
    private int slotCount;

    public SafeBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.SAFE_BE.get(), pos, state);
        SafeTier t = SafeTier.BASIC;
        Block block = state.m_60734_();
        if (block instanceof HasSafeTier) {
            HasSafeTier hs = (HasSafeTier)block;
            t = hs.getTier();
        }
        this.tier = t;
        this.slotCount = SafeBlockEntity.slotsForTierFromConfig(this.tier);
        this.items = new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                SafeBlockEntity.this.m_6596_();
            }
        };
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.m_6596_();
    }

    public UUID getSafeId() {
        if (this.safeId == null) {
            this.safeId = UUID.randomUUID();
        }
        return this.safeId;
    }

    public int getRows() {
        return Math.max(1, this.slotCount / 9);
    }

    public ItemStackHandler getItems() {
        return this.items;
    }

    public void resetLockId() {
        this.safeId = UUID.randomUUID();
        this.m_6596_();
    }

    private static int slotsForTierFromConfig(SafeTier tier) {
        SteelholdConfig.Common c = SteelholdConfig.COMMON;
        int slots = switch (tier) {
            default -> throw new IncompatibleClassChangeError();
            case SafeTier.BASIC -> (Integer)c.basicSlots.get();
            case SafeTier.REINFORCED -> (Integer)c.reinforcedSlots.get();
            case SafeTier.STEELHOLD -> (Integer)c.steelholdSlots.get();
            case SafeTier.VAULT -> (Integer)c.vaultSlots.get();
            case SafeTier.BANK -> (Integer)c.bankSlots.get();
        };
        slots = Math.max(9, Math.min(54, slots));
        slots = slots / 9 * 9;
        if (slots < 9) {
            slots = 9;
        }
        return slots;
    }

    public String getOwnerName(Level level) {
        ServerLevel sl;
        MinecraftServer server;
        if (this.owner == null) {
            return "Unknown";
        }
        if (level instanceof ServerLevel && (server = (sl = (ServerLevel)level).m_7654_()) != null) {
            GameProfile profile = server.m_129927_().m_11002_(this.owner).orElse(null);
            if (profile != null && profile.getName() != null) {
                return profile.getName();
            }
            ServerPlayer online = server.m_6846_().m_11259_(this.owner);
            if (online != null) {
                return online.m_36316_().getName();
            }
        }
        return "Unknown";
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory playerInv, Player player) {
        return new SafeMenu(containerId, playerInv, this);
    }

    protected void m_183515_(CompoundTag tag) {
        tag.m_128365_("Items", (Tag)this.items.serializeNBT());
        tag.m_128405_("SlotCount", this.slotCount);
        if (this.owner != null) {
            tag.m_128362_("Owner", this.owner);
        }
        tag.m_128362_("SafeId", this.getSafeId());
        super.m_183515_(tag);
    }

    public void m_142466_(CompoundTag tag) {
        int loadedSlots;
        super.m_142466_(tag);
        int n = loadedSlots = tag.m_128441_("SlotCount") ? tag.m_128451_("SlotCount") : 0;
        if (loadedSlots <= 0) {
            loadedSlots = SafeBlockEntity.slotsForTierFromConfig(this.tier);
        }
        this.slotCount = loadedSlots;
        this.items = new ItemStackHandler(this.slotCount){

            protected void onContentsChanged(int slot) {
                SafeBlockEntity.this.m_6596_();
            }
        };
        if (tag.m_128441_("Items")) {
            this.items.deserializeNBT(tag.m_128469_("Items"));
        }
        this.owner = tag.m_128403_("Owner") ? tag.m_128342_("Owner") : null;
        this.safeId = tag.m_128403_("SafeId") ? tag.m_128342_("SafeId") : UUID.randomUUID();
    }

    public void onLoad() {
        super.onLoad();
        this.itemCap = LazyOptional.of(() -> this.items);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.itemCap.invalidate();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemCap.cast();
        }
        return super.getCapability(cap, side);
    }
}

