/*
 * Decompiled with CFR 0.152.
 */
package com.mayflower.steelhold.content;

import com.mayflower.steelhold.config.SteelholdConfig;
import com.mayflower.steelhold.content.HasSafeTier;
import com.mayflower.steelhold.content.SafeAccess;
import com.mayflower.steelhold.content.SafeBlockEntity;
import com.mayflower.steelhold.content.SafeTier;
import com.mayflower.steelhold.registry.ModSounds;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TallSafeBlock
extends FallingBlock
implements EntityBlock,
HasSafeTier {
    private final SafeTier tier;
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final Set<Long> FALLING_POS = new HashSet<Long>();
    private static final Set<Long> BREAK_REDIRECT_GUARD = new HashSet<Long>();

    public TallSafeBlock(SafeTier tier, BlockBehaviour.Properties props) {
        super(props);
        this.tier = tier;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    @Override
    public SafeTier getTier() {
        return this.tier;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos = ctx.m_8083_();
        Level level = ctx.m_43725_();
        if (pos.m_123342_() >= level.m_151558_() - 1) {
            return null;
        }
        if (!level.m_8055_(pos.m_7494_()).m_60629_(ctx)) {
            return null;
        }
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        if (level.f_46443_) {
            return;
        }
        level.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        if (placer instanceof Player) {
            Player p = (Player)placer;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof SafeBlockEntity) {
                SafeBlockEntity be = (SafeBlockEntity)blockEntity;
                if (be.getOwner() == null) {
                    be.setOwner(p.m_20148_());
                }
                be.getSafeId();
            }
        }
    }

    @Nullable
    public SafeBlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? new SafeBlockEntity(pos, state) : null;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockPos basePos;
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = basePos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
        if (!SafeAccess.canOpen(level, basePos, player)) {
            String ownerName = "Unknown";
            BlockEntity blockEntity = level.m_7702_(basePos);
            if (blockEntity instanceof SafeBlockEntity) {
                SafeBlockEntity be = (SafeBlockEntity)blockEntity;
                ownerName = be.getOwnerName(level);
            }
            player.m_5661_((Component)Component.m_237113_((String)("\ud83d\udd12 Locked. Owner: " + ownerName + " \u2014 you need a key.")), true);
            level.m_5594_(null, basePos, (SoundEvent)ModSounds.SAFE_LOCKED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.CONSUME;
        }
        BlockEntity blockEntity = level.m_7702_(basePos);
        if (blockEntity instanceof MenuProvider) {
            MenuProvider provider = (MenuProvider)blockEntity;
            if (player instanceof ServerPlayer) {
                BlockPos up;
                BlockState upper;
                ServerPlayer sp = (ServerPlayer)player;
                BlockState lower = level.m_8055_(basePos);
                if (lower.m_60734_() == this) {
                    level.m_7731_(basePos, (BlockState)lower.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
                }
                if ((upper = level.m_8055_(up = basePos.m_7494_())).m_60734_() == this) {
                    level.m_7731_(up, (BlockState)upper.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
                }
                level.m_5594_(null, basePos, (SoundEvent)ModSounds.SAFE_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)provider, (BlockPos)basePos);
            }
        }
        return InteractionResult.CONSUME;
    }

    private int requiredToolLevelFromConfig() {
        SteelholdConfig.Common c = SteelholdConfig.COMMON;
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case SafeTier.BASIC -> (Integer)c.basicToolLevel.get();
            case SafeTier.REINFORCED -> (Integer)c.reinforcedToolLevel.get();
            case SafeTier.STEELHOLD -> (Integer)c.steelholdToolLevel.get();
            case SafeTier.VAULT -> (Integer)c.vaultToolLevel.get();
            case SafeTier.BANK -> (Integer)c.bankToolLevel.get();
        };
    }

    private boolean hasRequiredPickaxe(Player player) {
        if (player.m_7500_()) {
            return true;
        }
        ItemStack held = player.m_21205_();
        if (!held.canPerformAction(ToolActions.PICKAXE_DIG)) {
            return false;
        }
        Item item = held.m_41720_();
        if (!(item instanceof TieredItem)) {
            return false;
        }
        TieredItem tool = (TieredItem)item;
        return tool.m_43314_().m_6604_() >= this.requiredToolLevelFromConfig();
    }

    public boolean canHarvestBlock(BlockState state, BlockGetter level, BlockPos pos, Player player) {
        return this.hasRequiredPickaxe(player);
    }

    private double hardnessFromConfig() {
        SteelholdConfig.Common c = SteelholdConfig.COMMON;
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case SafeTier.BASIC -> (Double)c.basicHardness.get();
            case SafeTier.REINFORCED -> (Double)c.reinforcedHardness.get();
            case SafeTier.STEELHOLD -> (Double)c.steelholdHardness.get();
            case SafeTier.VAULT -> (Double)c.vaultHardness.get();
            case SafeTier.BANK -> (Double)c.bankHardness.get();
        };
    }

    private double resistanceFromConfig() {
        SteelholdConfig.Common c = SteelholdConfig.COMMON;
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case SafeTier.BASIC -> (Double)c.basicResistance.get();
            case SafeTier.REINFORCED -> (Double)c.reinforcedResistance.get();
            case SafeTier.STEELHOLD -> (Double)c.steelholdResistance.get();
            case SafeTier.VAULT -> (Double)c.vaultResistance.get();
            case SafeTier.BANK -> (Double)c.bankResistance.get();
        };
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        if (!this.hasRequiredPickaxe(player)) {
            return 0.0f;
        }
        float cfgHardness = (float)this.hardnessFromConfig();
        if (cfgHardness <= 0.0f) {
            return 0.0f;
        }
        float baselineHardness = 5.0f;
        return super.m_5880_(state, player, level, pos) * (baselineHardness / cfgHardness);
    }

    public float m_7325_() {
        if (!((Boolean)SteelholdConfig.COMMON.explosionCanBreakSafes.get()).booleanValue()) {
            return 5000.0f;
        }
        return (float)this.resistanceFromConfig();
    }

    public BlockState m_7417_(BlockState state, Direction dir, BlockState neighbor, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
        if (dir == Direction.UP && half == DoubleBlockHalf.LOWER) {
            return neighbor.m_60734_() == this && neighbor.m_61143_(HALF) == DoubleBlockHalf.UPPER ? state : Blocks.f_50016_.m_49966_();
        }
        if (dir == Direction.DOWN && half == DoubleBlockHalf.UPPER) {
            return neighbor.m_60734_() == this && neighbor.m_61143_(HALF) == DoubleBlockHalf.LOWER ? state : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, dir, neighbor, level, pos, neighborPos);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (FALLING_POS.contains(pos.m_121878_())) {
            super.m_6810_(state, level, pos, newState, movedByPiston);
            return;
        }
        if (state.m_60734_() != newState.m_60734_()) {
            BlockPos otherPos;
            BlockState other;
            BlockEntity blockEntity;
            BlockPos basePos;
            DoubleBlockHalf half = (DoubleBlockHalf)state.m_61143_(HALF);
            BlockPos blockPos = basePos = half == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
            if (!level.f_46443_ && half == DoubleBlockHalf.LOWER && ((Boolean)SteelholdConfig.COMMON.dropContentsOnBreak.get()).booleanValue() && (blockEntity = level.m_7702_(basePos)) instanceof SafeBlockEntity) {
                SafeBlockEntity safeBe = (SafeBlockEntity)blockEntity;
                for (int i = 0; i < safeBe.getItems().getSlots(); ++i) {
                    ItemStack stack = safeBe.getItems().getStackInSlot(i);
                    if (stack.m_41619_()) continue;
                    Containers.m_18992_((Level)level, (double)basePos.m_123341_(), (double)basePos.m_123342_(), (double)basePos.m_123343_(), (ItemStack)stack);
                    safeBe.getItems().setStackInSlot(i, ItemStack.f_41583_);
                }
            }
            if ((other = level.m_8055_(otherPos = half == DoubleBlockHalf.LOWER ? pos.m_7494_() : pos.m_7495_())).m_60734_() == this && other.m_61143_(HALF) != half) {
                FALLING_POS.add(otherPos.m_121878_());
                level.m_7731_(otherPos, Blocks.f_50016_.m_49966_(), 35);
                FALLING_POS.remove(otherPos.m_121878_());
            }
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        if (level.f_46443_) {
            super.m_5707_(level, pos, state, player);
            return;
        }
        BlockPos basePos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
        long guardKey = basePos.m_121878_();
        if (BREAK_REDIRECT_GUARD.contains(guardKey)) {
            super.m_5707_(level, pos, state, player);
            return;
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            BREAK_REDIRECT_GUARD.add(guardKey);
            try {
                FALLING_POS.add(pos.m_121878_());
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 35);
                FALLING_POS.remove(pos.m_121878_());
                level.m_46953_(basePos, true, (Entity)player);
            }
            finally {
                BREAK_REDIRECT_GUARD.remove(guardKey);
            }
            return;
        }
        BlockPos up = basePos.m_7494_();
        BlockState upper = level.m_8055_(up);
        if (upper.m_60734_() == this && upper.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            FALLING_POS.add(up.m_121878_());
            level.m_7731_(up, Blocks.f_50016_.m_49966_(), 35);
            FALLING_POS.remove(up.m_121878_());
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_142387_(Level level, Player player, BlockPos pos, BlockState state) {
        BlockPos basePos = state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
        BlockState baseState = level.m_8055_(basePos);
        if (baseState.m_60734_() != this) {
            super.m_142387_(level, player, pos, state);
            return;
        }
        int id = Block.m_49956_((BlockState)baseState);
        level.m_5898_(player, 2001, pos, id);
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (state.m_61143_(HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        if (!FallingBlock.m_53241_((BlockState)level.m_8055_(pos.m_7495_()))) {
            return;
        }
        if (pos.m_123342_() < level.m_141937_()) {
            return;
        }
        CompoundTag beTag = null;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SafeBlockEntity) {
            SafeBlockEntity be = (SafeBlockEntity)blockEntity;
            beTag = be.m_187482_();
        }
        FALLING_POS.add(pos.m_121878_());
        FALLING_POS.add(pos.m_7494_().m_121878_());
        BlockPos up = pos.m_7494_();
        BlockState upState = level.m_8055_(up);
        if (upState.m_60734_() == this && upState.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            level.m_7731_(up, Blocks.f_50016_.m_49966_(), 35);
        }
        FallingBlockEntity falling = FallingBlockEntity.m_201971_((Level)level, (BlockPos)pos, (BlockState)state);
        if (beTag != null) {
            falling.f_31944_ = beTag;
        }
        FALLING_POS.remove(pos.m_121878_());
        FALLING_POS.remove(pos.m_7494_().m_121878_());
    }

    public void m_48792_(Level level, BlockPos pos, BlockState state, BlockState replacedState, FallingBlockEntity falling) {
        BlockState lower;
        super.m_48792_(level, pos, state, replacedState, falling);
        if (state.m_61143_(HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        BlockPos up = pos.m_7494_();
        BlockState above = level.m_8055_(up);
        if (above.m_247087_() && (lower = level.m_8055_(pos)).m_60734_() == this) {
            BlockState upper = (BlockState)lower.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER);
            level.m_7731_(up, upper, 3);
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.UPPER) {
            return List.of();
        }
        return super.m_49635_(state, builder);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, OPEN, HALF});
    }
}

