/*
 * Decompiled with CFR 0.152.
 */
package com.mayflower.steelhold.registry;

import com.mayflower.steelhold.content.BankMegaSafeBlock;
import com.mayflower.steelhold.content.SafeBlock;
import com.mayflower.steelhold.content.SafeKeyItem;
import com.mayflower.steelhold.content.SafeTier;
import com.mayflower.steelhold.content.TallSafeBlock;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"steelhold");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"steelhold");
    public static final RegistryObject<Block> BASIC_SAFE = ModBlocks.registerSafe("basic_safe", SafeTier.BASIC);
    public static final RegistryObject<Block> REINFORCED_SAFE = ModBlocks.registerSafe("reinforced_safe", SafeTier.REINFORCED);
    public static final RegistryObject<Block> STEELHOLD_SAFE = ModBlocks.registerSafe("steelhold_safe", SafeTier.STEELHOLD);
    public static final RegistryObject<Block> VAULT_SAFE = ModBlocks.registerTallSafe("vault_safe", SafeTier.VAULT);
    public static final RegistryObject<Block> BANK_SAFE = ModBlocks.registerBankSafe("bank_safe", SafeTier.BANK);
    public static final RegistryObject<Item> SAFE_KEY = ITEMS.register("safe_key", () -> new SafeKeyItem(new Item.Properties().m_41487_(1)));

    private static RegistryObject<Block> registerSafe(String name, SafeTier tier) {
        return ModBlocks.registerBlock(name, () -> new SafeBlock(tier, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56749_).m_60913_(tier.hardness, tier.resistance).m_60999_()));
    }

    private static RegistryObject<Block> registerTallSafe(String name, SafeTier tier) {
        return ModBlocks.registerBlock(name, () -> new TallSafeBlock(tier, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56749_).m_60913_(tier.hardness, tier.resistance).m_60999_()));
    }

    private static RegistryObject<Block> registerBankSafe(String name, SafeTier tier) {
        return ModBlocks.registerBlock(name, () -> new BankMegaSafeBlock(tier, BlockBehaviour.Properties.m_284310_().m_284180_(MapColor.f_283906_).m_60918_(SoundType.f_56749_).m_60913_(tier.hardness, tier.resistance).m_60999_()));
    }

    private static <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> block) {
        RegistryObject regBlock = BLOCKS.register(name, block);
        ITEMS.register(name, () -> new BlockItem((Block)regBlock.get(), new Item.Properties()));
        return regBlock;
    }

    public static void register(IEventBus bus) {
        BLOCKS.register(bus);
        ITEMS.register(bus);
    }
}

