/*
 * Decompiled with CFR 0.152.
 */
package com.mayflower.steelhold.ui;

import com.mayflower.steelhold.content.SafeBlock;
import com.mayflower.steelhold.content.SafeBlockEntity;
import com.mayflower.steelhold.registry.ModMenus;
import com.mayflower.steelhold.registry.ModSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class SafeMenu
extends AbstractContainerMenu {
    private final SafeBlockEntity safe;
    private final int rows;
    private final BlockPos blockPos;

    public SafeMenu(int id, Inventory playerInv, SafeBlockEntity safe) {
        super((MenuType)ModMenus.SAFE_MENU.get(), id);
        int col;
        this.safe = safe;
        this.rows = safe.getRows();
        this.blockPos = safe.m_58899_();
        int safeSlotCount = this.rows * 9;
        int yOffset = 18;
        for (int row = 0; row < this.rows; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                int index = col2 + row * 9;
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)safe.getItems(), index, 8 + col2 * 18, yOffset + row * 18));
            }
        }
        int playerInvY = 31 + this.rows * 18;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInv, col + row * 9 + 9, 8 + col * 18, playerInvY + row * 18));
            }
        }
        int hotbarY = playerInvY + 58;
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInv, col, 8 + col * 18, hotbarY));
        }
    }

    public static SafeMenu fromNetwork(int id, Inventory playerInv, FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        Level level = playerInv.f_35978_.m_9236_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof SafeBlockEntity) {
            SafeBlockEntity be = (SafeBlockEntity)blockEntity;
            return new SafeMenu(id, playerInv, be);
        }
        throw new IllegalStateException("Steelhold: Missing SafeBlockEntity at " + String.valueOf(pos));
    }

    public boolean m_6875_(Player player) {
        return this.safe.m_58904_() != null && this.safe.m_58904_().m_7702_(this.safe.m_58899_()) == this.safe && player.m_20275_((double)this.safe.m_58899_().m_123341_() + 0.5, (double)this.safe.m_58899_().m_123342_() + 0.5, (double)this.safe.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public int getRows() {
        return this.rows;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack empty = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (!slot.m_6657_()) {
            return empty;
        }
        ItemStack stack = slot.m_7993_();
        ItemStack copy = stack.m_41777_();
        int safeSlots = this.rows * 9;
        if (index < safeSlots ? !this.m_38903_(stack, safeSlots, this.f_38839_.size(), true) : !this.m_38903_(stack, 0, safeSlots, false)) {
            return empty;
        }
        if (stack.m_41619_()) {
            slot.m_5852_(empty);
        } else {
            slot.m_6654_();
        }
        return copy;
    }

    public void m_6877_(Player player) {
        Level level;
        BlockState state;
        super.m_6877_(player);
        if (!player.m_9236_().f_46443_ && (state = (level = player.m_9236_()).m_8055_(this.blockPos)).m_61138_((Property)SafeBlock.OPEN)) {
            level.m_7731_(this.blockPos, (BlockState)state.m_61124_((Property)SafeBlock.OPEN, (Comparable)Boolean.valueOf(false)), 3);
            level.m_5594_(null, this.blockPos, (SoundEvent)ModSounds.SAFE_CLOSE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }
}

