/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2;

import com.google.common.collect.Lists;
import java.util.List;
import net.neoforged.fml.ModList;
import org.betterx.bclib.integration.ModIntegration;
import org.betterx.wover.core.api.ModCore;

public class ModIntegrationAPI {
    private static final List<ModIntegration> INTEGRATIONS = Lists.newArrayList();
    private static final boolean HAS_CANVAS = ModList.get().isLoaded("canvas");

    public static ModIntegration register(ModIntegration integration) {
        INTEGRATIONS.add(integration);
        return integration;
    }

    public static List<ModIntegration> getIntegrations() {
        return INTEGRATIONS;
    }

    public static void registerAll() {
        INTEGRATIONS.forEach(integration -> {
            if (integration.modIsInstalled()) {
                integration.init();
            }
        });
        if (ModCore.isDatagen()) {
            INTEGRATIONS.forEach(integration -> integration.initDatagen());
        }
    }

    public static boolean hasCanvas() {
        return HAS_CANVAS;
    }
}

