/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.dataexchange;

import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.dataexchange.BCLibNetwork;
import org.betterx.bclib.api.v2.dataexchange.BaseDataHandler;
import org.betterx.bclib.api.v2.dataexchange.PacketSender;

public abstract class DataHandler<T extends CustomPacketPayload>
extends BaseDataHandler<T> {
    protected DataHandler(ResourceLocation identifier, boolean originatesOnServer) {
        super(identifier, originatesOnServer);
    }

    protected boolean prepareData(boolean isClient) {
        return true;
    }

    protected abstract T serializeData(boolean var1);

    protected abstract void deserializeIncomingData(T var1, PacketSender var2, boolean var3);

    protected abstract void runOnGameThread(Minecraft var1, MinecraftServer var2, boolean var3);

    @Override
    @OnlyIn(value=Dist.CLIENT)
    void receiveFromServer(Minecraft client, ClientPacketListener handler, T payload, PacketSender responseSender) {
        this.deserializeIncomingData(payload, responseSender, true);
        Runnable runner = () -> this.runOnGameThread(client, null, true);
        if (this.isBlocking()) {
            client.executeBlocking(runner);
        } else {
            client.execute(runner);
        }
    }

    @Override
    void receiveFromClient(MinecraftServer server, ServerPlayer player, ServerGamePacketListenerImpl handler, T payload, PacketSender responseSender) {
        super.receiveFromClient(server, player, handler, payload, responseSender);
        this.deserializeIncomingData(payload, responseSender, false);
        Runnable runner = () -> this.runOnGameThread(null, server, false);
        if (this.isBlocking()) {
            server.executeBlocking(runner);
        } else {
            server.execute(runner);
        }
    }

    @Override
    void sendToClient(MinecraftServer server) {
        if (this.prepareData(false)) {
            T obj = this.serializeData(false);
            DataHandler._sendToClient(this.getIdentifier(), server, server.getPlayerList().getPlayers(), obj);
        }
    }

    @Override
    void sendToClient(MinecraftServer server, ServerPlayer player) {
        if (this.prepareData(false)) {
            T obj = this.serializeData(false);
            DataHandler._sendToClient(this.getIdentifier(), server, List.of(player), obj);
        }
    }

    public static <T extends CustomPacketPayload> void _sendToClient(ResourceLocation identifier, MinecraftServer server, Collection<ServerPlayer> players, T payload) {
        if (payload == null) {
            return;
        }
        for (ServerPlayer player : players) {
            BCLibNetwork.sendToPlayer(player, payload);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    void sendToServer(Minecraft client) {
        if (this.prepareData(true)) {
            T obj = this.serializeData(true);
            BCLibNetwork.sendToServer(obj);
        }
    }

    public static abstract class FromServer<T extends CustomPacketPayload>
    extends BaseDataHandler<T> {
        protected FromServer(ResourceLocation identifier) {
            super(identifier, true);
        }

        protected boolean prepareDataOnServer() {
            return true;
        }

        protected abstract T serializeDataOnServer();

        @OnlyIn(value=Dist.CLIENT)
        protected abstract void deserializeIncomingDataOnClient(T var1, PacketSender var2);

        @OnlyIn(value=Dist.CLIENT)
        protected abstract void runOnClientGameThread(Minecraft var1);

        @Override
        void receiveFromServer(Minecraft client, ClientPacketListener handler, T payload, PacketSender responseSender) {
            this.deserializeIncomingDataOnClient(payload, responseSender);
            Runnable runner = () -> this.runOnClientGameThread(client);
            if (this.isBlocking()) {
                client.executeBlocking(runner);
            } else {
                client.execute(runner);
            }
        }

        @Override
        void receiveFromClient(MinecraftServer server, ServerPlayer player, ServerGamePacketListenerImpl handler, T payload, PacketSender responseSender) {
            super.receiveFromClient(server, player, handler, payload, responseSender);
            BCLib.LOGGER.error("[Internal Error] The message '" + String.valueOf(this.getIdentifier()) + "' must originate from the server!");
        }

        public void receiveFromMemory(T payload) {
            this.receiveFromServer(Minecraft.getInstance(), null, payload, null);
        }

        @Override
        final void sendToClient(MinecraftServer server) {
            if (this.prepareDataOnServer()) {
                T obj = this.serializeDataOnServer();
                DataHandler._sendToClient(this.getIdentifier(), server, server.getPlayerList().getPlayers(), obj);
            }
        }

        @Override
        final void sendToClient(MinecraftServer server, ServerPlayer player) {
            if (this.prepareDataOnServer()) {
                T obj = this.serializeDataOnServer();
                DataHandler._sendToClient(this.getIdentifier(), server, List.of(player), obj);
            }
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        final void sendToServer(Minecraft client) {
            BCLib.LOGGER.error("[Internal Error] The message '" + String.valueOf(this.getIdentifier()) + "' must originate from the server!");
        }

        public static abstract class WithoutPayload<T extends CustomPacketPayload>
        extends FromServer<T> {
            protected WithoutPayload(ResourceLocation identifier) {
                super(identifier);
            }

            @Override
            protected boolean prepareDataOnServer() {
                return true;
            }

            @Override
            protected T serializeDataOnServer() {
                return null;
            }

            @Override
            protected void deserializeIncomingDataOnClient(T payload, PacketSender responseSender) {
            }
        }
    }

    public static abstract class FromClient<T extends CustomPacketPayload>
    extends BaseDataHandler<T> {
        protected FromClient(ResourceLocation identifier) {
            super(identifier, false);
        }

        @OnlyIn(value=Dist.CLIENT)
        protected boolean prepareDataOnClient() {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        protected abstract T serializeDataOnClient();

        protected abstract void deserializeIncomingDataOnServer(T var1, Player var2, PacketSender var3);

        protected abstract void runOnServerGameThread(MinecraftServer var1, Player var2);

        @Override
        void receiveFromServer(Minecraft client, ClientPacketListener handler, CustomPacketPayload payload, PacketSender responseSender) {
            BCLib.LOGGER.error("[Internal Error] The message '" + String.valueOf(this.getIdentifier()) + "' must originate from the client!");
        }

        @Override
        void receiveFromClient(MinecraftServer server, ServerPlayer player, ServerGamePacketListenerImpl handler, T payload, PacketSender responseSender) {
            super.receiveFromClient(server, player, handler, payload, responseSender);
            this.deserializeIncomingDataOnServer(payload, (Player)player, responseSender);
            Runnable runner = () -> this.runOnServerGameThread(server, (Player)player);
            if (this.isBlocking()) {
                server.executeBlocking(runner);
            } else {
                server.execute(runner);
            }
        }

        @Override
        void sendToClient(MinecraftServer server) {
            BCLib.LOGGER.error("[Internal Error] The message '" + String.valueOf(this.getIdentifier()) + "' must originate from the client!");
        }

        @Override
        void sendToClient(MinecraftServer server, ServerPlayer player) {
            BCLib.LOGGER.error("[Internal Error] The message '" + String.valueOf(this.getIdentifier()) + "' must originate from the client!");
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        void sendToServer(Minecraft client) {
            T obj;
            if (this.prepareDataOnClient() && (obj = this.serializeDataOnClient()) != null) {
                BCLibNetwork.sendToServer(obj);
            }
        }

        public static abstract class WithoutPayload<T extends CustomPacketPayload>
        extends FromClient<T> {
            protected WithoutPayload(ResourceLocation identifier) {
                super(identifier);
            }

            @Override
            protected boolean prepareDataOnClient() {
                return true;
            }

            @Override
            protected T serializeDataOnClient() {
                return null;
            }

            @Override
            protected void deserializeIncomingDataOnServer(T payload, Player player, PacketSender responseSender) {
            }
        }
    }

    public static abstract class WithoutPayload<T extends CustomPacketPayload>
    extends DataHandler<T> {
        protected WithoutPayload(ResourceLocation identifier, boolean originatesOnServer) {
            super(identifier, originatesOnServer);
        }

        @Override
        protected boolean prepareData(boolean isClient) {
            return true;
        }

        @Override
        protected T serializeData(boolean isClient) {
            return null;
        }

        @Override
        protected void deserializeIncomingData(T payload, PacketSender responseSender, boolean isClient) {
        }
    }
}

