/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blockentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.betterx.bclib.registry.BaseBlockEntities;

public class BaseBarrelBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> inventory;
    private ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void onOpen(Level level, BlockPos blockPos, BlockState blockState) {
            BaseBarrelBlockEntity.this.playSound(blockState, SoundEvents.BARREL_OPEN);
            BaseBarrelBlockEntity.this.updateBlockState(blockState, true);
        }

        protected void onClose(Level level, BlockPos blockPos, BlockState blockState) {
            BaseBarrelBlockEntity.this.playSound(blockState, SoundEvents.BARREL_CLOSE);
            BaseBarrelBlockEntity.this.updateBlockState(blockState, false);
        }

        protected void openerCountChanged(Level level, BlockPos blockPos, BlockState blockState, int i, int j) {
        }

        protected boolean isOwnContainer(Player player) {
            if (player.containerMenu instanceof ChestMenu) {
                Container container = ((ChestMenu)player.containerMenu).getContainer();
                return container == BaseBarrelBlockEntity.this;
            }
            return false;
        }
    };

    private BaseBarrelBlockEntity(BlockEntityType<?> type, BlockPos blockPos, BlockState blockState) {
        super(type, blockPos, blockState);
        this.inventory = NonNullList.withSize((int)27, (Object)ItemStack.EMPTY);
    }

    public BaseBarrelBlockEntity(BlockPos blockPos, BlockState blockState) {
        this(BaseBlockEntities.BARREL, blockPos, blockState);
    }

    public void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        }
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.inventory = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.inventory, (HolderLookup.Provider)provider);
        }
    }

    public int getContainerSize() {
        return 27;
    }

    protected NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    protected void setItems(NonNullList<ItemStack> list) {
        this.inventory = list;
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"container.barrel");
    }

    protected AbstractContainerMenu createMenu(int syncId, Inventory playerInventory) {
        return ChestMenu.threeRows((int)syncId, (Inventory)playerInventory, (Container)this);
    }

    public void startOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.incrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    private void scheduleUpdate() {
        this.level.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 5);
    }

    public void tick() {
    }

    public void stopOpen(Player player) {
        if (!this.remove && !player.isSpectator()) {
            this.openersCounter.decrementOpeners(player, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void recheckOpen() {
        if (!this.remove) {
            this.openersCounter.recheckOpeners(this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    private void updateBlockState(BlockState state, boolean open) {
        if (this.level != null) {
            this.level.setBlock(this.getBlockPos(), (BlockState)state.setValue((Property)BarrelBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private void playSound(BlockState blockState, SoundEvent soundEvent) {
        if (this.level != null) {
            Vec3i facingDir = ((Direction)blockState.getValue((Property)BarrelBlock.FACING)).getNormal();
            double x = (double)this.worldPosition.getX() + 0.5 + (double)facingDir.getX() / 2.0;
            double y = (double)this.worldPosition.getY() + 0.5 + (double)facingDir.getY() / 2.0;
            double z = (double)this.worldPosition.getZ() + 0.5 + (double)facingDir.getZ() / 2.0;
            this.level.playSound(null, x, y, z, soundEvent, SoundSource.BLOCKS, 0.5f, this.level.random.nextFloat() * 0.1f + 0.9f);
        }
    }
}

