/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.api.v3.datagen.DropSelfLootProvider;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public abstract class BasePressurePlateBlock
extends PressurePlateBlock
implements BlockModelProvider,
BlockTagProvider,
DropSelfLootProvider<BasePressurePlateBlock> {
    private final Block parent;

    protected BasePressurePlateBlock(Block source, BlockSetType type) {
        super(type, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).noCollission().noOcclusion().strength(0.5f));
        this.parent = source;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        generator.createPressurePlate(this.parent, (Block)this);
    }

    public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
        context.add(BlockTags.PRESSURE_PLATES, (Object[])new Block[]{this});
    }

    public static BasePressurePlateBlock from(Block source, BlockSetType type) {
        return BehaviourHelper.from(source, type, Wood::new, Stone::new, Metal::new);
    }

    public static class Metal
    extends BasePressurePlateBlock
    implements BehaviourMetal {
        public Metal(Block source, BlockSetType type) {
            super(source, type);
        }
    }

    public static class Stone
    extends BasePressurePlateBlock
    implements BehaviourStone {
        public Stone(Block source, BlockSetType type) {
            super(source, type);
        }
    }

    public static class Wood
    extends BasePressurePlateBlock
    implements BehaviourWood,
    ItemTagProvider {
        public Wood(Block source, BlockSetType type) {
            super(source, type);
        }

        @Override
        public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
            context.add((Object)this, new TagKey[]{BlockTags.PRESSURE_PLATES, BlockTags.WOODEN_PRESSURE_PLATES});
        }

        public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
            context.add((ItemLike)this, new TagKey[]{ItemTags.WOODEN_PRESSURE_PLATES});
        }
    }
}

