/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.blocks;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.blocks.BaseRotatedPillarBlock;
import org.betterx.bclib.interfaces.tools.AxeCanStrip;
import org.betterx.wover.block.api.BlockTagProvider;
import org.betterx.wover.item.api.ItemTagProvider;
import org.betterx.wover.tag.api.event.context.ItemTagBootstrapContext;
import org.betterx.wover.tag.api.event.context.TagBootstrapContext;

public abstract class BaseStripableLogBlock
extends BaseRotatedPillarBlock
implements AxeCanStrip {
    private final Block stripped;

    protected BaseStripableLogBlock(Block stripped, BlockBehaviour.Properties settings) {
        super(settings);
        this.stripped = stripped;
    }

    @Override
    public BlockState strippedState(BlockState state) {
        return this.stripped.defaultBlockState();
    }

    public static class Wood
    extends BaseStripableLogBlock
    implements BehaviourWood,
    BlockTagProvider,
    ItemTagProvider {
        private final boolean flammable;

        public Wood(MapColor color, Block stripped, boolean flammable) {
            super(stripped, (flammable ? BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)stripped).ignitedByLava() : BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)stripped)).mapColor(color));
            this.flammable = flammable;
        }

        public void registerBlockTags(ResourceLocation location, TagBootstrapContext<Block> context) {
            context.add(BlockTags.LOGS, (Object[])new Block[]{this});
            if (this.flammable) {
                context.add(BlockTags.LOGS_THAT_BURN, (Object[])new Block[]{this});
            }
        }

        public void registerItemTags(ResourceLocation location, ItemTagBootstrapContext context) {
            context.add(ItemTags.LOGS, new ItemLike[]{this});
            if (this.flammable) {
                context.add(ItemTags.LOGS_THAT_BURN, new ItemLike[]{this});
            }
        }
    }
}

