/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.imageio.ImageIO;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.QuartPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec3;
import org.betterx.bclib.BCLib;
import org.betterx.wover.state.api.WorldState;

public class DumpMap {
    public static LiteralArgumentBuilder<CommandSourceStack> register(LiteralArgumentBuilder<CommandSourceStack> bnContext) {
        return (LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"dump_maps").requires(source -> source.hasPermission(4))).then(Commands.literal((String)"png").executes(DumpMap::dumpImageMaps))).then(Commands.literal((String)"json").executes(DumpMap::dumpJsonMaps)));
    }

    static int dumpJsonMaps(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel serverLevel = source.getLevel();
        Vec3 pos = source.getPosition();
        Path basePath = WorldState.storageAccess().getLevelPath(LevelResource.ROOT).resolve(BCLib.C.namespace).resolve("export").resolve(serverLevel.dimension().location().getPath()).normalize();
        RandomState randomState = serverLevel.getChunkSource().randomState();
        Climate.Sampler sampler = randomState.sampler();
        int x = QuartPos.fromBlock((int)((int)pos.x));
        int z = QuartPos.fromBlock((int)((int)pos.z));
        int minHeight = QuartPos.fromBlock((int)serverLevel.getMinBuildHeight());
        int maxHeight = QuartPos.fromBlock((int)serverLevel.getMaxBuildHeight());
        int maxOffset = 128;
        MutableComponent result = Component.literal((String)("Wrote maps to " + basePath.toString() + ":\n")).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE));
        JsonObject root = new JsonObject();
        JsonObject header = new JsonObject();
        JsonObject center = new JsonObject();
        center.addProperty("x", (Number)((int)pos.x));
        center.addProperty("y", (Number)((int)pos.y));
        center.addProperty("z", (Number)((int)pos.z));
        JsonObject start = new JsonObject();
        start.addProperty("x", (Number)(x - maxOffset));
        start.addProperty("y", (Number)minHeight);
        start.addProperty("z", (Number)(z - maxOffset));
        JsonObject dimensions = new JsonObject();
        dimensions.addProperty("x", (Number)(2 * maxOffset + 1));
        dimensions.addProperty("y", (Number)(maxHeight - minHeight));
        dimensions.addProperty("z", (Number)(2 * maxOffset + 1));
        header.add("center", (JsonElement)center);
        header.add("start", (JsonElement)start);
        header.add("size", (JsonElement)dimensions);
        header.addProperty("dimension", serverLevel.dimension().location().toString());
        root.add("info", (JsonElement)header);
        long minTemperature = Long.MAX_VALUE;
        long minHumidity = Long.MAX_VALUE;
        long minContinentalness = Long.MAX_VALUE;
        long minErosion = Long.MAX_VALUE;
        long minDepth = Long.MAX_VALUE;
        long minWeirdness = Long.MAX_VALUE;
        long maxTemperature = Long.MIN_VALUE;
        long maxHumidity = Long.MIN_VALUE;
        long maxContinentalness = Long.MIN_VALUE;
        long maxErosion = Long.MIN_VALUE;
        long maxDepth = Long.MIN_VALUE;
        long maxWeirdness = Long.MIN_VALUE;
        JsonArray samplesX = new JsonArray();
        for (int ox = -maxOffset; ox <= maxOffset; ++ox) {
            JsonArray samplesZ = new JsonArray();
            for (int oz = -maxOffset; oz <= maxOffset; ++oz) {
                JsonArray samplesY = new JsonArray();
                for (int y = minHeight; y <= maxHeight; ++y) {
                    JsonArray samples = new JsonArray();
                    Climate.TargetPoint t = sampler.sample(x + ox, y, z + oz);
                    samples.add((Number)t.temperature());
                    samples.add((Number)t.humidity());
                    samples.add((Number)t.continentalness());
                    samples.add((Number)t.erosion());
                    samples.add((Number)t.depth());
                    samples.add((Number)t.weirdness());
                    samplesY.add((JsonElement)samples);
                    if (t.temperature() < minTemperature) {
                        minTemperature = t.temperature();
                    }
                    if (t.humidity() < minHumidity) {
                        minHumidity = t.humidity();
                    }
                    if (t.continentalness() < minContinentalness) {
                        minContinentalness = t.continentalness();
                    }
                    if (t.erosion() < minErosion) {
                        minErosion = t.erosion();
                    }
                    if (t.depth() < minDepth) {
                        minDepth = t.depth();
                    }
                    if (t.weirdness() < minWeirdness) {
                        minWeirdness = t.weirdness();
                    }
                    if (t.temperature() > maxTemperature) {
                        maxTemperature = t.temperature();
                    }
                    if (t.humidity() > maxHumidity) {
                        maxHumidity = t.humidity();
                    }
                    if (t.continentalness() > maxContinentalness) {
                        maxContinentalness = t.continentalness();
                    }
                    if (t.erosion() > maxErosion) {
                        maxErosion = t.erosion();
                    }
                    if (t.depth() > maxDepth) {
                        maxDepth = t.depth();
                    }
                    if (t.weirdness() <= maxWeirdness) continue;
                    maxWeirdness = t.weirdness();
                }
                samplesZ.add((JsonElement)samplesY);
            }
            samplesX.add((JsonElement)samplesZ);
        }
        JsonObject extrema = new JsonObject();
        DumpMap.setExtrema("temperature", minTemperature, maxTemperature, extrema);
        DumpMap.setExtrema("humidity", minHumidity, maxHumidity, extrema);
        DumpMap.setExtrema("continentalness", minContinentalness, maxContinentalness, extrema);
        DumpMap.setExtrema("erosion", minErosion, maxErosion, extrema);
        DumpMap.setExtrema("depth", minDepth, maxDepth, extrema);
        DumpMap.setExtrema("weirdness", minWeirdness, maxWeirdness, extrema);
        header.add("extrema", (JsonElement)extrema);
        root.add("samples", (JsonElement)samplesX);
        File fJson = new File(basePath.toString() + "/samples.json");
        try {
            Gson gson = new Gson();
            String s = gson.toJson((JsonElement)root);
            Files.writeString(fJson.toPath(), (CharSequence)s, new OpenOption[0]);
        }
        catch (Exception e) {
            BCLib.C.LOG.error("Error while saving json: " + e.getMessage());
            result.append((Component)Component.literal((String)("Error while saving json: " + fJson.toString())));
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> result, false);
        return 1;
    }

    private static void setExtrema(String property, long minTemperature, long maxTemperature, JsonObject root) {
        JsonObject jTemperature = new JsonObject();
        jTemperature.addProperty("min", (Number)minTemperature);
        jTemperature.addProperty("max", (Number)maxTemperature);
        root.add(property, (JsonElement)jTemperature);
    }

    static int dumpImageMaps(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel serverLevel = source.getLevel();
        Vec3 pos = source.getPosition();
        Path basePath = WorldState.storageAccess().getLevelPath(LevelResource.ROOT).resolve(BCLib.C.namespace).resolve("export").resolve(serverLevel.dimension().location().getPath()).normalize();
        RandomState randomState = serverLevel.getChunkSource().randomState();
        Climate.Sampler sampler = randomState.sampler();
        int x = QuartPos.fromBlock((int)((int)pos.x));
        int y = QuartPos.fromBlock((int)((int)pos.y));
        int z = QuartPos.fromBlock((int)((int)pos.z));
        int maxOffset = 128;
        MutableComponent result = Component.literal((String)("Wrote maps to " + basePath.toString() + ":\n")).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE));
        long minTemperature = Long.MAX_VALUE;
        long minHumidity = Long.MAX_VALUE;
        long minContinentalness = Long.MAX_VALUE;
        long minErosion = Long.MAX_VALUE;
        long minDepth = Long.MAX_VALUE;
        long minWeirdness = Long.MAX_VALUE;
        long maxTemperature = Long.MIN_VALUE;
        long maxHumidity = Long.MIN_VALUE;
        long maxContinentalness = Long.MIN_VALUE;
        long maxErosion = Long.MIN_VALUE;
        long maxDepth = Long.MIN_VALUE;
        long maxWeirdness = Long.MIN_VALUE;
        for (int ox = -maxOffset; ox <= maxOffset; ++ox) {
            for (int oz = -maxOffset; oz <= maxOffset; ++oz) {
                Climate.TargetPoint t = sampler.sample(x + ox, y, z + oz);
                if (t.temperature() < minTemperature) {
                    minTemperature = t.temperature();
                }
                if (t.humidity() < minHumidity) {
                    minHumidity = t.humidity();
                }
                if (t.continentalness() < minContinentalness) {
                    minContinentalness = t.continentalness();
                }
                if (t.erosion() < minErosion) {
                    minErosion = t.erosion();
                }
                if (t.depth() < minDepth) {
                    minDepth = t.depth();
                }
                if (t.weirdness() < minWeirdness) {
                    minWeirdness = t.weirdness();
                }
                if (t.temperature() > maxTemperature) {
                    maxTemperature = t.temperature();
                }
                if (t.humidity() > maxHumidity) {
                    maxHumidity = t.humidity();
                }
                if (t.continentalness() > maxContinentalness) {
                    maxContinentalness = t.continentalness();
                }
                if (t.erosion() > maxErosion) {
                    maxErosion = t.erosion();
                }
                if (t.depth() > maxDepth) {
                    maxDepth = t.depth();
                }
                if (t.weirdness() <= maxWeirdness) continue;
                maxWeirdness = t.weirdness();
            }
        }
        if (minTemperature == maxTemperature) {
            ++maxTemperature;
        }
        if (minHumidity == maxHumidity) {
            ++maxHumidity;
        }
        if (minContinentalness == maxContinentalness) {
            ++maxContinentalness;
        }
        if (minErosion == maxErosion) {
            ++maxErosion;
        }
        if (minDepth == maxDepth) {
            ++maxDepth;
        }
        if (minWeirdness == maxWeirdness) {
            ++maxWeirdness;
        }
        BufferedImage iTemperature = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        BufferedImage iHumidity = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        BufferedImage iContinentalness = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        BufferedImage iErosion = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        BufferedImage iDepth = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        BufferedImage iWeirdness = new BufferedImage(2 * maxOffset + 1, 2 * maxOffset + 1, 10);
        for (int ox = -maxOffset; ox <= maxOffset; ++ox) {
            for (int oz = -maxOffset; oz <= maxOffset; ++oz) {
                Climate.TargetPoint t = sampler.sample(x + ox, y, z + oz);
                int temperature = (int)((t.temperature() - minTemperature) * 255L / (maxTemperature - minTemperature));
                int humidity = (int)((t.humidity() - minHumidity) * 255L / (maxHumidity - minHumidity));
                int continentalness = (int)((t.continentalness() - minContinentalness) * 255L / (maxContinentalness - minContinentalness));
                int erosion = (int)((t.erosion() - minErosion) * 255L / (maxErosion - minErosion));
                int depth = (int)((t.depth() - minDepth) * 255L / (maxDepth - minDepth));
                int weirdness = (int)((t.weirdness() - minWeirdness) * 255L / (maxWeirdness - minWeirdness));
                iTemperature.setRGB(ox + maxOffset, oz + maxOffset, new Color(temperature, temperature, temperature).getRGB());
                iHumidity.setRGB(ox + maxOffset, oz + maxOffset, new Color(humidity, humidity, humidity).getRGB());
                iContinentalness.setRGB(ox + maxOffset, oz + maxOffset, new Color(continentalness, continentalness, continentalness).getRGB());
                iErosion.setRGB(ox + maxOffset, oz + maxOffset, new Color(erosion, erosion, erosion).getRGB());
                iDepth.setRGB(ox + maxOffset, oz + maxOffset, new Color(depth, depth, depth).getRGB());
                iWeirdness.setRGB(ox + maxOffset, oz + maxOffset, new Color(weirdness, weirdness, weirdness).getRGB());
            }
        }
        File fBasePath = basePath.toFile();
        if (!fBasePath.exists() && !fBasePath.mkdirs()) {
            BCLib.C.LOG.error("Error while creating directory: " + fBasePath.toString());
            result.append((Component)Component.literal((String)("Error while creating directory: " + fBasePath.toString())));
            return 1;
        }
        DumpMap.write(iTemperature, new File(basePath.toString() + "/temperature_" + minTemperature + "_" + maxTemperature + ".png"), result);
        DumpMap.write(iHumidity, new File(basePath.toString() + "/humidity_" + minHumidity + "_" + maxHumidity + ".png"), result);
        DumpMap.write(iContinentalness, new File(basePath.toString() + "/continentalness_" + minContinentalness + "_" + maxContinentalness + ".png"), result);
        DumpMap.write(iErosion, new File(basePath.toString() + "/erosion_" + minErosion + "_" + maxErosion + ".png"), result);
        DumpMap.write(iDepth, new File(basePath.toString() + "/depth_" + minDepth + "_" + maxDepth + ".png"), result);
        DumpMap.write(iWeirdness, new File(basePath.toString() + "/weirdness_" + minWeirdness + "_" + maxWeirdness + ".png"), result);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> result, false);
        return 1;
    }

    private static void write(BufferedImage iTemperature, File fTemperature, MutableComponent result) {
        try {
            ImageIO.write((RenderedImage)iTemperature, "png", fTemperature);
        }
        catch (IOException e) {
            BCLib.C.LOG.error("Error while saving image: " + e.getMessage());
            result.append((Component)Component.literal((String)("Error while saving image: " + fTemperature.toString())));
        }
    }
}

