/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.QuartPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.phys.Vec3;

public class PrintInfo {
    public static LiteralArgumentBuilder<CommandSourceStack> register(LiteralArgumentBuilder<CommandSourceStack> bnContext) {
        return (LiteralArgumentBuilder)bnContext.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"print").requires(source -> source.hasPermission(4))).then(((LiteralArgumentBuilder)Commands.literal((String)"dimensions").requires(source -> source.hasPermission(4))).executes(PrintInfo::printDimensions))).then(((LiteralArgumentBuilder)Commands.literal((String)"climate").requires(source -> source.hasPermission(4))).executes(PrintInfo::printMapValues)));
    }

    static int printDimensions(CommandContext<CommandSourceStack> ctx) {
        MutableComponent result = Component.literal((String)"World Dimensions: ").setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE));
        for (ServerLevel serverLevel : ((CommandSourceStack)ctx.getSource()).getLevel().getServer().getAllLevels()) {
            ChunkGenerator generator = serverLevel.getChunkSource().getGenerator();
            String output = "\n - " + serverLevel.dimension().location().toString() + ": \n     " + generator.toString().trim() + " " + generator.getBiomeSource().toString().replace("\n", "\n     ");
            ChatFormatting cl = ChatFormatting.LIGHT_PURPLE;
            if (serverLevel.dimension().location().equals((Object)Level.OVERWORLD.location())) {
                cl = ChatFormatting.WHITE;
            } else if (serverLevel.dimension().location().equals((Object)Level.NETHER.location())) {
                cl = ChatFormatting.RED;
            }
            if (serverLevel.dimension().location().equals((Object)Level.END.location())) {
                cl = ChatFormatting.YELLOW;
            }
            MutableComponent dimComponent = Component.literal((String)output).setStyle(Style.EMPTY.withBold(Boolean.valueOf(false)).withColor(cl));
            result.append((Component)dimComponent);
        }
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> result, false);
        return 1;
    }

    static int printMapValues(CommandContext<CommandSourceStack> ctx) {
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        ServerLevel serverLevel = source.getLevel();
        Vec3 pos = source.getPosition();
        RandomState randomState = serverLevel.getChunkSource().randomState();
        Climate.Sampler sampler = randomState.sampler();
        Climate.TargetPoint sample = sampler.sample(QuartPos.fromBlock((int)((int)pos.x)), QuartPos.fromBlock((int)((int)pos.y)), QuartPos.fromBlock((int)((int)pos.z)));
        MutableComponent result = Component.literal((String)("Samples for " + pos.toString() + " in " + serverLevel.dimension().location().toString() + ":\n")).setStyle(Style.EMPTY.withBold(Boolean.valueOf(true)).withColor(ChatFormatting.BLUE));
        StringBuilder output = new StringBuilder();
        output.append("temperature: ").append(sample.temperature()).append("\n");
        output.append("humidity: ").append(sample.humidity()).append("\n");
        output.append("continentalness: ").append(sample.continentalness()).append("\n");
        output.append("erosion: ").append(sample.erosion()).append("\n");
        output.append("depth: ").append(sample.depth()).append("\n");
        output.append("weirdness: ").append(sample.weirdness()).append("\n");
        result.append((Component)Component.literal((String)output.toString()).setStyle(Style.EMPTY.withBold(Boolean.valueOf(false)).withColor(ChatFormatting.WHITE)));
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> result, false);
        return 1;
    }
}

