/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.complexmaterials.set.wood;

import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import org.betterx.bclib.blocks.BaseRotatedPillarBlock;
import org.betterx.bclib.complexmaterials.ComplexMaterial;
import org.betterx.bclib.complexmaterials.WoodenComplexMaterial;
import org.betterx.bclib.complexmaterials.entry.BlockEntry;
import org.betterx.bclib.complexmaterials.entry.SimpleMaterialSlot;
import org.betterx.bclib.complexmaterials.set.wood.WoodSlots;
import org.betterx.wover.recipe.api.CraftingRecipeBuilder;
import org.betterx.wover.recipe.api.RecipeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StrippedLog
extends SimpleMaterialSlot<WoodenComplexMaterial> {
    protected StrippedLog() {
        super("stripped_log");
    }

    @Override
    @NotNull
    protected Block createBlock(WoodenComplexMaterial parentMaterial, BlockBehaviour.Properties settings) {
        return new BaseRotatedPillarBlock.Wood(settings, parentMaterial.woodType.flammable);
    }

    @Override
    protected void modifyBlockEntry(WoodenComplexMaterial parentMaterial, @NotNull BlockEntry entry) {
        if (parentMaterial.woodType.flammable) {
            entry.setBlockTags(BlockTags.LOGS, BlockTags.LOGS_THAT_BURN, parentMaterial.getBlockTag("logs")).setItemTags(ItemTags.LOGS, ItemTags.LOGS_THAT_BURN, parentMaterial.getItemTag("logs"));
        } else {
            entry.setBlockTags(BlockTags.LOGS, parentMaterial.getBlockTag("logs")).setItemTags(ItemTags.LOGS, parentMaterial.getItemTag("logs"));
        }
    }

    @Override
    @Nullable
    protected void makeRecipe(RecipeOutput context, ComplexMaterial material, ResourceLocation id) {
        CraftingRecipeBuilder craftingRecipeBuilder1 = RecipeBuilder.crafting((ResourceLocation)id, (ItemLike)material.getBlock(this.suffix));
        CraftingRecipeBuilder craftingRecipeBuilder = craftingRecipeBuilder1.shape(new String[]{"##", "##"}).addMaterial('#', new ItemLike[]{material.getBlock(WoodSlots.STRIPPED_BARK)});
        CraftingRecipeBuilder craftingRecipeBuilderBaseRecipeBuilder = craftingRecipeBuilder.outputCount(3);
        ((CraftingRecipeBuilder)craftingRecipeBuilderBaseRecipeBuilder.category(RecipeCategory.BUILDING_BLOCKS)).build(context);
    }
}

