/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.furniture.block;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.behaviours.BehaviourHelper;
import org.betterx.bclib.behaviours.interfaces.BehaviourMetal;
import org.betterx.bclib.behaviours.interfaces.BehaviourStone;
import org.betterx.bclib.behaviours.interfaces.BehaviourWood;
import org.betterx.bclib.client.models.BCLModels;
import org.betterx.bclib.furniture.block.AbstractChair;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;
import org.jetbrains.annotations.NotNull;

public abstract class BaseBarStool
extends AbstractChair {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public final Block clothMaterial;

    public BaseBarStool(Block baseMaterial, Block clothMaterial) {
        super(baseMaterial, 15);
        this.clothMaterial = Objects.requireNonNull(clothMaterial, "Bar Stool cloth material cannot be null");
    }

    @Deprecated(forRemoval=true)
    public BaseBarStool(Block baseMaterial) {
        this(baseMaterial, Blocks.RED_WOOL);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return SHAPE;
    }

    @Deprecated(forRemoval=true)
    public static BaseBarStool from(Block source) {
        return BehaviourHelper.from(source, Wood::new, Stone::new, Metal::new);
    }

    public static BaseBarStool from(Block baseMaterial, Block clothMaterial) {
        return BehaviourHelper.from(baseMaterial, b -> new Wood((Block)b, clothMaterial), b -> new Stone((Block)b, clothMaterial), b -> new Metal((Block)b, clothMaterial));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void provideBlockModels(WoverBlockModelGenerators generator) {
        BCLModels.createBarStoolBlockModel(generator, this, this.baseMaterial, this.clothMaterial);
    }

    public static class Metal
    extends BaseBarStool
    implements BehaviourMetal {
        @Deprecated(forRemoval=true)
        public Metal(Block baseMaterial) {
            super(baseMaterial, Blocks.RED_WOOL);
        }

        public Metal(Block baseMaterial, Block clothMaterial) {
            super(baseMaterial, clothMaterial);
        }
    }

    public static class Stone
    extends BaseBarStool
    implements BehaviourStone {
        @Deprecated(forRemoval=true)
        public Stone(Block baseMaterial) {
            super(baseMaterial, Blocks.RED_WOOL);
        }

        public Stone(Block baseMaterial, Block clothMaterial) {
            super(baseMaterial, clothMaterial);
        }
    }

    public static class Wood
    extends BaseBarStool
    implements BehaviourWood {
        @Deprecated(forRemoval=true)
        public Wood(Block baseMaterial) {
            super(baseMaterial, Blocks.RED_WOOL);
        }

        public Wood(Block baseMaterial, Block clothMaterial) {
            super(baseMaterial, clothMaterial);
        }
    }
}

