/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.integration.emi;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.betterx.bclib.blocks.LeveledAnvilBlock;
import org.betterx.bclib.util.RomanNumeral;
import org.joml.Matrix4f;

public class EMIAnvilRecipeCategory
extends EmiRecipeCategory {
    private final int anvilLevel;
    private final List<FormattedCharSequence> titleLines;

    public EMIAnvilRecipeCategory(ResourceLocation id, EmiRenderable icon, int anvilLevel) {
        super(id, icon);
        this.anvilLevel = anvilLevel;
        this.titleLines = LeveledAnvilBlock.getNamesForLevel(anvilLevel);
    }

    public EMIAnvilRecipeCategory(ResourceLocation id, EmiRenderable icon, EmiRenderable simplified, int anvilLevel) {
        super(id, icon, simplified);
        this.anvilLevel = anvilLevel;
        this.titleLines = LeveledAnvilBlock.getNamesForLevel(anvilLevel);
    }

    public EMIAnvilRecipeCategory(ResourceLocation id, EmiRenderable icon, EmiTexture simplified, Comparator<EmiRecipe> sorter, int anvilLevel) {
        super(id, icon, (EmiRenderable)simplified, sorter);
        this.anvilLevel = anvilLevel;
        this.titleLines = LeveledAnvilBlock.getNamesForLevel(anvilLevel);
    }

    public void renderSimplified(GuiGraphics guiGraphics, int x, int y, float delta) {
        super.renderSimplified(guiGraphics, x, y, delta);
        Font font = Minecraft.getInstance().font;
        String content = RomanNumeral.toRoman(this.anvilLevel);
        MultiBufferSource.BufferSource bufferSource = guiGraphics.bufferSource();
        int xx = x + 19 - 2 - font.width(content);
        int yy = y + 6 + 3;
        Matrix4f matrix = guiGraphics.pose().last().pose();
        font.drawInBatch(content, (float)(xx - 1), (float)(yy - 1), -16777216, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch(content, (float)xx, (float)(yy - 1), -16777216, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch(content, (float)(xx + 1), (float)(yy - 1), -16777216, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch(content, (float)(xx - 1), (float)yy, -16777216, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch(content, (float)(xx + 1), (float)yy, -16777216, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch(content, (float)(xx - 1), (float)(yy + 1), -16777216, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch(content, (float)(xx + 1), (float)(yy + 1), -16777216, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch(content, (float)xx, (float)(yy + 1), -16777216, false, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        font.drawInBatch(content, (float)xx, (float)yy, -1, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        bufferSource.endBatch();
    }

    public List<ClientTooltipComponent> getTooltip() {
        List list = super.getTooltip();
        if (!this.titleLines.isEmpty()) {
            ArrayList newList = Lists.newArrayList();
            for (FormattedCharSequence line : this.titleLines) {
                newList.add(ClientTooltipComponent.create((FormattedCharSequence)line));
            }
            if (list.size() > 0) {
                list.remove(0);
            }
            newList.addAll(list);
            return newList;
        }
        return list;
    }
}

