/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.interfaces;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.betterx.bclib.config.Configs;
import org.betterx.bclib.interfaces.SurvivesOn;

public interface SurvivesOnSpecialGround
extends SurvivesOn {
    public String getSurvivableBlocksString();

    default public String prefixComponent() {
        return "tooltip.bclib.place_on";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static List<String> splitLines(String input) {
        int idx;
        int MAX_LEN = 45;
        ArrayList lines = Lists.newArrayList();
        while (input.length() > 45 && (idx = input.lastIndexOf(",", 45)) >= 0) {
            lines.add(input.substring(0, idx + 1).trim());
            input = input.substring(idx + 1).trim();
        }
        lines.add(input.trim());
        return lines;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void appendHoverText(SurvivesOnSpecialGround surv, List<Component> list) {
        if (!Configs.CLIENT_CONFIG.survivesOnHint()) {
            return;
        }
        int MAX_LINES = 7;
        String description = surv.getSurvivableBlocksString();
        List<String> lines = SurvivesOnSpecialGround.splitLines(description);
        if (lines.size() == 1) {
            list.add((Component)Component.translatable((String)surv.prefixComponent(), (Object[])new Object[]{lines.get(0)}).withStyle(ChatFormatting.GREEN));
        } else if (lines.size() > 1) {
            list.add((Component)Component.translatable((String)surv.prefixComponent(), (Object[])new Object[]{""}).withStyle(ChatFormatting.GREEN));
            for (int i = 0; i < Math.min(lines.size(), 7); ++i) {
                Object line = lines.get(i);
                if (i == 6 && i < lines.size() - 1) {
                    line = (String)line + " ...";
                }
                list.add((Component)Component.literal((String)("  " + (String)line)).withStyle(ChatFormatting.GREEN));
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void appendHoverTextUnderwater(List<Component> list) {
        list.add((Component)Component.translatable((String)"tooltip.bclib.place_underwater").withStyle(ChatFormatting.GREEN));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void appendHoverTextUnderwaterInDepth(List<Component> list, int depth) {
        list.add((Component)Component.translatable((String)"tooltip.bclib.place_underwater_depth", (Object[])new Object[]{depth}).withStyle(ChatFormatting.GREEN));
    }

    default public boolean canSurviveOnTop(LevelReader world, BlockPos pos) {
        return this.isSurvivable(world.getBlockState(pos.below()));
    }

    default public boolean canSurviveOnBottom(LevelReader world, BlockPos pos) {
        return this.isSurvivable(world.getBlockState(pos.above()));
    }

    default public boolean isTerrain(BlockState state) {
        return this.isSurvivable(state);
    }
}

