/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.betterend.blocks;

import com.google.common.collect.Maps;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.data.models.blockstates.BlockStateGenerator;
import net.minecraft.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.data.models.blockstates.PropertyDispatch;
import net.minecraft.data.models.blockstates.Variant;
import net.minecraft.data.models.blockstates.VariantProperties;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.betterx.bclib.blocks.BaseAttachedBlock;
import org.betterx.bclib.client.render.BCLRenderLayer;
import org.betterx.bclib.interfaces.RenderLayerProvider;
import org.betterx.betterend.client.models.EndModels;
import org.betterx.wover.block.api.model.BlockModelProvider;
import org.betterx.wover.block.api.model.WoverBlockModelGenerators;

public class ChandelierBlock
extends BaseAttachedBlock.Metal
implements RenderLayerProvider,
BlockModelProvider {
    private static final EnumMap<Direction, VoxelShape> BOUNDING_SHAPES = Maps.newEnumMap(Direction.class);

    public ChandelierBlock(Block source) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)source).lightLevel(bs -> 15).noCollission().noOcclusion().requiresCorrectToolForDrops());
    }

    public BCLRenderLayer getRenderLayer() {
        return BCLRenderLayer.CUTOUT;
    }

    public VoxelShape getShape(BlockState state, BlockGetter view, BlockPos pos, CollisionContext ePos) {
        return BOUNDING_SHAPES.get(state.getValue((Property)FACING));
    }

    public void provideBlockModels(WoverBlockModelGenerators generator) {
        ResourceLocation baseTexture = TextureMapping.getBlockTexture((Block)this);
        TextureMapping mapping = new TextureMapping().put(EndModels.WALL, baseTexture.withSuffix("_wall")).put(EndModels.FLOOR, baseTexture.withSuffix("_floor")).put(EndModels.CEIL, baseTexture.withSuffix("_ceil"));
        ResourceLocation modelCeil = EndModels.CHANDELIER_CEIL.createWithSuffix((Block)this, "_ceil", mapping, generator.modelOutput());
        ResourceLocation modelWall = EndModels.CHANDELIER_WALL.createWithSuffix((Block)this, "_wall", mapping, generator.modelOutput());
        ResourceLocation modelFloor = EndModels.CHANDELIER_FLOOR.createWithSuffix((Block)this, "_floor", mapping, generator.modelOutput());
        PropertyDispatch.C1 prop = PropertyDispatch.property((Property)FACING);
        prop.select((Comparable)Direction.DOWN, Variant.variant().with(VariantProperties.MODEL, (Object)modelCeil));
        prop.select((Comparable)Direction.UP, Variant.variant().with(VariantProperties.MODEL, (Object)modelFloor));
        prop.select((Comparable)Direction.EAST, Variant.variant().with(VariantProperties.MODEL, (Object)modelWall).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270));
        prop.select((Comparable)Direction.SOUTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelWall));
        prop.select((Comparable)Direction.WEST, Variant.variant().with(VariantProperties.MODEL, (Object)modelWall).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90));
        prop.select((Comparable)Direction.NORTH, Variant.variant().with(VariantProperties.MODEL, (Object)modelWall).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180));
        generator.acceptBlockState((BlockStateGenerator)MultiVariantGenerator.multiVariant((Block)this).with((PropertyDispatch)prop));
        generator.delegateItemModel((Block)this, modelCeil);
    }

    static {
        BOUNDING_SHAPES.put(Direction.UP, Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)13.0, (double)11.0));
        BOUNDING_SHAPES.put(Direction.DOWN, Block.box((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0));
        BOUNDING_SHAPES.put(Direction.NORTH, Shapes.box((double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.SOUTH, Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5));
        BOUNDING_SHAPES.put(Direction.WEST, Shapes.box((double)0.5, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0));
        BOUNDING_SHAPES.put(Direction.EAST, Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)1.0, (double)1.0));
    }
}

